<?php

namespace Shop\Infrastructure\Models\Order\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Infrastructure\Models\Order\ShopOrdersArchive;
use Shop\Infrastructure\Models\Order\ShopOrdersArchiveQuery;


/**
 * This class defines the structure of the 'shop_orders_archive' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class ShopOrdersArchiveTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'Models.Order.Map.ShopOrdersArchiveTableMap';

    /**
     * The default database name for this class
     */
    const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    const TABLE_NAME = 'shop_orders_archive';

    /**
     * The related Propel class for this table
     */
    const OM_CLASS = '\\Shop\\Models\\Order\\ShopOrdersArchive';

    /**
     * A class that can be returned by this tableMap
     */
    const CLASS_DEFAULT = 'Models.Order.ShopOrdersArchive';

    /**
     * The total number of columns
     */
    const NUM_COLUMNS = 15;

    /**
     * The number of lazy-loaded columns
     */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    const NUM_HYDRATE_COLUMNS = 15;

    /**
     * the column name for the id field
     */
    const COL_ID = 'shop_orders_archive.id';

    /**
     * the column name for the type_id field
     */
    const COL_TYPE_ID = 'shop_orders_archive.type_id';

    /**
     * the column name for the customer_id field
     */
    const COL_CUSTOMER_ID = 'shop_orders_archive.customer_id';

    /**
     * the column name for the contractor_id field
     */
    const COL_CONTRACTOR_ID = 'shop_orders_archive.contractor_id';

    /**
     * the column name for the datetime field
     */
    const COL_DATETIME = 'shop_orders_archive.datetime';

    /**
     * the column name for the udatetime field
     */
    const COL_UDATETIME = 'shop_orders_archive.udatetime';

    /**
     * the column name for the discount_summ field
     */
    const COL_DISCOUNT_SUMM = 'shop_orders_archive.discount_summ';

    /**
     * the column name for the reload field
     */
    const COL_RELOAD = 'shop_orders_archive.reload';

    /**
     * the column name for the delivery_address field
     */
    const COL_DELIVERY_ADDRESS = 'shop_orders_archive.delivery_address';

    /**
     * the column name for the payment_id field
     */
    const COL_PAYMENT_ID = 'shop_orders_archive.payment_id';

    /**
     * the column name for the state_id field
     */
    const COL_STATE_ID = 'shop_orders_archive.state_id';

    /**
     * the column name for the comment field
     */
    const COL_COMMENT = 'shop_orders_archive.comment';

    /**
     * the column name for the post_code field
     */
    const COL_POST_CODE = 'shop_orders_archive.post_code';

    /**
     * the column name for the shop_id field
     */
    const COL_SHOP_ID = 'shop_orders_archive.shop_id';

    /**
     * the column name for the archived_at field
     */
    const COL_ARCHIVED_AT = 'shop_orders_archive.archived_at';

    /**
     * The default string format for model objects of the related table
     */
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        self::TYPE_PHPNAME       => array('Id', 'TypeId', 'CustomerId', 'ContractorId', 'Datetime', 'UDatetime', 'DiscountSumm', 'Reload', 'DeliveryAddress', 'PaymentId', 'StateId', 'Comment', 'PostCode', 'ShopId', 'ArchivedAt', ),
        self::TYPE_CAMELNAME     => array('id', 'typeId', 'customerId', 'contractorId', 'datetime', 'uDatetime', 'discountSumm', 'reload', 'deliveryAddress', 'paymentId', 'stateId', 'comment', 'postCode', 'shopId', 'archivedAt', ),
        self::TYPE_COLNAME       => array(ShopOrdersArchiveTableMap::COL_ID, ShopOrdersArchiveTableMap::COL_TYPE_ID, ShopOrdersArchiveTableMap::COL_CUSTOMER_ID, ShopOrdersArchiveTableMap::COL_CONTRACTOR_ID, ShopOrdersArchiveTableMap::COL_DATETIME, ShopOrdersArchiveTableMap::COL_UDATETIME, ShopOrdersArchiveTableMap::COL_DISCOUNT_SUMM, ShopOrdersArchiveTableMap::COL_RELOAD, ShopOrdersArchiveTableMap::COL_DELIVERY_ADDRESS, ShopOrdersArchiveTableMap::COL_PAYMENT_ID, ShopOrdersArchiveTableMap::COL_STATE_ID, ShopOrdersArchiveTableMap::COL_COMMENT, ShopOrdersArchiveTableMap::COL_POST_CODE, ShopOrdersArchiveTableMap::COL_SHOP_ID, ShopOrdersArchiveTableMap::COL_ARCHIVED_AT, ),
        self::TYPE_FIELDNAME     => array('id', 'type_id', 'customer_id', 'contractor_id', 'datetime', 'udatetime', 'discount_summ', 'reload', 'delivery_address', 'payment_id', 'state_id', 'comment', 'post_code', 'shop_id', 'archived_at', ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        self::TYPE_PHPNAME       => array('Id' => 0, 'TypeId' => 1, 'CustomerId' => 2, 'ContractorId' => 3, 'Datetime' => 4, 'UDatetime' => 5, 'DiscountSumm' => 6, 'Reload' => 7, 'DeliveryAddress' => 8, 'PaymentId' => 9, 'StateId' => 10, 'Comment' => 11, 'PostCode' => 12, 'ShopId' => 13, 'ArchivedAt' => 14, ),
        self::TYPE_CAMELNAME     => array('id' => 0, 'typeId' => 1, 'customerId' => 2, 'contractorId' => 3, 'datetime' => 4, 'uDatetime' => 5, 'discountSumm' => 6, 'reload' => 7, 'deliveryAddress' => 8, 'paymentId' => 9, 'stateId' => 10, 'comment' => 11, 'postCode' => 12, 'shopId' => 13, 'archivedAt' => 14, ),
        self::TYPE_COLNAME       => array(ShopOrdersArchiveTableMap::COL_ID => 0, ShopOrdersArchiveTableMap::COL_TYPE_ID => 1, ShopOrdersArchiveTableMap::COL_CUSTOMER_ID => 2, ShopOrdersArchiveTableMap::COL_CONTRACTOR_ID => 3, ShopOrdersArchiveTableMap::COL_DATETIME => 4, ShopOrdersArchiveTableMap::COL_UDATETIME => 5, ShopOrdersArchiveTableMap::COL_DISCOUNT_SUMM => 6, ShopOrdersArchiveTableMap::COL_RELOAD => 7, ShopOrdersArchiveTableMap::COL_DELIVERY_ADDRESS => 8, ShopOrdersArchiveTableMap::COL_PAYMENT_ID => 9, ShopOrdersArchiveTableMap::COL_STATE_ID => 10, ShopOrdersArchiveTableMap::COL_COMMENT => 11, ShopOrdersArchiveTableMap::COL_POST_CODE => 12, ShopOrdersArchiveTableMap::COL_SHOP_ID => 13, ShopOrdersArchiveTableMap::COL_ARCHIVED_AT => 14, ),
        self::TYPE_FIELDNAME     => array('id' => 0, 'type_id' => 1, 'customer_id' => 2, 'contractor_id' => 3, 'datetime' => 4, 'udatetime' => 5, 'discount_summ' => 6, 'reload' => 7, 'delivery_address' => 8, 'payment_id' => 9, 'state_id' => 10, 'comment' => 11, 'post_code' => 12, 'shop_id' => 13, 'archived_at' => 14, ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, )
    );

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('shop_orders_archive');
        $this->setPhpName('ShopOrdersArchive');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Models\\Order\\ShopOrdersArchive');
        $this->setPackage('Models.Order');
        $this->setUseIdGenerator(false);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('type_id', 'TypeId', 'INTEGER', true, null, 1);
        $this->addColumn('customer_id', 'CustomerId', 'INTEGER', true, null, null);
        $this->addColumn('contractor_id', 'ContractorId', 'INTEGER', true, null, null);
        $this->addColumn('datetime', 'Datetime', 'TIMESTAMP', true, null, 'CURRENT_TIMESTAMP');
        $this->addColumn('udatetime', 'UDatetime', 'TIMESTAMP', false, null, null);
        $this->addColumn('discount_summ', 'DiscountSumm', 'DECIMAL', false, 19, 0);
        $this->addColumn('reload', 'Reload', 'CHAR', true, null, 'N');
        $this->addColumn('delivery_address', 'DeliveryAddress', 'LONGVARCHAR', false, null, null);
        $this->addColumn('payment_id', 'PaymentId', 'INTEGER', true, null, null);
        $this->addColumn('state_id', 'StateId', 'INTEGER', true, null, null);
        $this->addColumn('comment', 'Comment', 'LONGVARCHAR', false, null, null);
        $this->addColumn('post_code', 'PostCode', 'VARCHAR', false, 100, null);
        $this->addColumn('shop_id', 'ShopId', 'INTEGER', false, null, null);
        $this->addColumn('archived_at', 'ArchivedAt', 'TIMESTAMP', false, null, null);
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
    } // buildRelations()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param boolean $withPrefix Whether or not to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass($withPrefix = true)
    {
        return $withPrefix ? ShopOrdersArchiveTableMap::CLASS_DEFAULT : ShopOrdersArchiveTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array  $row       row returned by DataFetcher->fetch().
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array           (ShopOrdersArchive object, last column rank)
     */
    public static function populateObject($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        $key = ShopOrdersArchiveTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = ShopOrdersArchiveTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + ShopOrdersArchiveTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = ShopOrdersArchiveTableMap::OM_CLASS;
            /** @var ShopOrdersArchive $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            ShopOrdersArchiveTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = ShopOrdersArchiveTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = ShopOrdersArchiveTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var ShopOrdersArchive $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                ShopOrdersArchiveTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria object containing the columns to add.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(ShopOrdersArchiveTableMap::COL_ID);
            $criteria->addSelectColumn(ShopOrdersArchiveTableMap::COL_TYPE_ID);
            $criteria->addSelectColumn(ShopOrdersArchiveTableMap::COL_CUSTOMER_ID);
            $criteria->addSelectColumn(ShopOrdersArchiveTableMap::COL_CONTRACTOR_ID);
            $criteria->addSelectColumn(ShopOrdersArchiveTableMap::COL_DATETIME);
            $criteria->addSelectColumn(ShopOrdersArchiveTableMap::COL_UDATETIME);
            $criteria->addSelectColumn(ShopOrdersArchiveTableMap::COL_DISCOUNT_SUMM);
            $criteria->addSelectColumn(ShopOrdersArchiveTableMap::COL_RELOAD);
            $criteria->addSelectColumn(ShopOrdersArchiveTableMap::COL_DELIVERY_ADDRESS);
            $criteria->addSelectColumn(ShopOrdersArchiveTableMap::COL_PAYMENT_ID);
            $criteria->addSelectColumn(ShopOrdersArchiveTableMap::COL_STATE_ID);
            $criteria->addSelectColumn(ShopOrdersArchiveTableMap::COL_COMMENT);
            $criteria->addSelectColumn(ShopOrdersArchiveTableMap::COL_POST_CODE);
            $criteria->addSelectColumn(ShopOrdersArchiveTableMap::COL_SHOP_ID);
            $criteria->addSelectColumn(ShopOrdersArchiveTableMap::COL_ARCHIVED_AT);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.type_id');
            $criteria->addSelectColumn($alias . '.customer_id');
            $criteria->addSelectColumn($alias . '.contractor_id');
            $criteria->addSelectColumn($alias . '.datetime');
            $criteria->addSelectColumn($alias . '.udatetime');
            $criteria->addSelectColumn($alias . '.discount_summ');
            $criteria->addSelectColumn($alias . '.reload');
            $criteria->addSelectColumn($alias . '.delivery_address');
            $criteria->addSelectColumn($alias . '.payment_id');
            $criteria->addSelectColumn($alias . '.state_id');
            $criteria->addSelectColumn($alias . '.comment');
            $criteria->addSelectColumn($alias . '.post_code');
            $criteria->addSelectColumn($alias . '.shop_id');
            $criteria->addSelectColumn($alias . '.archived_at');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getServiceContainer()->getDatabaseMap(ShopOrdersArchiveTableMap::DATABASE_NAME)->getTable(ShopOrdersArchiveTableMap::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this tableMap class.
     */
    public static function buildTableMap()
    {
        $dbMap = Propel::getServiceContainer()->getDatabaseMap(ShopOrdersArchiveTableMap::DATABASE_NAME);
        if (!$dbMap->hasTable(ShopOrdersArchiveTableMap::TABLE_NAME)) {
            $dbMap->addTableObject(new ShopOrdersArchiveTableMap());
        }
    }

    /**
     * Performs a DELETE on the database, given a ShopOrdersArchive or Criteria object OR a primary key value.
     *
     * @param mixed               $values Criteria or ShopOrdersArchive object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param  ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ConnectionInterface $con = null)
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopOrdersArchiveTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Infrastructure\Models\Order\ShopOrdersArchive) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(ShopOrdersArchiveTableMap::DATABASE_NAME);
            $criteria->add(ShopOrdersArchiveTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = ShopOrdersArchiveQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            ShopOrdersArchiveTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                ShopOrdersArchiveTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_orders_archive table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(ConnectionInterface $con = null)
    {
        return ShopOrdersArchiveQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a ShopOrdersArchive or Criteria object.
     *
     * @param mixed               $criteria Criteria or ShopOrdersArchive object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopOrdersArchiveTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from ShopOrdersArchive object
        }


        // Set the correct dbName
        $query = ShopOrdersArchiveQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

} // ShopOrdersArchiveTableMap
// This is the static code needed to register the TableMap for this table with the main Propel class.
//
ShopOrdersArchiveTableMap::buildTableMap();
