<?php

namespace Shop\Domain\Brand;

use Core\Repository\DropDownInterface;
use Repo\Concrete\AbstractCollection;
use Shop\Domain\Brand\Contracts\BrandEntityInterface;

/**
* Description of Brand
*
* @author Diamond Code Generator
*/
class BrandCollection extends AbstractCollection implements DropDownInterface
{

    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return BrandEntityInterface::class;
    }

    public function getDropdownList(): array
    {
        $ar = [];
        foreach ($this->_entities as $entity) {
            $ar[$entity->getId()] = $entity->getName();
        }

        return $ar;
    }


}               