<?php

namespace Shop\Infrastructure\Models\PaymentTransaction\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Infrastructure\Models\Order\Order;
use Shop\Infrastructure\Models\PaymentTransaction\PaymentTransaction as ChildPaymentTransaction;
use Shop\Infrastructure\Models\PaymentTransaction\PaymentTransactionQuery as ChildPaymentTransactionQuery;
use Shop\Infrastructure\Models\PaymentTransaction\Map\PaymentTransactionTableMap;

/**
 * Base class that represents a query for the 'shop_payment_transactions' table.
 *
 *
 *
 * @method     ChildPaymentTransactionQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildPaymentTransactionQuery orderByCode($order = Criteria::ASC) Order by the code column
 * @method     ChildPaymentTransactionQuery orderByDatetime($order = Criteria::ASC) Order by the datetime column
 * @method     ChildPaymentTransactionQuery orderByUDatetime($order = Criteria::ASC) Order by the udatetime column
 * @method     ChildPaymentTransactionQuery orderByOrderSumm($order = Criteria::ASC) Order by the order_summ column
 * @method     ChildPaymentTransactionQuery orderByPayedSumm($order = Criteria::ASC) Order by the payed_summ column
 * @method     ChildPaymentTransactionQuery orderByConfirmed($order = Criteria::ASC) Order by the confirmed column
 * @method     ChildPaymentTransactionQuery orderByResult($order = Criteria::ASC) Order by the result column
 * @method     ChildPaymentTransactionQuery orderByDesc($order = Criteria::ASC) Order by the desc column
 * @method     ChildPaymentTransactionQuery orderByCommission($order = Criteria::ASC) Order by the commission column
 * @method     ChildPaymentTransactionQuery orderByOrderId($order = Criteria::ASC) Order by the order_id column
 * @method     ChildPaymentTransactionQuery orderByCurrency($order = Criteria::ASC) Order by the currency column
 *
 * @method     ChildPaymentTransactionQuery groupById() Group by the id column
 * @method     ChildPaymentTransactionQuery groupByCode() Group by the code column
 * @method     ChildPaymentTransactionQuery groupByDatetime() Group by the datetime column
 * @method     ChildPaymentTransactionQuery groupByUDatetime() Group by the udatetime column
 * @method     ChildPaymentTransactionQuery groupByOrderSumm() Group by the order_summ column
 * @method     ChildPaymentTransactionQuery groupByPayedSumm() Group by the payed_summ column
 * @method     ChildPaymentTransactionQuery groupByConfirmed() Group by the confirmed column
 * @method     ChildPaymentTransactionQuery groupByResult() Group by the result column
 * @method     ChildPaymentTransactionQuery groupByDesc() Group by the desc column
 * @method     ChildPaymentTransactionQuery groupByCommission() Group by the commission column
 * @method     ChildPaymentTransactionQuery groupByOrderId() Group by the order_id column
 * @method     ChildPaymentTransactionQuery groupByCurrency() Group by the currency column
 *
 * @method     ChildPaymentTransactionQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildPaymentTransactionQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildPaymentTransactionQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildPaymentTransactionQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildPaymentTransactionQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildPaymentTransactionQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildPaymentTransactionQuery leftJoinOrder($relationAlias = null) Adds a LEFT JOIN clause to the query using the Order relation
 * @method     ChildPaymentTransactionQuery rightJoinOrder($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Order relation
 * @method     ChildPaymentTransactionQuery innerJoinOrder($relationAlias = null) Adds a INNER JOIN clause to the query using the Order relation
 *
 * @method     ChildPaymentTransactionQuery joinWithOrder($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Order relation
 *
 * @method     ChildPaymentTransactionQuery leftJoinWithOrder() Adds a LEFT JOIN clause and with to the query using the Order relation
 * @method     ChildPaymentTransactionQuery rightJoinWithOrder() Adds a RIGHT JOIN clause and with to the query using the Order relation
 * @method     ChildPaymentTransactionQuery innerJoinWithOrder() Adds a INNER JOIN clause and with to the query using the Order relation
 *
 * @method     \Shop\Infrastructure\Models\Order\OrderQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildPaymentTransaction|null findOne(?ConnectionInterface $con = null) Return the first ChildPaymentTransaction matching the query
 * @method     ChildPaymentTransaction findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildPaymentTransaction matching the query, or a new ChildPaymentTransaction object populated from the query conditions when no match is found
 *
 * @method     ChildPaymentTransaction|null findOneById(int $id) Return the first ChildPaymentTransaction filtered by the id column
 * @method     ChildPaymentTransaction|null findOneByCode(string $code) Return the first ChildPaymentTransaction filtered by the code column
 * @method     ChildPaymentTransaction|null findOneByDatetime(string $datetime) Return the first ChildPaymentTransaction filtered by the datetime column
 * @method     ChildPaymentTransaction|null findOneByUDatetime(string $udatetime) Return the first ChildPaymentTransaction filtered by the udatetime column
 * @method     ChildPaymentTransaction|null findOneByOrderSumm(string $order_summ) Return the first ChildPaymentTransaction filtered by the order_summ column
 * @method     ChildPaymentTransaction|null findOneByPayedSumm(string $payed_summ) Return the first ChildPaymentTransaction filtered by the payed_summ column
 * @method     ChildPaymentTransaction|null findOneByConfirmed(string $confirmed) Return the first ChildPaymentTransaction filtered by the confirmed column
 * @method     ChildPaymentTransaction|null findOneByResult(string $result) Return the first ChildPaymentTransaction filtered by the result column
 * @method     ChildPaymentTransaction|null findOneByDesc(string $desc) Return the first ChildPaymentTransaction filtered by the desc column
 * @method     ChildPaymentTransaction|null findOneByCommission(string $commission) Return the first ChildPaymentTransaction filtered by the commission column
 * @method     ChildPaymentTransaction|null findOneByOrderId(int $order_id) Return the first ChildPaymentTransaction filtered by the order_id column
 * @method     ChildPaymentTransaction|null findOneByCurrency(string $currency) Return the first ChildPaymentTransaction filtered by the currency column *

 * @method     ChildPaymentTransaction requirePk($key, ?ConnectionInterface $con = null) Return the ChildPaymentTransaction by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPaymentTransaction requireOne(?ConnectionInterface $con = null) Return the first ChildPaymentTransaction matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildPaymentTransaction requireOneById(int $id) Return the first ChildPaymentTransaction filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPaymentTransaction requireOneByCode(string $code) Return the first ChildPaymentTransaction filtered by the code column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPaymentTransaction requireOneByDatetime(string $datetime) Return the first ChildPaymentTransaction filtered by the datetime column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPaymentTransaction requireOneByUDatetime(string $udatetime) Return the first ChildPaymentTransaction filtered by the udatetime column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPaymentTransaction requireOneByOrderSumm(string $order_summ) Return the first ChildPaymentTransaction filtered by the order_summ column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPaymentTransaction requireOneByPayedSumm(string $payed_summ) Return the first ChildPaymentTransaction filtered by the payed_summ column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPaymentTransaction requireOneByConfirmed(string $confirmed) Return the first ChildPaymentTransaction filtered by the confirmed column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPaymentTransaction requireOneByResult(string $result) Return the first ChildPaymentTransaction filtered by the result column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPaymentTransaction requireOneByDesc(string $desc) Return the first ChildPaymentTransaction filtered by the desc column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPaymentTransaction requireOneByCommission(string $commission) Return the first ChildPaymentTransaction filtered by the commission column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPaymentTransaction requireOneByOrderId(int $order_id) Return the first ChildPaymentTransaction filtered by the order_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPaymentTransaction requireOneByCurrency(string $currency) Return the first ChildPaymentTransaction filtered by the currency column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildPaymentTransaction[]|Collection find(?ConnectionInterface $con = null) Return ChildPaymentTransaction objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildPaymentTransaction> find(?ConnectionInterface $con = null) Return ChildPaymentTransaction objects based on current ModelCriteria
 * @method     ChildPaymentTransaction[]|Collection findById(int $id) Return ChildPaymentTransaction objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildPaymentTransaction> findById(int $id) Return ChildPaymentTransaction objects filtered by the id column
 * @method     ChildPaymentTransaction[]|Collection findByCode(string $code) Return ChildPaymentTransaction objects filtered by the code column
 * @psalm-method Collection&\Traversable<ChildPaymentTransaction> findByCode(string $code) Return ChildPaymentTransaction objects filtered by the code column
 * @method     ChildPaymentTransaction[]|Collection findByDatetime(string $datetime) Return ChildPaymentTransaction objects filtered by the datetime column
 * @psalm-method Collection&\Traversable<ChildPaymentTransaction> findByDatetime(string $datetime) Return ChildPaymentTransaction objects filtered by the datetime column
 * @method     ChildPaymentTransaction[]|Collection findByUDatetime(string $udatetime) Return ChildPaymentTransaction objects filtered by the udatetime column
 * @psalm-method Collection&\Traversable<ChildPaymentTransaction> findByUDatetime(string $udatetime) Return ChildPaymentTransaction objects filtered by the udatetime column
 * @method     ChildPaymentTransaction[]|Collection findByOrderSumm(string $order_summ) Return ChildPaymentTransaction objects filtered by the order_summ column
 * @psalm-method Collection&\Traversable<ChildPaymentTransaction> findByOrderSumm(string $order_summ) Return ChildPaymentTransaction objects filtered by the order_summ column
 * @method     ChildPaymentTransaction[]|Collection findByPayedSumm(string $payed_summ) Return ChildPaymentTransaction objects filtered by the payed_summ column
 * @psalm-method Collection&\Traversable<ChildPaymentTransaction> findByPayedSumm(string $payed_summ) Return ChildPaymentTransaction objects filtered by the payed_summ column
 * @method     ChildPaymentTransaction[]|Collection findByConfirmed(string $confirmed) Return ChildPaymentTransaction objects filtered by the confirmed column
 * @psalm-method Collection&\Traversable<ChildPaymentTransaction> findByConfirmed(string $confirmed) Return ChildPaymentTransaction objects filtered by the confirmed column
 * @method     ChildPaymentTransaction[]|Collection findByResult(string $result) Return ChildPaymentTransaction objects filtered by the result column
 * @psalm-method Collection&\Traversable<ChildPaymentTransaction> findByResult(string $result) Return ChildPaymentTransaction objects filtered by the result column
 * @method     ChildPaymentTransaction[]|Collection findByDesc(string $desc) Return ChildPaymentTransaction objects filtered by the desc column
 * @psalm-method Collection&\Traversable<ChildPaymentTransaction> findByDesc(string $desc) Return ChildPaymentTransaction objects filtered by the desc column
 * @method     ChildPaymentTransaction[]|Collection findByCommission(string $commission) Return ChildPaymentTransaction objects filtered by the commission column
 * @psalm-method Collection&\Traversable<ChildPaymentTransaction> findByCommission(string $commission) Return ChildPaymentTransaction objects filtered by the commission column
 * @method     ChildPaymentTransaction[]|Collection findByOrderId(int $order_id) Return ChildPaymentTransaction objects filtered by the order_id column
 * @psalm-method Collection&\Traversable<ChildPaymentTransaction> findByOrderId(int $order_id) Return ChildPaymentTransaction objects filtered by the order_id column
 * @method     ChildPaymentTransaction[]|Collection findByCurrency(string $currency) Return ChildPaymentTransaction objects filtered by the currency column
 * @psalm-method Collection&\Traversable<ChildPaymentTransaction> findByCurrency(string $currency) Return ChildPaymentTransaction objects filtered by the currency column
 * @method     ChildPaymentTransaction[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildPaymentTransaction> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class PaymentTransactionQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Infrastructure\Models\PaymentTransaction\Base\PaymentTransactionQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Infrastructure\\Models\\PaymentTransaction\\PaymentTransaction', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildPaymentTransactionQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildPaymentTransactionQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildPaymentTransactionQuery) {
            return $criteria;
        }
        $query = new ChildPaymentTransactionQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildPaymentTransaction|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(PaymentTransactionTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = PaymentTransactionTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildPaymentTransaction A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `code`, `datetime`, `udatetime`, `order_summ`, `payed_summ`, `confirmed`, `result`, `desc`, `commission`, `order_id`, `currency` FROM `shop_payment_transactions` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildPaymentTransaction $obj */
            $obj = new ChildPaymentTransaction();
            $obj->hydrate($row);
            PaymentTransactionTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildPaymentTransaction|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(PaymentTransactionTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(PaymentTransactionTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(PaymentTransactionTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(PaymentTransactionTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PaymentTransactionTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the code column
     *
     * Example usage:
     * <code>
     * $query->filterByCode('fooValue');   // WHERE code = 'fooValue'
     * $query->filterByCode('%fooValue%', Criteria::LIKE); // WHERE code LIKE '%fooValue%'
     * $query->filterByCode(['foo', 'bar']); // WHERE code IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $code The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCode($code = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($code)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PaymentTransactionTableMap::COL_CODE, $code, $comparison);

        return $this;
    }

    /**
     * Filter the query on the datetime column
     *
     * Example usage:
     * <code>
     * $query->filterByDatetime('2011-03-14'); // WHERE datetime = '2011-03-14'
     * $query->filterByDatetime('now'); // WHERE datetime = '2011-03-14'
     * $query->filterByDatetime(array('max' => 'yesterday')); // WHERE datetime > '2011-03-13'
     * </code>
     *
     * @param mixed $datetime The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByDatetime($datetime = null, ?string $comparison = null)
    {
        if (is_array($datetime)) {
            $useMinMax = false;
            if (isset($datetime['min'])) {
                $this->addUsingAlias(PaymentTransactionTableMap::COL_DATETIME, $datetime['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($datetime['max'])) {
                $this->addUsingAlias(PaymentTransactionTableMap::COL_DATETIME, $datetime['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PaymentTransactionTableMap::COL_DATETIME, $datetime, $comparison);

        return $this;
    }

    /**
     * Filter the query on the udatetime column
     *
     * Example usage:
     * <code>
     * $query->filterByUDatetime('2011-03-14'); // WHERE udatetime = '2011-03-14'
     * $query->filterByUDatetime('now'); // WHERE udatetime = '2011-03-14'
     * $query->filterByUDatetime(array('max' => 'yesterday')); // WHERE udatetime > '2011-03-13'
     * </code>
     *
     * @param mixed $uDatetime The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByUDatetime($uDatetime = null, ?string $comparison = null)
    {
        if (is_array($uDatetime)) {
            $useMinMax = false;
            if (isset($uDatetime['min'])) {
                $this->addUsingAlias(PaymentTransactionTableMap::COL_UDATETIME, $uDatetime['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($uDatetime['max'])) {
                $this->addUsingAlias(PaymentTransactionTableMap::COL_UDATETIME, $uDatetime['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PaymentTransactionTableMap::COL_UDATETIME, $uDatetime, $comparison);

        return $this;
    }

    /**
     * Filter the query on the order_summ column
     *
     * Example usage:
     * <code>
     * $query->filterByOrderSumm(1234); // WHERE order_summ = 1234
     * $query->filterByOrderSumm(array(12, 34)); // WHERE order_summ IN (12, 34)
     * $query->filterByOrderSumm(array('min' => 12)); // WHERE order_summ > 12
     * </code>
     *
     * @param mixed $orderSumm The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByOrderSumm($orderSumm = null, ?string $comparison = null)
    {
        if (is_array($orderSumm)) {
            $useMinMax = false;
            if (isset($orderSumm['min'])) {
                $this->addUsingAlias(PaymentTransactionTableMap::COL_ORDER_SUMM, $orderSumm['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($orderSumm['max'])) {
                $this->addUsingAlias(PaymentTransactionTableMap::COL_ORDER_SUMM, $orderSumm['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PaymentTransactionTableMap::COL_ORDER_SUMM, $orderSumm, $comparison);

        return $this;
    }

    /**
     * Filter the query on the payed_summ column
     *
     * Example usage:
     * <code>
     * $query->filterByPayedSumm(1234); // WHERE payed_summ = 1234
     * $query->filterByPayedSumm(array(12, 34)); // WHERE payed_summ IN (12, 34)
     * $query->filterByPayedSumm(array('min' => 12)); // WHERE payed_summ > 12
     * </code>
     *
     * @param mixed $payedSumm The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPayedSumm($payedSumm = null, ?string $comparison = null)
    {
        if (is_array($payedSumm)) {
            $useMinMax = false;
            if (isset($payedSumm['min'])) {
                $this->addUsingAlias(PaymentTransactionTableMap::COL_PAYED_SUMM, $payedSumm['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($payedSumm['max'])) {
                $this->addUsingAlias(PaymentTransactionTableMap::COL_PAYED_SUMM, $payedSumm['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PaymentTransactionTableMap::COL_PAYED_SUMM, $payedSumm, $comparison);

        return $this;
    }

    /**
     * Filter the query on the confirmed column
     *
     * Example usage:
     * <code>
     * $query->filterByConfirmed('fooValue');   // WHERE confirmed = 'fooValue'
     * $query->filterByConfirmed('%fooValue%', Criteria::LIKE); // WHERE confirmed LIKE '%fooValue%'
     * $query->filterByConfirmed(['foo', 'bar']); // WHERE confirmed IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $confirmed The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByConfirmed($confirmed = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($confirmed)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PaymentTransactionTableMap::COL_CONFIRMED, $confirmed, $comparison);

        return $this;
    }

    /**
     * Filter the query on the result column
     *
     * Example usage:
     * <code>
     * $query->filterByResult('fooValue');   // WHERE result = 'fooValue'
     * $query->filterByResult('%fooValue%', Criteria::LIKE); // WHERE result LIKE '%fooValue%'
     * $query->filterByResult(['foo', 'bar']); // WHERE result IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $result The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByResult($result = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($result)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PaymentTransactionTableMap::COL_RESULT, $result, $comparison);

        return $this;
    }

    /**
     * Filter the query on the desc column
     *
     * Example usage:
     * <code>
     * $query->filterByDesc('fooValue');   // WHERE desc = 'fooValue'
     * $query->filterByDesc('%fooValue%', Criteria::LIKE); // WHERE desc LIKE '%fooValue%'
     * $query->filterByDesc(['foo', 'bar']); // WHERE desc IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $desc The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByDesc($desc = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($desc)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PaymentTransactionTableMap::COL_DESC, $desc, $comparison);

        return $this;
    }

    /**
     * Filter the query on the commission column
     *
     * Example usage:
     * <code>
     * $query->filterByCommission(1234); // WHERE commission = 1234
     * $query->filterByCommission(array(12, 34)); // WHERE commission IN (12, 34)
     * $query->filterByCommission(array('min' => 12)); // WHERE commission > 12
     * </code>
     *
     * @param mixed $commission The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCommission($commission = null, ?string $comparison = null)
    {
        if (is_array($commission)) {
            $useMinMax = false;
            if (isset($commission['min'])) {
                $this->addUsingAlias(PaymentTransactionTableMap::COL_COMMISSION, $commission['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($commission['max'])) {
                $this->addUsingAlias(PaymentTransactionTableMap::COL_COMMISSION, $commission['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PaymentTransactionTableMap::COL_COMMISSION, $commission, $comparison);

        return $this;
    }

    /**
     * Filter the query on the order_id column
     *
     * Example usage:
     * <code>
     * $query->filterByOrderId(1234); // WHERE order_id = 1234
     * $query->filterByOrderId(array(12, 34)); // WHERE order_id IN (12, 34)
     * $query->filterByOrderId(array('min' => 12)); // WHERE order_id > 12
     * </code>
     *
     * @see       filterByOrder()
     *
     * @param mixed $orderId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByOrderId($orderId = null, ?string $comparison = null)
    {
        if (is_array($orderId)) {
            $useMinMax = false;
            if (isset($orderId['min'])) {
                $this->addUsingAlias(PaymentTransactionTableMap::COL_ORDER_ID, $orderId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($orderId['max'])) {
                $this->addUsingAlias(PaymentTransactionTableMap::COL_ORDER_ID, $orderId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PaymentTransactionTableMap::COL_ORDER_ID, $orderId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the currency column
     *
     * Example usage:
     * <code>
     * $query->filterByCurrency('fooValue');   // WHERE currency = 'fooValue'
     * $query->filterByCurrency('%fooValue%', Criteria::LIKE); // WHERE currency LIKE '%fooValue%'
     * $query->filterByCurrency(['foo', 'bar']); // WHERE currency IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $currency The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCurrency($currency = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($currency)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PaymentTransactionTableMap::COL_CURRENCY, $currency, $comparison);

        return $this;
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Order\Order object
     *
     * @param \Shop\Infrastructure\Models\Order\Order|ObjectCollection $order The related object(s) to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByOrder($order, ?string $comparison = null)
    {
        if ($order instanceof \Shop\Infrastructure\Models\Order\Order) {
            return $this
                ->addUsingAlias(PaymentTransactionTableMap::COL_ORDER_ID, $order->getId(), $comparison);
        } elseif ($order instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            $this
                ->addUsingAlias(PaymentTransactionTableMap::COL_ORDER_ID, $order->toKeyValue('PrimaryKey', 'Id'), $comparison);

            return $this;
        } else {
            throw new PropelException('filterByOrder() only accepts arguments of type \Shop\Infrastructure\Models\Order\Order or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Order relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinOrder(?string $relationAlias = null, ?string $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Order');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Order');
        }

        return $this;
    }

    /**
     * Use the Order relation Order object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Order\OrderQuery A secondary query class using the current class as primary query
     */
    public function useOrderQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinOrder($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Order', '\Shop\Infrastructure\Models\Order\OrderQuery');
    }

    /**
     * Use the Order relation Order object
     *
     * @param callable(\Shop\Infrastructure\Models\Order\OrderQuery):\Shop\Infrastructure\Models\Order\OrderQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withOrderQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::LEFT_JOIN
    ) {
        $relatedQuery = $this->useOrderQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to Order table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\Order\OrderQuery The inner query object of the EXISTS statement
     */
    public function useOrderExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('Order', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to Order table for a NOT EXISTS query.
     *
     * @see useOrderExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\Order\OrderQuery The inner query object of the NOT EXISTS statement
     */
    public function useOrderNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('Order', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Exclude object from result
     *
     * @param ChildPaymentTransaction $paymentTransaction Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($paymentTransaction = null)
    {
        if ($paymentTransaction) {
            $this->addUsingAlias(PaymentTransactionTableMap::COL_ID, $paymentTransaction->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_payment_transactions table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PaymentTransactionTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            PaymentTransactionTableMap::clearInstancePool();
            PaymentTransactionTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PaymentTransactionTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(PaymentTransactionTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            PaymentTransactionTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            PaymentTransactionTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

}
