<?php

namespace Shop\Infrastructure\Models\Order\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Infrastructure\Models\Order\ShopOrdersArchive as ChildShopOrdersArchive;
use Shop\Infrastructure\Models\Order\ShopOrdersArchiveQuery as ChildShopOrdersArchiveQuery;
use Shop\Infrastructure\Models\Order\Map\ShopOrdersArchiveTableMap;

/**
 * Base class that represents a query for the 'shop_orders_archive' table.
 *
 *
 *
 * @method     ChildShopOrdersArchiveQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildShopOrdersArchiveQuery orderByTypeId($order = Criteria::ASC) Order by the type_id column
 * @method     ChildShopOrdersArchiveQuery orderByCustomerId($order = Criteria::ASC) Order by the customer_id column
 * @method     ChildShopOrdersArchiveQuery orderByContractorId($order = Criteria::ASC) Order by the contractor_id column
 * @method     ChildShopOrdersArchiveQuery orderByDatetime($order = Criteria::ASC) Order by the datetime column
 * @method     ChildShopOrdersArchiveQuery orderByUDatetime($order = Criteria::ASC) Order by the udatetime column
 * @method     ChildShopOrdersArchiveQuery orderByDiscountSumm($order = Criteria::ASC) Order by the discount_summ column
 * @method     ChildShopOrdersArchiveQuery orderByReload($order = Criteria::ASC) Order by the reload column
 * @method     ChildShopOrdersArchiveQuery orderByDeliveryAddress($order = Criteria::ASC) Order by the delivery_address column
 * @method     ChildShopOrdersArchiveQuery orderByPaymentId($order = Criteria::ASC) Order by the payment_id column
 * @method     ChildShopOrdersArchiveQuery orderByStateId($order = Criteria::ASC) Order by the state_id column
 * @method     ChildShopOrdersArchiveQuery orderByComment($order = Criteria::ASC) Order by the comment column
 * @method     ChildShopOrdersArchiveQuery orderByPostCode($order = Criteria::ASC) Order by the post_code column
 * @method     ChildShopOrdersArchiveQuery orderByShopId($order = Criteria::ASC) Order by the shop_id column
 * @method     ChildShopOrdersArchiveQuery orderByArchivedAt($order = Criteria::ASC) Order by the archived_at column
 *
 * @method     ChildShopOrdersArchiveQuery groupById() Group by the id column
 * @method     ChildShopOrdersArchiveQuery groupByTypeId() Group by the type_id column
 * @method     ChildShopOrdersArchiveQuery groupByCustomerId() Group by the customer_id column
 * @method     ChildShopOrdersArchiveQuery groupByContractorId() Group by the contractor_id column
 * @method     ChildShopOrdersArchiveQuery groupByDatetime() Group by the datetime column
 * @method     ChildShopOrdersArchiveQuery groupByUDatetime() Group by the udatetime column
 * @method     ChildShopOrdersArchiveQuery groupByDiscountSumm() Group by the discount_summ column
 * @method     ChildShopOrdersArchiveQuery groupByReload() Group by the reload column
 * @method     ChildShopOrdersArchiveQuery groupByDeliveryAddress() Group by the delivery_address column
 * @method     ChildShopOrdersArchiveQuery groupByPaymentId() Group by the payment_id column
 * @method     ChildShopOrdersArchiveQuery groupByStateId() Group by the state_id column
 * @method     ChildShopOrdersArchiveQuery groupByComment() Group by the comment column
 * @method     ChildShopOrdersArchiveQuery groupByPostCode() Group by the post_code column
 * @method     ChildShopOrdersArchiveQuery groupByShopId() Group by the shop_id column
 * @method     ChildShopOrdersArchiveQuery groupByArchivedAt() Group by the archived_at column
 *
 * @method     ChildShopOrdersArchiveQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildShopOrdersArchiveQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildShopOrdersArchiveQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildShopOrdersArchiveQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildShopOrdersArchiveQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildShopOrdersArchiveQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildShopOrdersArchive|null findOne(?ConnectionInterface $con = null) Return the first ChildShopOrdersArchive matching the query
 * @method     ChildShopOrdersArchive findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildShopOrdersArchive matching the query, or a new ChildShopOrdersArchive object populated from the query conditions when no match is found
 *
 * @method     ChildShopOrdersArchive|null findOneById(int $id) Return the first ChildShopOrdersArchive filtered by the id column
 * @method     ChildShopOrdersArchive|null findOneByTypeId(int $type_id) Return the first ChildShopOrdersArchive filtered by the type_id column
 * @method     ChildShopOrdersArchive|null findOneByCustomerId(int $customer_id) Return the first ChildShopOrdersArchive filtered by the customer_id column
 * @method     ChildShopOrdersArchive|null findOneByContractorId(int $contractor_id) Return the first ChildShopOrdersArchive filtered by the contractor_id column
 * @method     ChildShopOrdersArchive|null findOneByDatetime(string $datetime) Return the first ChildShopOrdersArchive filtered by the datetime column
 * @method     ChildShopOrdersArchive|null findOneByUDatetime(string $udatetime) Return the first ChildShopOrdersArchive filtered by the udatetime column
 * @method     ChildShopOrdersArchive|null findOneByDiscountSumm(string $discount_summ) Return the first ChildShopOrdersArchive filtered by the discount_summ column
 * @method     ChildShopOrdersArchive|null findOneByReload(string $reload) Return the first ChildShopOrdersArchive filtered by the reload column
 * @method     ChildShopOrdersArchive|null findOneByDeliveryAddress(string $delivery_address) Return the first ChildShopOrdersArchive filtered by the delivery_address column
 * @method     ChildShopOrdersArchive|null findOneByPaymentId(int $payment_id) Return the first ChildShopOrdersArchive filtered by the payment_id column
 * @method     ChildShopOrdersArchive|null findOneByStateId(int $state_id) Return the first ChildShopOrdersArchive filtered by the state_id column
 * @method     ChildShopOrdersArchive|null findOneByComment(string $comment) Return the first ChildShopOrdersArchive filtered by the comment column
 * @method     ChildShopOrdersArchive|null findOneByPostCode(string $post_code) Return the first ChildShopOrdersArchive filtered by the post_code column
 * @method     ChildShopOrdersArchive|null findOneByShopId(int $shop_id) Return the first ChildShopOrdersArchive filtered by the shop_id column
 * @method     ChildShopOrdersArchive|null findOneByArchivedAt(string $archived_at) Return the first ChildShopOrdersArchive filtered by the archived_at column *

 * @method     ChildShopOrdersArchive requirePk($key, ?ConnectionInterface $con = null) Return the ChildShopOrdersArchive by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopOrdersArchive requireOne(?ConnectionInterface $con = null) Return the first ChildShopOrdersArchive matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildShopOrdersArchive requireOneById(int $id) Return the first ChildShopOrdersArchive filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopOrdersArchive requireOneByTypeId(int $type_id) Return the first ChildShopOrdersArchive filtered by the type_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopOrdersArchive requireOneByCustomerId(int $customer_id) Return the first ChildShopOrdersArchive filtered by the customer_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopOrdersArchive requireOneByContractorId(int $contractor_id) Return the first ChildShopOrdersArchive filtered by the contractor_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopOrdersArchive requireOneByDatetime(string $datetime) Return the first ChildShopOrdersArchive filtered by the datetime column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopOrdersArchive requireOneByUDatetime(string $udatetime) Return the first ChildShopOrdersArchive filtered by the udatetime column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopOrdersArchive requireOneByDiscountSumm(string $discount_summ) Return the first ChildShopOrdersArchive filtered by the discount_summ column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopOrdersArchive requireOneByReload(string $reload) Return the first ChildShopOrdersArchive filtered by the reload column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopOrdersArchive requireOneByDeliveryAddress(string $delivery_address) Return the first ChildShopOrdersArchive filtered by the delivery_address column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopOrdersArchive requireOneByPaymentId(int $payment_id) Return the first ChildShopOrdersArchive filtered by the payment_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopOrdersArchive requireOneByStateId(int $state_id) Return the first ChildShopOrdersArchive filtered by the state_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopOrdersArchive requireOneByComment(string $comment) Return the first ChildShopOrdersArchive filtered by the comment column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopOrdersArchive requireOneByPostCode(string $post_code) Return the first ChildShopOrdersArchive filtered by the post_code column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopOrdersArchive requireOneByShopId(int $shop_id) Return the first ChildShopOrdersArchive filtered by the shop_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopOrdersArchive requireOneByArchivedAt(string $archived_at) Return the first ChildShopOrdersArchive filtered by the archived_at column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildShopOrdersArchive[]|Collection find(?ConnectionInterface $con = null) Return ChildShopOrdersArchive objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildShopOrdersArchive> find(?ConnectionInterface $con = null) Return ChildShopOrdersArchive objects based on current ModelCriteria
 * @method     ChildShopOrdersArchive[]|Collection findById(int $id) Return ChildShopOrdersArchive objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildShopOrdersArchive> findById(int $id) Return ChildShopOrdersArchive objects filtered by the id column
 * @method     ChildShopOrdersArchive[]|Collection findByTypeId(int $type_id) Return ChildShopOrdersArchive objects filtered by the type_id column
 * @psalm-method Collection&\Traversable<ChildShopOrdersArchive> findByTypeId(int $type_id) Return ChildShopOrdersArchive objects filtered by the type_id column
 * @method     ChildShopOrdersArchive[]|Collection findByCustomerId(int $customer_id) Return ChildShopOrdersArchive objects filtered by the customer_id column
 * @psalm-method Collection&\Traversable<ChildShopOrdersArchive> findByCustomerId(int $customer_id) Return ChildShopOrdersArchive objects filtered by the customer_id column
 * @method     ChildShopOrdersArchive[]|Collection findByContractorId(int $contractor_id) Return ChildShopOrdersArchive objects filtered by the contractor_id column
 * @psalm-method Collection&\Traversable<ChildShopOrdersArchive> findByContractorId(int $contractor_id) Return ChildShopOrdersArchive objects filtered by the contractor_id column
 * @method     ChildShopOrdersArchive[]|Collection findByDatetime(string $datetime) Return ChildShopOrdersArchive objects filtered by the datetime column
 * @psalm-method Collection&\Traversable<ChildShopOrdersArchive> findByDatetime(string $datetime) Return ChildShopOrdersArchive objects filtered by the datetime column
 * @method     ChildShopOrdersArchive[]|Collection findByUDatetime(string $udatetime) Return ChildShopOrdersArchive objects filtered by the udatetime column
 * @psalm-method Collection&\Traversable<ChildShopOrdersArchive> findByUDatetime(string $udatetime) Return ChildShopOrdersArchive objects filtered by the udatetime column
 * @method     ChildShopOrdersArchive[]|Collection findByDiscountSumm(string $discount_summ) Return ChildShopOrdersArchive objects filtered by the discount_summ column
 * @psalm-method Collection&\Traversable<ChildShopOrdersArchive> findByDiscountSumm(string $discount_summ) Return ChildShopOrdersArchive objects filtered by the discount_summ column
 * @method     ChildShopOrdersArchive[]|Collection findByReload(string $reload) Return ChildShopOrdersArchive objects filtered by the reload column
 * @psalm-method Collection&\Traversable<ChildShopOrdersArchive> findByReload(string $reload) Return ChildShopOrdersArchive objects filtered by the reload column
 * @method     ChildShopOrdersArchive[]|Collection findByDeliveryAddress(string $delivery_address) Return ChildShopOrdersArchive objects filtered by the delivery_address column
 * @psalm-method Collection&\Traversable<ChildShopOrdersArchive> findByDeliveryAddress(string $delivery_address) Return ChildShopOrdersArchive objects filtered by the delivery_address column
 * @method     ChildShopOrdersArchive[]|Collection findByPaymentId(int $payment_id) Return ChildShopOrdersArchive objects filtered by the payment_id column
 * @psalm-method Collection&\Traversable<ChildShopOrdersArchive> findByPaymentId(int $payment_id) Return ChildShopOrdersArchive objects filtered by the payment_id column
 * @method     ChildShopOrdersArchive[]|Collection findByStateId(int $state_id) Return ChildShopOrdersArchive objects filtered by the state_id column
 * @psalm-method Collection&\Traversable<ChildShopOrdersArchive> findByStateId(int $state_id) Return ChildShopOrdersArchive objects filtered by the state_id column
 * @method     ChildShopOrdersArchive[]|Collection findByComment(string $comment) Return ChildShopOrdersArchive objects filtered by the comment column
 * @psalm-method Collection&\Traversable<ChildShopOrdersArchive> findByComment(string $comment) Return ChildShopOrdersArchive objects filtered by the comment column
 * @method     ChildShopOrdersArchive[]|Collection findByPostCode(string $post_code) Return ChildShopOrdersArchive objects filtered by the post_code column
 * @psalm-method Collection&\Traversable<ChildShopOrdersArchive> findByPostCode(string $post_code) Return ChildShopOrdersArchive objects filtered by the post_code column
 * @method     ChildShopOrdersArchive[]|Collection findByShopId(int $shop_id) Return ChildShopOrdersArchive objects filtered by the shop_id column
 * @psalm-method Collection&\Traversable<ChildShopOrdersArchive> findByShopId(int $shop_id) Return ChildShopOrdersArchive objects filtered by the shop_id column
 * @method     ChildShopOrdersArchive[]|Collection findByArchivedAt(string $archived_at) Return ChildShopOrdersArchive objects filtered by the archived_at column
 * @psalm-method Collection&\Traversable<ChildShopOrdersArchive> findByArchivedAt(string $archived_at) Return ChildShopOrdersArchive objects filtered by the archived_at column
 * @method     ChildShopOrdersArchive[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildShopOrdersArchive> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class ShopOrdersArchiveQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Infrastructure\Models\Order\Base\ShopOrdersArchiveQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Infrastructure\\Models\\Order\\ShopOrdersArchive', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildShopOrdersArchiveQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildShopOrdersArchiveQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildShopOrdersArchiveQuery) {
            return $criteria;
        }
        $query = new ChildShopOrdersArchiveQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildShopOrdersArchive|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(ShopOrdersArchiveTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = ShopOrdersArchiveTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildShopOrdersArchive A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `type_id`, `customer_id`, `contractor_id`, `datetime`, `udatetime`, `discount_summ`, `reload`, `delivery_address`, `payment_id`, `state_id`, `comment`, `post_code`, `shop_id`, `archived_at` FROM `shop_orders_archive` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildShopOrdersArchive $obj */
            $obj = new ChildShopOrdersArchive();
            $obj->hydrate($row);
            ShopOrdersArchiveTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildShopOrdersArchive|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the type_id column
     *
     * Example usage:
     * <code>
     * $query->filterByTypeId(1234); // WHERE type_id = 1234
     * $query->filterByTypeId(array(12, 34)); // WHERE type_id IN (12, 34)
     * $query->filterByTypeId(array('min' => 12)); // WHERE type_id > 12
     * </code>
     *
     * @param mixed $typeId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByTypeId($typeId = null, ?string $comparison = null)
    {
        if (is_array($typeId)) {
            $useMinMax = false;
            if (isset($typeId['min'])) {
                $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_TYPE_ID, $typeId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($typeId['max'])) {
                $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_TYPE_ID, $typeId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_TYPE_ID, $typeId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the customer_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCustomerId(1234); // WHERE customer_id = 1234
     * $query->filterByCustomerId(array(12, 34)); // WHERE customer_id IN (12, 34)
     * $query->filterByCustomerId(array('min' => 12)); // WHERE customer_id > 12
     * </code>
     *
     * @param mixed $customerId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCustomerId($customerId = null, ?string $comparison = null)
    {
        if (is_array($customerId)) {
            $useMinMax = false;
            if (isset($customerId['min'])) {
                $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_CUSTOMER_ID, $customerId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($customerId['max'])) {
                $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_CUSTOMER_ID, $customerId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_CUSTOMER_ID, $customerId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the contractor_id column
     *
     * Example usage:
     * <code>
     * $query->filterByContractorId(1234); // WHERE contractor_id = 1234
     * $query->filterByContractorId(array(12, 34)); // WHERE contractor_id IN (12, 34)
     * $query->filterByContractorId(array('min' => 12)); // WHERE contractor_id > 12
     * </code>
     *
     * @param mixed $contractorId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByContractorId($contractorId = null, ?string $comparison = null)
    {
        if (is_array($contractorId)) {
            $useMinMax = false;
            if (isset($contractorId['min'])) {
                $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_CONTRACTOR_ID, $contractorId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($contractorId['max'])) {
                $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_CONTRACTOR_ID, $contractorId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_CONTRACTOR_ID, $contractorId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the datetime column
     *
     * Example usage:
     * <code>
     * $query->filterByDatetime('2011-03-14'); // WHERE datetime = '2011-03-14'
     * $query->filterByDatetime('now'); // WHERE datetime = '2011-03-14'
     * $query->filterByDatetime(array('max' => 'yesterday')); // WHERE datetime > '2011-03-13'
     * </code>
     *
     * @param mixed $datetime The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByDatetime($datetime = null, ?string $comparison = null)
    {
        if (is_array($datetime)) {
            $useMinMax = false;
            if (isset($datetime['min'])) {
                $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_DATETIME, $datetime['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($datetime['max'])) {
                $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_DATETIME, $datetime['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_DATETIME, $datetime, $comparison);

        return $this;
    }

    /**
     * Filter the query on the udatetime column
     *
     * Example usage:
     * <code>
     * $query->filterByUDatetime('2011-03-14'); // WHERE udatetime = '2011-03-14'
     * $query->filterByUDatetime('now'); // WHERE udatetime = '2011-03-14'
     * $query->filterByUDatetime(array('max' => 'yesterday')); // WHERE udatetime > '2011-03-13'
     * </code>
     *
     * @param mixed $uDatetime The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByUDatetime($uDatetime = null, ?string $comparison = null)
    {
        if (is_array($uDatetime)) {
            $useMinMax = false;
            if (isset($uDatetime['min'])) {
                $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_UDATETIME, $uDatetime['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($uDatetime['max'])) {
                $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_UDATETIME, $uDatetime['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_UDATETIME, $uDatetime, $comparison);

        return $this;
    }

    /**
     * Filter the query on the discount_summ column
     *
     * Example usage:
     * <code>
     * $query->filterByDiscountSumm(1234); // WHERE discount_summ = 1234
     * $query->filterByDiscountSumm(array(12, 34)); // WHERE discount_summ IN (12, 34)
     * $query->filterByDiscountSumm(array('min' => 12)); // WHERE discount_summ > 12
     * </code>
     *
     * @param mixed $discountSumm The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByDiscountSumm($discountSumm = null, ?string $comparison = null)
    {
        if (is_array($discountSumm)) {
            $useMinMax = false;
            if (isset($discountSumm['min'])) {
                $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_DISCOUNT_SUMM, $discountSumm['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($discountSumm['max'])) {
                $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_DISCOUNT_SUMM, $discountSumm['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_DISCOUNT_SUMM, $discountSumm, $comparison);

        return $this;
    }

    /**
     * Filter the query on the reload column
     *
     * Example usage:
     * <code>
     * $query->filterByReload('fooValue');   // WHERE reload = 'fooValue'
     * $query->filterByReload('%fooValue%', Criteria::LIKE); // WHERE reload LIKE '%fooValue%'
     * $query->filterByReload(['foo', 'bar']); // WHERE reload IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $reload The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByReload($reload = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($reload)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_RELOAD, $reload, $comparison);

        return $this;
    }

    /**
     * Filter the query on the delivery_address column
     *
     * Example usage:
     * <code>
     * $query->filterByDeliveryAddress('fooValue');   // WHERE delivery_address = 'fooValue'
     * $query->filterByDeliveryAddress('%fooValue%', Criteria::LIKE); // WHERE delivery_address LIKE '%fooValue%'
     * $query->filterByDeliveryAddress(['foo', 'bar']); // WHERE delivery_address IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $deliveryAddress The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByDeliveryAddress($deliveryAddress = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($deliveryAddress)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_DELIVERY_ADDRESS, $deliveryAddress, $comparison);

        return $this;
    }

    /**
     * Filter the query on the payment_id column
     *
     * Example usage:
     * <code>
     * $query->filterByPaymentId(1234); // WHERE payment_id = 1234
     * $query->filterByPaymentId(array(12, 34)); // WHERE payment_id IN (12, 34)
     * $query->filterByPaymentId(array('min' => 12)); // WHERE payment_id > 12
     * </code>
     *
     * @param mixed $paymentId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPaymentId($paymentId = null, ?string $comparison = null)
    {
        if (is_array($paymentId)) {
            $useMinMax = false;
            if (isset($paymentId['min'])) {
                $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_PAYMENT_ID, $paymentId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($paymentId['max'])) {
                $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_PAYMENT_ID, $paymentId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_PAYMENT_ID, $paymentId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the state_id column
     *
     * Example usage:
     * <code>
     * $query->filterByStateId(1234); // WHERE state_id = 1234
     * $query->filterByStateId(array(12, 34)); // WHERE state_id IN (12, 34)
     * $query->filterByStateId(array('min' => 12)); // WHERE state_id > 12
     * </code>
     *
     * @param mixed $stateId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByStateId($stateId = null, ?string $comparison = null)
    {
        if (is_array($stateId)) {
            $useMinMax = false;
            if (isset($stateId['min'])) {
                $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_STATE_ID, $stateId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($stateId['max'])) {
                $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_STATE_ID, $stateId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_STATE_ID, $stateId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the comment column
     *
     * Example usage:
     * <code>
     * $query->filterByComment('fooValue');   // WHERE comment = 'fooValue'
     * $query->filterByComment('%fooValue%', Criteria::LIKE); // WHERE comment LIKE '%fooValue%'
     * $query->filterByComment(['foo', 'bar']); // WHERE comment IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $comment The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByComment($comment = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($comment)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_COMMENT, $comment, $comparison);

        return $this;
    }

    /**
     * Filter the query on the post_code column
     *
     * Example usage:
     * <code>
     * $query->filterByPostCode('fooValue');   // WHERE post_code = 'fooValue'
     * $query->filterByPostCode('%fooValue%', Criteria::LIKE); // WHERE post_code LIKE '%fooValue%'
     * $query->filterByPostCode(['foo', 'bar']); // WHERE post_code IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $postCode The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPostCode($postCode = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($postCode)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_POST_CODE, $postCode, $comparison);

        return $this;
    }

    /**
     * Filter the query on the shop_id column
     *
     * Example usage:
     * <code>
     * $query->filterByShopId(1234); // WHERE shop_id = 1234
     * $query->filterByShopId(array(12, 34)); // WHERE shop_id IN (12, 34)
     * $query->filterByShopId(array('min' => 12)); // WHERE shop_id > 12
     * </code>
     *
     * @param mixed $shopId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByShopId($shopId = null, ?string $comparison = null)
    {
        if (is_array($shopId)) {
            $useMinMax = false;
            if (isset($shopId['min'])) {
                $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_SHOP_ID, $shopId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($shopId['max'])) {
                $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_SHOP_ID, $shopId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_SHOP_ID, $shopId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the archived_at column
     *
     * Example usage:
     * <code>
     * $query->filterByArchivedAt('2011-03-14'); // WHERE archived_at = '2011-03-14'
     * $query->filterByArchivedAt('now'); // WHERE archived_at = '2011-03-14'
     * $query->filterByArchivedAt(array('max' => 'yesterday')); // WHERE archived_at > '2011-03-13'
     * </code>
     *
     * @param mixed $archivedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByArchivedAt($archivedAt = null, ?string $comparison = null)
    {
        if (is_array($archivedAt)) {
            $useMinMax = false;
            if (isset($archivedAt['min'])) {
                $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_ARCHIVED_AT, $archivedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($archivedAt['max'])) {
                $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_ARCHIVED_AT, $archivedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_ARCHIVED_AT, $archivedAt, $comparison);

        return $this;
    }

    /**
     * Exclude object from result
     *
     * @param ChildShopOrdersArchive $shopOrdersArchive Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($shopOrdersArchive = null)
    {
        if ($shopOrdersArchive) {
            $this->addUsingAlias(ShopOrdersArchiveTableMap::COL_ID, $shopOrdersArchive->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_orders_archive table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopOrdersArchiveTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ShopOrdersArchiveTableMap::clearInstancePool();
            ShopOrdersArchiveTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopOrdersArchiveTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(ShopOrdersArchiveTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            ShopOrdersArchiveTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            ShopOrdersArchiveTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

}
