<?php

namespace Shop\Application\Office\ChangeCustomerPassword;

use Shop\Domain\Customer\Contracts\CustomerEntityInterface;

class ChangeCustomerPasswordCommand
{
    /**
     * @var CustomerEntityInterface
     */
    protected $customer;

    /**
     * @var string
     */
    protected $password;

    public function __construct(CustomerEntityInterface $customer, string $password)
    {
        $this->customer = $customer;
        $this->password = $password;
    }

    /**
     * @return CustomerEntityInterface
     */
    public function getCustomer(): CustomerEntityInterface
    {
        return $this->customer;
    }

    /**
     * @return string
     */
    public function getPassword(): string
    {
        return $this->password;
    }


}