<?php declare(strict_types=1);

namespace Shop\Presentation\Helpers;

use Shop\Presentation\Config\Main;
use Shop\Presentation\Config\MainConfig;

class ProductHelper
{
    /**
     * блок форматирвоания пола товара для отчетов
     *
     * @param type $sex
     * @return string
     */
    static function display_sex($sex)
    {
        if (in_array($sex, ["m", "boy"])) {
            return '<span style="float: right;color: #0282ce">мальчик</span>';
        } elseif (in_array($sex, ['w', "girl"])) {
            return '<span style="float: right;color: #ff79e4">девочка</span>';
        }
    }

    /**
     * Путь к изображени.
     * @param MainConfig $mainConfig
     * @param string $imageFileName
     * @return string
     */
    static public function getImagePath(MainConfig $mainConfig, string $imageFileName): string
    {
        if($mainConfig->getImagesServer() > ''){
            $imagePath = rtrim($mainConfig->getImagesServer()) . '/upload/'.trim($mainConfig->getProductImagePath(),'/').'/'.$imageFileName;;
        }
        else{
            $imagePath = '/upload/' . trim($mainConfig->getProductImagePath(),'/') .'/'.$imageFileName;
        }

        return $imagePath;
    }

    /**
     * Путь к миниэскизу изображения
     * @param MainConfig $mainConfig
     * @param string $imageFileName
     * @return string
     */
    static public function getThumbImagePath(MainConfig $mainConfig, string $imageFileName): string
    {

        if($mainConfig->getImagesServer() > ''){
            $imagePath = rtrim($mainConfig->getImagesServer()) .'/'.  trim($mainConfig->getThumbPath(),'/').'/'.$imageFileName;;
        }
        else{
            $imagePath = '/'. trim($mainConfig->getThumbPath(),'/') .'/'.$imageFileName;
        }

        return $imagePath;
    }
}