<?php

namespace Shop\Infrastructure\Models\PriceAccess\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Infrastructure\Models\PriceAccess\PriceAccess as ChildPriceAccess;
use Shop\Infrastructure\Models\PriceAccess\PriceAccessQuery as ChildPriceAccessQuery;
use Shop\Infrastructure\Models\PriceAccess\Map\PriceAccessTableMap;

/**
 * Base class that represents a query for the 'shop_price_access' table.
 *
 *
 *
 * @method     ChildPriceAccessQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildPriceAccessQuery orderByCustomerGroupId($order = Criteria::ASC) Order by the customer_group_id column
 * @method     ChildPriceAccessQuery orderByShopId($order = Criteria::ASC) Order by the shop_id column
 * @method     ChildPriceAccessQuery orderByPriceScheetId($order = Criteria::ASC) Order by the price_scheet_id column
 * @method     ChildPriceAccessQuery orderByCustomerId($order = Criteria::ASC) Order by the customer_id column
 *
 * @method     ChildPriceAccessQuery groupById() Group by the id column
 * @method     ChildPriceAccessQuery groupByCustomerGroupId() Group by the customer_group_id column
 * @method     ChildPriceAccessQuery groupByShopId() Group by the shop_id column
 * @method     ChildPriceAccessQuery groupByPriceScheetId() Group by the price_scheet_id column
 * @method     ChildPriceAccessQuery groupByCustomerId() Group by the customer_id column
 *
 * @method     ChildPriceAccessQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildPriceAccessQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildPriceAccessQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildPriceAccessQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildPriceAccessQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildPriceAccessQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildPriceAccess|null findOne(?ConnectionInterface $con = null) Return the first ChildPriceAccess matching the query
 * @method     ChildPriceAccess findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildPriceAccess matching the query, or a new ChildPriceAccess object populated from the query conditions when no match is found
 *
 * @method     ChildPriceAccess|null findOneById(int $id) Return the first ChildPriceAccess filtered by the id column
 * @method     ChildPriceAccess|null findOneByCustomerGroupId(string $customer_group_id) Return the first ChildPriceAccess filtered by the customer_group_id column
 * @method     ChildPriceAccess|null findOneByShopId(string $shop_id) Return the first ChildPriceAccess filtered by the shop_id column
 * @method     ChildPriceAccess|null findOneByPriceScheetId(string $price_scheet_id) Return the first ChildPriceAccess filtered by the price_scheet_id column
 * @method     ChildPriceAccess|null findOneByCustomerId(string $customer_id) Return the first ChildPriceAccess filtered by the customer_id column *

 * @method     ChildPriceAccess requirePk($key, ?ConnectionInterface $con = null) Return the ChildPriceAccess by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPriceAccess requireOne(?ConnectionInterface $con = null) Return the first ChildPriceAccess matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildPriceAccess requireOneById(int $id) Return the first ChildPriceAccess filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPriceAccess requireOneByCustomerGroupId(string $customer_group_id) Return the first ChildPriceAccess filtered by the customer_group_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPriceAccess requireOneByShopId(string $shop_id) Return the first ChildPriceAccess filtered by the shop_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPriceAccess requireOneByPriceScheetId(string $price_scheet_id) Return the first ChildPriceAccess filtered by the price_scheet_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPriceAccess requireOneByCustomerId(string $customer_id) Return the first ChildPriceAccess filtered by the customer_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildPriceAccess[]|Collection find(?ConnectionInterface $con = null) Return ChildPriceAccess objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildPriceAccess> find(?ConnectionInterface $con = null) Return ChildPriceAccess objects based on current ModelCriteria
 * @method     ChildPriceAccess[]|Collection findById(int $id) Return ChildPriceAccess objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildPriceAccess> findById(int $id) Return ChildPriceAccess objects filtered by the id column
 * @method     ChildPriceAccess[]|Collection findByCustomerGroupId(string $customer_group_id) Return ChildPriceAccess objects filtered by the customer_group_id column
 * @psalm-method Collection&\Traversable<ChildPriceAccess> findByCustomerGroupId(string $customer_group_id) Return ChildPriceAccess objects filtered by the customer_group_id column
 * @method     ChildPriceAccess[]|Collection findByShopId(string $shop_id) Return ChildPriceAccess objects filtered by the shop_id column
 * @psalm-method Collection&\Traversable<ChildPriceAccess> findByShopId(string $shop_id) Return ChildPriceAccess objects filtered by the shop_id column
 * @method     ChildPriceAccess[]|Collection findByPriceScheetId(string $price_scheet_id) Return ChildPriceAccess objects filtered by the price_scheet_id column
 * @psalm-method Collection&\Traversable<ChildPriceAccess> findByPriceScheetId(string $price_scheet_id) Return ChildPriceAccess objects filtered by the price_scheet_id column
 * @method     ChildPriceAccess[]|Collection findByCustomerId(string $customer_id) Return ChildPriceAccess objects filtered by the customer_id column
 * @psalm-method Collection&\Traversable<ChildPriceAccess> findByCustomerId(string $customer_id) Return ChildPriceAccess objects filtered by the customer_id column
 * @method     ChildPriceAccess[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildPriceAccess> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class PriceAccessQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Infrastructure\Models\PriceAccess\Base\PriceAccessQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Infrastructure\\Models\\PriceAccess\\PriceAccess', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildPriceAccessQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildPriceAccessQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildPriceAccessQuery) {
            return $criteria;
        }
        $query = new ChildPriceAccessQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildPriceAccess|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(PriceAccessTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = PriceAccessTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildPriceAccess A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `customer_group_id`, `shop_id`, `price_scheet_id`, `customer_id` FROM `shop_price_access` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildPriceAccess $obj */
            $obj = new ChildPriceAccess();
            $obj->hydrate($row);
            PriceAccessTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildPriceAccess|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(PriceAccessTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(PriceAccessTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(PriceAccessTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(PriceAccessTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PriceAccessTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the customer_group_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCustomerGroupId('fooValue');   // WHERE customer_group_id = 'fooValue'
     * $query->filterByCustomerGroupId('%fooValue%', Criteria::LIKE); // WHERE customer_group_id LIKE '%fooValue%'
     * $query->filterByCustomerGroupId(['foo', 'bar']); // WHERE customer_group_id IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $customerGroupId The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCustomerGroupId($customerGroupId = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($customerGroupId)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PriceAccessTableMap::COL_CUSTOMER_GROUP_ID, $customerGroupId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the shop_id column
     *
     * Example usage:
     * <code>
     * $query->filterByShopId('fooValue');   // WHERE shop_id = 'fooValue'
     * $query->filterByShopId('%fooValue%', Criteria::LIKE); // WHERE shop_id LIKE '%fooValue%'
     * $query->filterByShopId(['foo', 'bar']); // WHERE shop_id IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $shopId The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByShopId($shopId = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($shopId)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PriceAccessTableMap::COL_SHOP_ID, $shopId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the price_scheet_id column
     *
     * Example usage:
     * <code>
     * $query->filterByPriceScheetId('fooValue');   // WHERE price_scheet_id = 'fooValue'
     * $query->filterByPriceScheetId('%fooValue%', Criteria::LIKE); // WHERE price_scheet_id LIKE '%fooValue%'
     * $query->filterByPriceScheetId(['foo', 'bar']); // WHERE price_scheet_id IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $priceScheetId The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPriceScheetId($priceScheetId = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($priceScheetId)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PriceAccessTableMap::COL_PRICE_SCHEET_ID, $priceScheetId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the customer_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCustomerId('fooValue');   // WHERE customer_id = 'fooValue'
     * $query->filterByCustomerId('%fooValue%', Criteria::LIKE); // WHERE customer_id LIKE '%fooValue%'
     * $query->filterByCustomerId(['foo', 'bar']); // WHERE customer_id IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $customerId The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCustomerId($customerId = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($customerId)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PriceAccessTableMap::COL_CUSTOMER_ID, $customerId, $comparison);

        return $this;
    }

    /**
     * Exclude object from result
     *
     * @param ChildPriceAccess $priceAccess Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($priceAccess = null)
    {
        if ($priceAccess) {
            $this->addUsingAlias(PriceAccessTableMap::COL_ID, $priceAccess->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_price_access table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PriceAccessTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            PriceAccessTableMap::clearInstancePool();
            PriceAccessTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PriceAccessTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(PriceAccessTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            PriceAccessTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            PriceAccessTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

}
