<?php

namespace Shop\Domain\Customer\Contracts;

use Repo\EntityInterface;
use Shop\Domain\City\Contracts\CityEntityInterface;
use Shop\Domain\Manager\Contracts\ManagerEntityInterface;

interface CustomerEntityInterface extends EntityInterface
{
    /**
     * @return string
     */
    public function getPassword();

    /**
     * @return string|null
     */
    public function getInfoHidden();

    /**
     * @return array
     */
    public function getAccessPrices(): array;

    /**
     * @return mixed
     */
    public function getGroupId();


    /**
     * @return string
     */
    public function getName();


    /**
     * @return string
     */
    public function getEmail();


    /**
     * @return string|null
     */
    public function getPhone();


    /**
     * @return int
     */
    public function getCityId();

    /**
     * @return int
     */
    public function getManagerId();


    /**
     * @return ManagerEntityInterface
     */
    public function getManager();

    /**
     * @return CityEntityInterface
     */
    public function getCustomerCity();


    public function isAuth(): bool;


    public function isNotifySms(): bool;


    public function getFullAddress(): string;

    public function isNotifyEmail(): bool;


    public function getRegisterCode(): string;


    public function getAccessPriceListScheetIds(): array;


    public function isProvider(): bool;


    public function isStock(): bool;


    public function getCustomerGroup();
}