<?php

namespace Shop\Domain\Currency;

use Core\Repository\DropDownInterface;
use Repo\Concrete\AbstractCollection;
use Shop\Domain\Currency\Contracts\CurrencyEntityInterface;

/**
* Description of Currency
*
* @author Diamond Code Generator
*/
class CurrencyCollection extends AbstractCollection implements DropDownInterface
{

    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return CurrencyEntityInterface::class;
    }

    public function getDropdownList(): array
    {
        $ar = [];
        foreach ($this->_entities as $entity){
            $ar[$entity->getId()] = $entity->getName();
        }

        return $ar;
    }


}               