<?php

namespace Shop\Presentation\Modules\AdminStates;

use ActiveTable\ColumnTable;
use Core\Form\ControlBuilder;
use Core\Registry\Column;
use Core\Registry\Field;
use DiamondTable\TableFactory;
use Shop\Presentation\Config\Main;
use Shop\Domain\State\Contracts\StateEntityInterface;
use Shop\Presentation\Helpers\Formatter;
use Shop\Presentation\Helpers\State;
use Shop\Infrastructure\Repositories\State\StateCriteria;
use Shop\Infrastructure\Repositories\State\StateRepository;

/**
 * Description of AdminStates
 *
 * @author Diamond Code Generator
 */
class AdminStates extends \Core\ModuleController
{

    protected $stateRepository;
    protected $tableFactory;
    protected $controlBuilder;
    protected $mainConf;

    /**
     * AdminStates constructor.
     * @param StateRepository $stateRepository
     * @param TableFactory $tableFactory
     * @param ControlBuilder $controlBuilder
     * @param Main $main
     */
    public function __construct(StateRepository $stateRepository, TableFactory $tableFactory, ControlBuilder $controlBuilder, Main $main)
    {
        $this->stateRepository = $stateRepository;
        $this->tableFactory = $tableFactory;
        $this->controlBuilder = $controlBuilder;
        $this->mainConf = $main;
    }


    /**
     * @return string
     * @throws \ReflectionException
     */
    public function process(): string
    {

        $table = $this->tableFactory->buildAdminTable($this->stateRepository, StateCriteria::create());

        $table
            ->setDefaultSortColumn('id','DESC')
            ->addColumn(
                (new ColumnTable('id', '№'))
                    ->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('title', 'Наименование'))
                    ->setWidth(30, true)
                    ->setFormat($this, 'formatColorState')
            )
            ->addColumn(
                (new ColumnTable('default', 'В настройках по умолчанию'))
                    ->setFormat($this, 'formatDefault')
            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setWidth(120)
                    ->setFormat($this->tableFactory, 'formatActions')
            )
            ->addField($this->controlBuilder->buildInput('title'), true)
            ->addField($this->controlBuilder->buildColorPicker('color'), true, 'Цветовой код');

        return $table->render();
    }

    /**
     * @param StateEntityInterface $state
     * @return string
     */
    public function formatDefault(StateEntityInterface $state): string
    {
        $res = [];

        if ($state->getId() === $this->mainConf->getStateDefault()) {
            $res []= 'По умолчанию';
        }

        if ($state->getId() === $this->mainConf->getStateProviderDefault()) {
            $res []= 'Заказ поставщику';
        }

        if ($state->getId() === $this->mainConf->getStateCancel()) {
            $res []= 'Отмена заказа';
        }

        if ($state->getId() === $this->mainConf->getStatePayment()) {
            $res []= 'Оплата произведена';
        }

        if ($state->getId() === $this->mainConf->getStateProviderSend()) {
            $res []= 'Заказ отправлен поставщику';
        }

        return implode(',',$res);
    }

    /**
     * @param StateEntityInterface $state
     * @return string
     */
    public function formatColorState(StateEntityInterface $state): string
    {
        return Formatter::formatColor($state);
    }

}