<?php

namespace Shop\Presentation\Modules\AdminCurriencies;

use ActiveTable\ColumnTable;
use Core\Form\Control\Switchery;
use Core\Form\ControlBuilder;
use Core\Form\NiftyControlBuilder;
use DiamondTable\TableFactory;
use Shop\Domain\Currency\Contracts\CurrencyEntityInterface;
use Shop\Infrastructure\Models\Currency\Currency;
use Shop\Infrastructure\Repositories\Currency\CurrencyCriteria;
use Shop\Infrastructure\Repositories\Currency\CurrencyRepository;

/**
 * Class AdminCurriencies
 * @package Shop\Presentation\Modules\AdminCurriencies
 */
class AdminCurriencies extends \Core\ModuleController
{

    protected $currencyRepository;
    protected $tableFactory;
    protected $controlBuilder;

    public function __construct(CurrencyRepository $currencyRepository, TableFactory $tableFactory, NiftyControlBuilder $controlBuilder)
    {
        $this->currencyRepository = $currencyRepository;
        $this->tableFactory = $tableFactory;
        $this->controlBuilder = $controlBuilder;
    }


    public function process(): string
    {

        $table = $this->tableFactory->buildAdminTable($this->currencyRepository,CurrencyCriteria::create());

        $table
            ->addColumn(
                (new ColumnTable('id','№'))->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('name','Наименование'))
            )
            ->addColumn(
                (new ColumnTable('native','Валюта сайта'))
            )
            ->addColumn(
                (new ColumnTable('htmlSign','Отображение на сайте'))
            )
            ->addColumn(
                (new ColumnTable('iso','Буквенный код'))
            )
            ->addColumn(
                (new ColumnTable('roundMode','Режим округления'))
            )
            ->addColumn(
                (new ColumnTable('roundPrice','Точность округления'))
            )
            ->addColumn(
                (new ColumnTable('displayed','Показывать'))->setFormat($this,'formatDisplayed')
            )
            ->addColumn(
                (new ColumnTable('actions',''))
                    ->setFormat($this->tableFactory,'formatActions')
                    ->setWidth(120)
            )
            ;

        $table
            ->addField(
                $this->controlBuilder->buildInputSmall('name'),true
            )
            ->addField(
                $this->controlBuilder->buildInputSmall('htmlSign'),true
            )
            ->addField(
                $this->controlBuilder->buildNiftySimpleSwitchery('displayed', 'Y','N'), true
            )
            ->addField(
                $this->controlBuilder->buildInputLittle('iso'),true,null,'ISO'
            )
            ->addField(
                $this->controlBuilder->buildInputLittle('roundPrice')->setValue(1),true,null
            )
            ->addField(
                $this->controlBuilder->buildDropdownUniform('roundMode', ['ceil' => 'в большую', 'round' => 'в меньшую'])
            )
        ;

        return $table->render();
    }

    public function formatDisplayed(CurrencyEntityInterface $currencyEntity): string
    {
        $data = [
            'class' => self::class,
            'id' => $currencyEntity->getId(),
            'fn' => 'changeDisplayed'
        ];
        return (new Switchery($data, $currencyEntity->getDisplayed()==='Y'))->render();
    }

    public function changeDisplayed(int $id, bool $checked): void
    {
        /**
         * @var Currency $user
         */
        $entity = $this->currencyRepository->findById($id);
        $entity->setDisplayed($checked);
        $this->currencyRepository->save($entity);
    }

}