<?php


namespace Shop\Presentation\Modules\AdminClients;


use Core\Form\Control\MenuItem;
use Core\Form\Control\MenuItemAction;
use Core\Form\Control\Switchery;
use Core\Form\ControlBuilder;
use Diamond\Helpers\Form;
use Diamond\Helpers\Formatter;
use Shop\Domain\Customer\Contracts\CustomerEntityInterface;
use Diamond\Helpers\Date;
use Shop\Infrastructure\Models\Customer\Customer;

trait FormatColumnsTrait
{


    /**
     * @param CustomerEntityInterface $customer
     * @return string
     */
    public function formatcDate(CustomerEntityInterface $customer): string
    {
        return $customer->getRegistred() ? $customer->getRegistred()->format(Date::formatDisplay()) : " - ";
    }

    /**
     * @param \Shop\Infrastructure\Models\Customer\Customer $customer
     * @return string
     */
    public function formatAccess(CustomerEntityInterface $customer): string
    {

        if(!$customer->getPassword()){
            return '';
        }

        return $this->controlBuilder->buildTableLabel( 'Есть','success')->render();
    }

    public function formatDelete(CustomerEntityInterface $customer): string
    {
        $data = [
            'class' => self::class,
            'id' => $customer->getId(),
            'fn' => 'changeBlocked'
        ];
        return (new Switchery($data, $customer->getBlocked()==='Y'))->setColor('#e33a4b')->render();
    }

    public function changeBlocked(int $id, bool $checked): void
    {
        /**
         * @var Customer $user
         */
        $user = $this->customerRepo->findById($id);
        $user->setBlocked($checked);
        $this->customerRepo->save($user);
    }


    /**
     * @param CustomerEntityInterface $customer
     * @return mixed
     */
    public function formatOffice(CustomerEntityInterface $customer): string
    {
        $manager = $customer->getManager();
        return anchor('/admin/shop/stocks/stocks',$manager->getShop()->getTitle(),[],[
            'fn'    => 'edit',
            'id'    => $manager->getShop()->getId()
        ]);
    }

    public function formatManager(CustomerEntityInterface $customer): string
    {
        $manager = $customer->getManager();
        return anchor('/admin/shop/stocks/managers',$manager->getName(),[],[
            'fn'    => 'edit',
            'id'    => $manager->getId()
        ]);
    }


    /**
     * @param CustomerEntityInterface $customer
     * @return string
     */
    public function formatAddress(CustomerEntityInterface $customer): string
    {
        $city = $customer->getCustomerCity();

        return $city->getName();
//
//        $region = $city->getCityRegion();
//
//        return sprintf(
//            "%s, г.%s", $region->getName(),
//        );
    }

    /**
     * @param CustomerEntityInterface $customer
     * @return mixed
     */
    public function formatSmsNotify(CustomerEntityInterface $customer): string
    {
        return $this->getNotifyTypes()[$customer->getNotifyType()];
    }

    /**
     *
     * @return type
     */
    private function getNotifyTypes(): array
    {
        return [
            "sms" => "смс",
            "sms_email" => "смс и email",
            "email" => "email"
        ];
    }

    /**
     * @param CustomerEntityInterface $customer
     * @return mixed
     */
    public function formatScore(CustomerEntityInterface $customer): string
    {

        return $this->bonusUseCase->calculateByCustomer($customer);
    }

    /**
     * @param CustomerEntityInterface $customer
     * @return string
     */
    public function formatLastAuth(CustomerEntityInterface $customer): string
    {
        return $customer->getLastauth() ? $customer->getLastauth()->format(\Diamond\Helpers\Date::formatDisplay()) : " не входил ";
    }

    /**
     * @param CustomerEntityInterface $customer
     * @return mixed
     */
    public function formatGroup(CustomerEntityInterface $customer): string
    {
        return $customer->getCustomerGroup()->getName();
    }

    /**
     * @param CustomerEntityInterface|Customer $customer
     * @return string
     */
    public function formatOrders(CustomerEntityInterface $customer):string{
        return $customer->getOrdersRelatedByCustomerId()->count();
    }
}