<?php

namespace Shop\Infrastructure\Repositories\SyncLog;

use Repo\Concrete\AbstractCriteria;
use Shop\Domain\SyncLog\Contracts\SyncLogCriteriaInterface;

/**
 * Class MoySkladSyncLogCriteria
 * @package Shop\Infrastructure\Repositories\MoySkladSyncLog
 */
class SyncLogCriteria extends AbstractCriteria implements SyncLogCriteriaInterface
{
    /**
     * @var int|null
     */
    protected $filterByOrderId;

    /**
     * @return int|null
     */
    public function getFilterByOrderId(): ?int
    {
        return $this->filterByOrderId;
    }

    /**
     * @param int|null $filterByOrderId
     * @return $this
     */
    public function setFilterByOrderId(?int $filterByOrderId): SyncLogCriteria
    {
        $this->filterByOrderId = $filterByOrderId;
        return $this;
    }


    /**
     * @return SyncLogCriteria
     */
    public static function create()
    {
        return new self;
    }

}