<?php

namespace Shop\Infrastructure\Models\FastLink\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Infrastructure\Models\FastLink\FastLink;
use Shop\Infrastructure\Models\FastLink\FastLinkQuery;


/**
 * This class defines the structure of the 'shop_fastlinks' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class FastLinkTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Shop.Infrastructure.Models.FastLink.Map.FastLinkTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = 'shop_fastlinks';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Shop\\Infrastructure\\Models\\FastLink\\FastLink';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Shop.Infrastructure.Models.FastLink.FastLink';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 4;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 4;

    /**
     * the column name for the code field
     */
    public const COL_CODE = 'shop_fastlinks.code';

    /**
     * the column name for the datetime field
     */
    public const COL_DATETIME = 'shop_fastlinks.datetime';

    /**
     * the column name for the data field
     */
    public const COL_DATA = 'shop_fastlinks.data';

    /**
     * the column name for the owner_customer_id field
     */
    public const COL_OWNER_CUSTOMER_ID = 'shop_fastlinks.owner_customer_id';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Code', 'Datetime', 'Data', 'OwnerCustomerId', ],
        self::TYPE_CAMELNAME     => ['code', 'datetime', 'data', 'ownerCustomerId', ],
        self::TYPE_COLNAME       => [FastLinkTableMap::COL_CODE, FastLinkTableMap::COL_DATETIME, FastLinkTableMap::COL_DATA, FastLinkTableMap::COL_OWNER_CUSTOMER_ID, ],
        self::TYPE_FIELDNAME     => ['code', 'datetime', 'data', 'owner_customer_id', ],
        self::TYPE_NUM           => [0, 1, 2, 3, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Code' => 0, 'Datetime' => 1, 'Data' => 2, 'OwnerCustomerId' => 3, ],
        self::TYPE_CAMELNAME     => ['code' => 0, 'datetime' => 1, 'data' => 2, 'ownerCustomerId' => 3, ],
        self::TYPE_COLNAME       => [FastLinkTableMap::COL_CODE => 0, FastLinkTableMap::COL_DATETIME => 1, FastLinkTableMap::COL_DATA => 2, FastLinkTableMap::COL_OWNER_CUSTOMER_ID => 3, ],
        self::TYPE_FIELDNAME     => ['code' => 0, 'datetime' => 1, 'data' => 2, 'owner_customer_id' => 3, ],
        self::TYPE_NUM           => [0, 1, 2, 3, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Code' => 'CODE',
        'FastLink.Code' => 'CODE',
        'code' => 'CODE',
        'fastLink.code' => 'CODE',
        'FastLinkTableMap::COL_CODE' => 'CODE',
        'COL_CODE' => 'CODE',
        'shop_fastlinks.code' => 'CODE',
        'Datetime' => 'DATETIME',
        'FastLink.Datetime' => 'DATETIME',
        'datetime' => 'DATETIME',
        'fastLink.datetime' => 'DATETIME',
        'FastLinkTableMap::COL_DATETIME' => 'DATETIME',
        'COL_DATETIME' => 'DATETIME',
        'shop_fastlinks.datetime' => 'DATETIME',
        'Data' => 'DATA',
        'FastLink.Data' => 'DATA',
        'data' => 'DATA',
        'fastLink.data' => 'DATA',
        'FastLinkTableMap::COL_DATA' => 'DATA',
        'COL_DATA' => 'DATA',
        'shop_fastlinks.data' => 'DATA',
        'OwnerCustomerId' => 'OWNER_CUSTOMER_ID',
        'FastLink.OwnerCustomerId' => 'OWNER_CUSTOMER_ID',
        'ownerCustomerId' => 'OWNER_CUSTOMER_ID',
        'fastLink.ownerCustomerId' => 'OWNER_CUSTOMER_ID',
        'FastLinkTableMap::COL_OWNER_CUSTOMER_ID' => 'OWNER_CUSTOMER_ID',
        'COL_OWNER_CUSTOMER_ID' => 'OWNER_CUSTOMER_ID',
        'owner_customer_id' => 'OWNER_CUSTOMER_ID',
        'shop_fastlinks.owner_customer_id' => 'OWNER_CUSTOMER_ID',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('shop_fastlinks');
        $this->setPhpName('FastLink');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Infrastructure\\Models\\FastLink\\FastLink');
        $this->setPackage('Shop.Infrastructure.Models.FastLink');
        $this->setUseIdGenerator(false);
        // columns
        $this->addForeignPrimaryKey('code', 'Code', 'CHAR' , 'shop_customer', 'password', true, 40, null);
        $this->addColumn('datetime', 'Datetime', 'TIMESTAMP', true, null, 'CURRENT_TIMESTAMP');
        $this->addColumn('data', 'Data', 'LONGVARCHAR', false, null, null);
        $this->addForeignKey('owner_customer_id', 'OwnerCustomerId', 'INTEGER', 'shop_customer', 'id', true, null, null);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
        $this->addRelation('OwnerCustomer', '\\Shop\\Infrastructure\\Models\\Customer\\Customer', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':owner_customer_id',
    1 => ':id',
  ),
), 'CASCADE', null, null, false);
        $this->addRelation('Customer', '\\Shop\\Infrastructure\\Models\\Customer\\Customer', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':code',
    1 => ':password',
  ),
), null, null, null, false);
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Code', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Code', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Code', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Code', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Code', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Code', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (string) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Code', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? FastLinkTableMap::CLASS_DEFAULT : FastLinkTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (FastLink object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = FastLinkTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = FastLinkTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + FastLinkTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = FastLinkTableMap::OM_CLASS;
            /** @var FastLink $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            FastLinkTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = FastLinkTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = FastLinkTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var FastLink $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                FastLinkTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(FastLinkTableMap::COL_CODE);
            $criteria->addSelectColumn(FastLinkTableMap::COL_DATETIME);
            $criteria->addSelectColumn(FastLinkTableMap::COL_DATA);
            $criteria->addSelectColumn(FastLinkTableMap::COL_OWNER_CUSTOMER_ID);
        } else {
            $criteria->addSelectColumn($alias . '.code');
            $criteria->addSelectColumn($alias . '.datetime');
            $criteria->addSelectColumn($alias . '.data');
            $criteria->addSelectColumn($alias . '.owner_customer_id');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(FastLinkTableMap::COL_CODE);
            $criteria->removeSelectColumn(FastLinkTableMap::COL_DATETIME);
            $criteria->removeSelectColumn(FastLinkTableMap::COL_DATA);
            $criteria->removeSelectColumn(FastLinkTableMap::COL_OWNER_CUSTOMER_ID);
        } else {
            $criteria->removeSelectColumn($alias . '.code');
            $criteria->removeSelectColumn($alias . '.datetime');
            $criteria->removeSelectColumn($alias . '.data');
            $criteria->removeSelectColumn($alias . '.owner_customer_id');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(FastLinkTableMap::DATABASE_NAME)->getTable(FastLinkTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a FastLink or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or FastLink object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(FastLinkTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Infrastructure\Models\FastLink\FastLink) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(FastLinkTableMap::DATABASE_NAME);
            $criteria->add(FastLinkTableMap::COL_CODE, (array) $values, Criteria::IN);
        }

        $query = FastLinkQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            FastLinkTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                FastLinkTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_fastlinks table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return FastLinkQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a FastLink or Criteria object.
     *
     * @param mixed $criteria Criteria or FastLink object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(FastLinkTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from FastLink object
        }


        // Set the correct dbName
        $query = FastLinkQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
