<?php

namespace Shop\Infrastructure\Models\Category\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Infrastructure\Models\Category\Category;
use Shop\Infrastructure\Models\Category\CategoryQuery;


/**
 * This class defines the structure of the 'shop_categories' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class CategoryTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Shop.Infrastructure.Models.Category.Map.CategoryTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = 'shop_categories';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Shop\\Infrastructure\\Models\\Category\\Category';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Shop.Infrastructure.Models.Category.Category';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 8;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 8;

    /**
     * the column name for the id field
     */
    public const COL_ID = 'shop_categories.id';

    /**
     * the column name for the title field
     */
    public const COL_TITLE = 'shop_categories.title';

    /**
     * the column name for the alias field
     */
    public const COL_ALIAS = 'shop_categories.alias';

    /**
     * the column name for the full_title field
     */
    public const COL_FULL_TITLE = 'shop_categories.full_title';

    /**
     * the column name for the image field
     */
    public const COL_IMAGE = 'shop_categories.image';

    /**
     * the column name for the desc field
     */
    public const COL_DESC = 'shop_categories.desc';

    /**
     * the column name for the parent_id field
     */
    public const COL_PARENT_ID = 'shop_categories.parent_id';

    /**
     * the column name for the catalog_id field
     */
    public const COL_CATALOG_ID = 'shop_categories.catalog_id';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'Title', 'Alias', 'FullTitle', 'Image', 'Desc', 'ParentId', 'CatalogId', ],
        self::TYPE_CAMELNAME     => ['id', 'title', 'alias', 'fullTitle', 'image', 'desc', 'parentId', 'catalogId', ],
        self::TYPE_COLNAME       => [CategoryTableMap::COL_ID, CategoryTableMap::COL_TITLE, CategoryTableMap::COL_ALIAS, CategoryTableMap::COL_FULL_TITLE, CategoryTableMap::COL_IMAGE, CategoryTableMap::COL_DESC, CategoryTableMap::COL_PARENT_ID, CategoryTableMap::COL_CATALOG_ID, ],
        self::TYPE_FIELDNAME     => ['id', 'title', 'alias', 'full_title', 'image', 'desc', 'parent_id', 'catalog_id', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'Title' => 1, 'Alias' => 2, 'FullTitle' => 3, 'Image' => 4, 'Desc' => 5, 'ParentId' => 6, 'CatalogId' => 7, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'title' => 1, 'alias' => 2, 'fullTitle' => 3, 'image' => 4, 'desc' => 5, 'parentId' => 6, 'catalogId' => 7, ],
        self::TYPE_COLNAME       => [CategoryTableMap::COL_ID => 0, CategoryTableMap::COL_TITLE => 1, CategoryTableMap::COL_ALIAS => 2, CategoryTableMap::COL_FULL_TITLE => 3, CategoryTableMap::COL_IMAGE => 4, CategoryTableMap::COL_DESC => 5, CategoryTableMap::COL_PARENT_ID => 6, CategoryTableMap::COL_CATALOG_ID => 7, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'title' => 1, 'alias' => 2, 'full_title' => 3, 'image' => 4, 'desc' => 5, 'parent_id' => 6, 'catalog_id' => 7, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'Category.Id' => 'ID',
        'id' => 'ID',
        'category.id' => 'ID',
        'CategoryTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        'shop_categories.id' => 'ID',
        'Title' => 'TITLE',
        'Category.Title' => 'TITLE',
        'title' => 'TITLE',
        'category.title' => 'TITLE',
        'CategoryTableMap::COL_TITLE' => 'TITLE',
        'COL_TITLE' => 'TITLE',
        'shop_categories.title' => 'TITLE',
        'Alias' => 'ALIAS',
        'Category.Alias' => 'ALIAS',
        'alias' => 'ALIAS',
        'category.alias' => 'ALIAS',
        'CategoryTableMap::COL_ALIAS' => 'ALIAS',
        'COL_ALIAS' => 'ALIAS',
        'shop_categories.alias' => 'ALIAS',
        'FullTitle' => 'FULL_TITLE',
        'Category.FullTitle' => 'FULL_TITLE',
        'fullTitle' => 'FULL_TITLE',
        'category.fullTitle' => 'FULL_TITLE',
        'CategoryTableMap::COL_FULL_TITLE' => 'FULL_TITLE',
        'COL_FULL_TITLE' => 'FULL_TITLE',
        'full_title' => 'FULL_TITLE',
        'shop_categories.full_title' => 'FULL_TITLE',
        'Image' => 'IMAGE',
        'Category.Image' => 'IMAGE',
        'image' => 'IMAGE',
        'category.image' => 'IMAGE',
        'CategoryTableMap::COL_IMAGE' => 'IMAGE',
        'COL_IMAGE' => 'IMAGE',
        'shop_categories.image' => 'IMAGE',
        'Desc' => 'DESC',
        'Category.Desc' => 'DESC',
        'desc' => 'DESC',
        'category.desc' => 'DESC',
        'CategoryTableMap::COL_DESC' => 'DESC',
        'COL_DESC' => 'DESC',
        'shop_categories.desc' => 'DESC',
        'ParentId' => 'PARENT_ID',
        'Category.ParentId' => 'PARENT_ID',
        'parentId' => 'PARENT_ID',
        'category.parentId' => 'PARENT_ID',
        'CategoryTableMap::COL_PARENT_ID' => 'PARENT_ID',
        'COL_PARENT_ID' => 'PARENT_ID',
        'parent_id' => 'PARENT_ID',
        'shop_categories.parent_id' => 'PARENT_ID',
        'CatalogId' => 'CATALOG_ID',
        'Category.CatalogId' => 'CATALOG_ID',
        'catalogId' => 'CATALOG_ID',
        'category.catalogId' => 'CATALOG_ID',
        'CategoryTableMap::COL_CATALOG_ID' => 'CATALOG_ID',
        'COL_CATALOG_ID' => 'CATALOG_ID',
        'catalog_id' => 'CATALOG_ID',
        'shop_categories.catalog_id' => 'CATALOG_ID',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('shop_categories');
        $this->setPhpName('Category');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Infrastructure\\Models\\Category\\Category');
        $this->setPackage('Shop.Infrastructure.Models.Category');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('title', 'Title', 'VARCHAR', false, 255, null);
        $this->addColumn('alias', 'Alias', 'VARCHAR', false, 255, null);
        $this->addColumn('full_title', 'FullTitle', 'VARCHAR', false, 255, null);
        $this->addColumn('image', 'Image', 'VARCHAR', false, 255, null);
        $this->addColumn('desc', 'Desc', 'LONGVARCHAR', false, null, null);
        $this->addForeignKey('parent_id', 'ParentId', 'INTEGER', 'shop_categories', 'id', false, null, null);
        $this->addForeignKey('catalog_id', 'CatalogId', 'INTEGER', 'shop_catalogs', 'id', true, null, null);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
        $this->addRelation('ParentCategory', '\\Shop\\Infrastructure\\Models\\Category\\Category', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':parent_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('Catalog', '\\Shop\\Infrastructure\\Models\\Catalog\\Catalog', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':catalog_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('CategoryRelatedById', '\\Shop\\Infrastructure\\Models\\Category\\Category', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':parent_id',
    1 => ':id',
  ),
), null, null, 'CategoriesRelatedById', false);
        $this->addRelation('Product', '\\Shop\\Infrastructure\\Models\\Product\\Product', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':category_id',
    1 => ':id',
  ),
), null, null, 'Products', false);
        $this->addRelation('SizeGridCategoryRel', '\\Shop\\Infrastructure\\Models\\SizeGridCategoryRel\\SizeGridCategoryRel', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':category_id',
    1 => ':id',
  ),
), null, null, 'SizeGridCategoryRels', false);
        $this->addRelation('DiscountRule', '\\Shop\\Infrastructure\\Models\\DiscountRule\\DiscountRule', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':category_id',
    1 => ':id',
  ),
), null, null, 'DiscountRules', false);
        $this->addRelation('ImageDefault', '\\Shop\\Infrastructure\\Models\\ImageDefault\\ImageDefault', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':category_id',
    1 => ':id',
  ),
), null, null, 'ImageDefaults', false);
        $this->addRelation('DraftProduct', '\\Shop\\Infrastructure\\Models\\DraftProduct\\DraftProduct', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':category_id',
    1 => ':id',
  ),
), null, null, 'DraftProducts', false);
        $this->addRelation('SizeGrid', '\\Shop\\Infrastructure\\Models\\SizeGrid\\SizeGrid', RelationMap::MANY_TO_MANY, array(), null, null, 'SizeGrids');
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? CategoryTableMap::CLASS_DEFAULT : CategoryTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (Category object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = CategoryTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = CategoryTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + CategoryTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = CategoryTableMap::OM_CLASS;
            /** @var Category $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            CategoryTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = CategoryTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = CategoryTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var Category $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                CategoryTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(CategoryTableMap::COL_ID);
            $criteria->addSelectColumn(CategoryTableMap::COL_TITLE);
            $criteria->addSelectColumn(CategoryTableMap::COL_ALIAS);
            $criteria->addSelectColumn(CategoryTableMap::COL_FULL_TITLE);
            $criteria->addSelectColumn(CategoryTableMap::COL_IMAGE);
            $criteria->addSelectColumn(CategoryTableMap::COL_DESC);
            $criteria->addSelectColumn(CategoryTableMap::COL_PARENT_ID);
            $criteria->addSelectColumn(CategoryTableMap::COL_CATALOG_ID);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.title');
            $criteria->addSelectColumn($alias . '.alias');
            $criteria->addSelectColumn($alias . '.full_title');
            $criteria->addSelectColumn($alias . '.image');
            $criteria->addSelectColumn($alias . '.desc');
            $criteria->addSelectColumn($alias . '.parent_id');
            $criteria->addSelectColumn($alias . '.catalog_id');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(CategoryTableMap::COL_ID);
            $criteria->removeSelectColumn(CategoryTableMap::COL_TITLE);
            $criteria->removeSelectColumn(CategoryTableMap::COL_ALIAS);
            $criteria->removeSelectColumn(CategoryTableMap::COL_FULL_TITLE);
            $criteria->removeSelectColumn(CategoryTableMap::COL_IMAGE);
            $criteria->removeSelectColumn(CategoryTableMap::COL_DESC);
            $criteria->removeSelectColumn(CategoryTableMap::COL_PARENT_ID);
            $criteria->removeSelectColumn(CategoryTableMap::COL_CATALOG_ID);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.title');
            $criteria->removeSelectColumn($alias . '.alias');
            $criteria->removeSelectColumn($alias . '.full_title');
            $criteria->removeSelectColumn($alias . '.image');
            $criteria->removeSelectColumn($alias . '.desc');
            $criteria->removeSelectColumn($alias . '.parent_id');
            $criteria->removeSelectColumn($alias . '.catalog_id');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(CategoryTableMap::DATABASE_NAME)->getTable(CategoryTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a Category or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or Category object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CategoryTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Infrastructure\Models\Category\Category) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(CategoryTableMap::DATABASE_NAME);
            $criteria->add(CategoryTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = CategoryQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            CategoryTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                CategoryTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_categories table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return CategoryQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a Category or Criteria object.
     *
     * @param mixed $criteria Criteria or Category object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CategoryTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from Category object
        }


        // Set the correct dbName
        $query = CategoryQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
