<?php


namespace Shop\Application\Shopping\Dto;


class OrderItemRequest
{

    /**
     * @var string|null
     */
    protected $name;

    /**
     * @var string|null
     */
    protected $article;

    /**
     * @var float
     */
    protected $price;

    /**
     * @var string|null
     */
    protected $brand;

    /**
     * @var string|null
     */
    protected $desc;

    /**
     * @var int
     */
    protected $amount;

    /**
     * @var string|null
     */
    protected $managerComment;

    /**
     * @var string|null
     */
    protected $refId;

    /**
     * @var int
     */
    protected $currencyId;
    /**
     * @var int
     */
    protected $providerId;

    /**
     * @var string|null
     */
    protected $destination;



    /**
     * @return string|null
     */
    public function getDestination(): ?string
    {
        return $this->destination;
    }

    /**
     * @param string|null $destination
     * @return OrderItemRequest
     */
    public function setDestination(?string $destination): OrderItemRequest
    {
        $this->destination = $destination;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     * @return OrderItemRequest
     */
    public function setName(?string $name): OrderItemRequest
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getArticle(): ?string
    {
        return $this->article;
    }

    /**
     * @param string|null $article
     * @return OrderItemRequest
     */
    public function setArticle(?string $article): OrderItemRequest
    {
        $this->article = $article;
        return $this;
    }

    /**
     * @return float
     */
    public function getPrice(): float
    {
        return $this->price;
    }

    /**
     * @param float $price
     * @return OrderItemRequest
     */
    public function setPrice(float $price): OrderItemRequest
    {
        $this->price = $price;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getBrand(): ?string
    {
        return $this->brand;
    }

    /**
     * @param string|null $brand
     * @return OrderItemRequest
     */
    public function setBrand(?string $brand): OrderItemRequest
    {
        $this->brand = $brand;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDesc(): ?string
    {
        return $this->desc;
    }

    /**
     * @param string|null $desc
     * @return OrderItemRequest
     */
    public function setDesc(?string $desc): OrderItemRequest
    {
        $this->desc = $desc;
        return $this;
    }

    /**
     * @return int
     */
    public function getAmount(): int
    {
        return $this->amount;
    }

    /**
     * @param int $amount
     * @return OrderItemRequest
     */
    public function setAmount(int $amount): OrderItemRequest
    {
        $this->amount = $amount;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getManagerComment(): ?string
    {
        return $this->managerComment;
    }

    /**
     * @param string|null $managerComment
     * @return OrderItemRequest
     */
    public function setManagerComment(?string $managerComment): OrderItemRequest
    {
        $this->managerComment = $managerComment;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getRefId(): ?string
    {
        return $this->refId;
    }

    /**
     * @param string|null $refId
     * @return OrderItemRequest
     */
    public function setRefId(?string $refId): OrderItemRequest
    {
        $this->refId = $refId;
        return $this;
    }

    /**
     * @return int
     */
    public function getCurrencyId(): int
    {
        return $this->currencyId;
    }

    /**
     * @param int $currencyId
     * @return OrderItemRequest
     */
    public function setCurrencyId(int $currencyId): OrderItemRequest
    {
        $this->currencyId = $currencyId;
        return $this;
    }

    /**
     * @return int
     */
    public function getProviderId(): int
    {
        return $this->providerId;
    }

    /**
     * @param int $providerId
     * @return OrderItemRequest
     */
    public function setProviderId(int $providerId): OrderItemRequest
    {
        $this->providerId = $providerId;
        return $this;
    }
}