<?php

namespace Shop\Presentation\Modules\AdminShops;

use ActiveTable\Contracts\CommandInterface;
use Diamond\Helpers\Form;
use Shop\Domain\Stock\Contracts\StockEntityInterface;
use Shop\Infrastructure\Models\Shop\Shop;
use Shop\Infrastructure\Repositories\Stock\StockRepository;
use Symfony\Component\HttpFoundation\RedirectResponse;

class DisableStocksCommand implements CommandInterface
{

    private $stockRepository;

    public function __construct(StockRepository $stockRepository)
    {
        $this->stockRepository = $stockRepository;
    }

    public function process(): void
    {

        $ids = Form::getIdsFromRequest();

        /**
         * @var StockEntityInterface| Shop $stock
         */
        foreach ($ids as $id){
            $stock = $this->stockRepository->findById($id);
            $stock->setActive("N");
            $this->stockRepository->save($stock);
        }

        Form::addTableNotice(Form::buildSuccessMessage('Торговые точки успешно деактивированы'));

        RedirectResponse::create(adaptive_url([], ['fn', 'id']))->send();
    }


}