<?php

namespace Shop\Presentation\Modules\AdminContractorsLite;

use ActiveTable\ColumnTable;
use ActiveTable\DataTableEngine;
use Core\Form\Control\MenuItemWindowSelect;
use Repo\EntityInterface;
use Shop\Domain\Customer\Contracts\CustomerEntityInterface;
use Shop\Presentation\Modules\AdminContractors\AdminContractors;

/**
 * Description of AdminContractorsLite
 *
 * @author Diamond Code Generator
 */
class AdminContractorsLite extends AdminContractors
{

    /**
     * @param DataTableEngine $table
     */
    protected function prepareColumns(DataTableEngine $table): void
    {
        $table
            ->removeControlAccess(DataTableEngine::CONTROL_ROWS_ACTION)
            ->addColumn(
                (new ColumnTable('id', '№'))
                    ->setSorted(true)
                    ->setWidth(5, true)
            )
            ->addColumn(
                (new ColumnTable('name', 'ФИО'))->setWidth(15, true)
            )
            ->addColumn(
                (new ColumnTable('email', 'E-mail/Логин'))
                    ->setSorted(true)
                    ->setWidth(15, true)
            )
            ->addColumn(
                (new ColumnTable('phone', 'Телефон'))->setWidth(10, true)
            )
            ->addColumn(
                (new ColumnTable('address', 'Адрес'))
                    ->setFormat($this, 'formatAddress')
                    ->setWidth(25, true)
            )
            ->addColumn(
                (new ColumnTable('blocked', 'Заблокирован'))
                    ->setFormat($this, 'formatBlocked')
                    ->setWidth(5, true)
            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setWidth(15, true)
                    ->setFormat($this, 'formatActions')
            );

    }

    public function formatActions(CustomerEntityInterface $projectEntity, ?array $items = []): string
    {
        $items = [];
        $items[] = new MenuItemWindowSelect($projectEntity->getName(), 'contractorId', $projectEntity->getId());
        return parent::formatActions($projectEntity, $items);
    }

}               