<?php

namespace Shop\Infrastructure\Repositories\DiscountRule;

use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\DiscountRule\Contracts\DiscountRuleEntityInterface;
use Shop\Domain\DiscountRule\DiscountRuleCollection;
use Shop\Infrastructure\Models\DiscountRule\DiscountRule;
use Shop\Infrastructure\Models\DiscountRule\DiscountRuleQuery;

/**
 * Class DiscountRuleRepository
 * @package Shop\Infrastructure\Repositories\DiscountRule
 */
class DiscountRuleRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    /**
     * @return EntityInterface|DiscountRuleEntityInterface
     */
    public static function createEntity(): EntityInterface
    {
        return new DiscountRule();
    }

    /**
     * @return ModelCriteria|DiscountRuleQuery
     */
    protected function createQuery(): ModelCriteria
    {
        return DiscountRuleQuery::create();
    }

    /**
     * @param PaginationInterface $criteria
     * @param ModelCriteria $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
  
    }


    protected function createCollection(): CollectionInterface
    {
        return new DiscountRuleCollection();
    }

}