<?php

namespace Shop\Infrastructure\Models\Position\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Infrastructure\Models\Position\Position;
use Shop\Infrastructure\Models\Position\PositionQuery;
use Shop\Infrastructure\Models\ShopPositionSize\Map\ShopPositionSizeTableMap;


/**
 * This class defines the structure of the 'shop_positions' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class PositionTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Shop.Infrastructure.Models.Position.Map.PositionTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = 'shop_positions';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Shop\\Infrastructure\\Models\\Position\\Position';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Shop.Infrastructure.Models.Position.Position';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 11;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 11;

    /**
     * the column name for the id field
     */
    public const COL_ID = 'shop_positions.id';

    /**
     * the column name for the desc field
     */
    public const COL_DESC = 'shop_positions.desc';

    /**
     * the column name for the remain field
     */
    public const COL_REMAIN = 'shop_positions.remain';

    /**
     * the column name for the price field
     */
    public const COL_PRICE = 'shop_positions.price';

    /**
     * the column name for the price_old field
     */
    public const COL_PRICE_OLD = 'shop_positions.price_old';

    /**
     * the column name for the destination field
     */
    public const COL_DESTINATION = 'shop_positions.destination';

    /**
     * the column name for the sale_id field
     */
    public const COL_SALE_ID = 'shop_positions.sale_id';

    /**
     * the column name for the image field
     */
    public const COL_IMAGE = 'shop_positions.image';

    /**
     * the column name for the product_id field
     */
    public const COL_PRODUCT_ID = 'shop_positions.product_id';

    /**
     * the column name for the pricelist_sheet_id field
     */
    public const COL_PRICELIST_SHEET_ID = 'shop_positions.pricelist_sheet_id';

    /**
     * the column name for the ref_id field
     */
    public const COL_REF_ID = 'shop_positions.ref_id';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'Desc', 'Remain', 'Price', 'PriceOld', 'Destination', 'SaleId', 'Image', 'ProductId', 'PricelistSheetId', 'RefId', ],
        self::TYPE_CAMELNAME     => ['id', 'desc', 'remain', 'price', 'priceOld', 'destination', 'saleId', 'image', 'productId', 'pricelistSheetId', 'refId', ],
        self::TYPE_COLNAME       => [PositionTableMap::COL_ID, PositionTableMap::COL_DESC, PositionTableMap::COL_REMAIN, PositionTableMap::COL_PRICE, PositionTableMap::COL_PRICE_OLD, PositionTableMap::COL_DESTINATION, PositionTableMap::COL_SALE_ID, PositionTableMap::COL_IMAGE, PositionTableMap::COL_PRODUCT_ID, PositionTableMap::COL_PRICELIST_SHEET_ID, PositionTableMap::COL_REF_ID, ],
        self::TYPE_FIELDNAME     => ['id', 'desc', 'remain', 'price', 'price_old', 'destination', 'sale_id', 'image', 'product_id', 'pricelist_sheet_id', 'ref_id', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'Desc' => 1, 'Remain' => 2, 'Price' => 3, 'PriceOld' => 4, 'Destination' => 5, 'SaleId' => 6, 'Image' => 7, 'ProductId' => 8, 'PricelistSheetId' => 9, 'RefId' => 10, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'desc' => 1, 'remain' => 2, 'price' => 3, 'priceOld' => 4, 'destination' => 5, 'saleId' => 6, 'image' => 7, 'productId' => 8, 'pricelistSheetId' => 9, 'refId' => 10, ],
        self::TYPE_COLNAME       => [PositionTableMap::COL_ID => 0, PositionTableMap::COL_DESC => 1, PositionTableMap::COL_REMAIN => 2, PositionTableMap::COL_PRICE => 3, PositionTableMap::COL_PRICE_OLD => 4, PositionTableMap::COL_DESTINATION => 5, PositionTableMap::COL_SALE_ID => 6, PositionTableMap::COL_IMAGE => 7, PositionTableMap::COL_PRODUCT_ID => 8, PositionTableMap::COL_PRICELIST_SHEET_ID => 9, PositionTableMap::COL_REF_ID => 10, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'desc' => 1, 'remain' => 2, 'price' => 3, 'price_old' => 4, 'destination' => 5, 'sale_id' => 6, 'image' => 7, 'product_id' => 8, 'pricelist_sheet_id' => 9, 'ref_id' => 10, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'Position.Id' => 'ID',
        'id' => 'ID',
        'position.id' => 'ID',
        'PositionTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        'shop_positions.id' => 'ID',
        'Desc' => 'DESC',
        'Position.Desc' => 'DESC',
        'desc' => 'DESC',
        'position.desc' => 'DESC',
        'PositionTableMap::COL_DESC' => 'DESC',
        'COL_DESC' => 'DESC',
        'shop_positions.desc' => 'DESC',
        'Remain' => 'REMAIN',
        'Position.Remain' => 'REMAIN',
        'remain' => 'REMAIN',
        'position.remain' => 'REMAIN',
        'PositionTableMap::COL_REMAIN' => 'REMAIN',
        'COL_REMAIN' => 'REMAIN',
        'shop_positions.remain' => 'REMAIN',
        'Price' => 'PRICE',
        'Position.Price' => 'PRICE',
        'price' => 'PRICE',
        'position.price' => 'PRICE',
        'PositionTableMap::COL_PRICE' => 'PRICE',
        'COL_PRICE' => 'PRICE',
        'shop_positions.price' => 'PRICE',
        'PriceOld' => 'PRICE_OLD',
        'Position.PriceOld' => 'PRICE_OLD',
        'priceOld' => 'PRICE_OLD',
        'position.priceOld' => 'PRICE_OLD',
        'PositionTableMap::COL_PRICE_OLD' => 'PRICE_OLD',
        'COL_PRICE_OLD' => 'PRICE_OLD',
        'price_old' => 'PRICE_OLD',
        'shop_positions.price_old' => 'PRICE_OLD',
        'Destination' => 'DESTINATION',
        'Position.Destination' => 'DESTINATION',
        'destination' => 'DESTINATION',
        'position.destination' => 'DESTINATION',
        'PositionTableMap::COL_DESTINATION' => 'DESTINATION',
        'COL_DESTINATION' => 'DESTINATION',
        'shop_positions.destination' => 'DESTINATION',
        'SaleId' => 'SALE_ID',
        'Position.SaleId' => 'SALE_ID',
        'saleId' => 'SALE_ID',
        'position.saleId' => 'SALE_ID',
        'PositionTableMap::COL_SALE_ID' => 'SALE_ID',
        'COL_SALE_ID' => 'SALE_ID',
        'sale_id' => 'SALE_ID',
        'shop_positions.sale_id' => 'SALE_ID',
        'Image' => 'IMAGE',
        'Position.Image' => 'IMAGE',
        'image' => 'IMAGE',
        'position.image' => 'IMAGE',
        'PositionTableMap::COL_IMAGE' => 'IMAGE',
        'COL_IMAGE' => 'IMAGE',
        'shop_positions.image' => 'IMAGE',
        'ProductId' => 'PRODUCT_ID',
        'Position.ProductId' => 'PRODUCT_ID',
        'productId' => 'PRODUCT_ID',
        'position.productId' => 'PRODUCT_ID',
        'PositionTableMap::COL_PRODUCT_ID' => 'PRODUCT_ID',
        'COL_PRODUCT_ID' => 'PRODUCT_ID',
        'product_id' => 'PRODUCT_ID',
        'shop_positions.product_id' => 'PRODUCT_ID',
        'PricelistSheetId' => 'PRICELIST_SHEET_ID',
        'Position.PricelistSheetId' => 'PRICELIST_SHEET_ID',
        'pricelistSheetId' => 'PRICELIST_SHEET_ID',
        'position.pricelistSheetId' => 'PRICELIST_SHEET_ID',
        'PositionTableMap::COL_PRICELIST_SHEET_ID' => 'PRICELIST_SHEET_ID',
        'COL_PRICELIST_SHEET_ID' => 'PRICELIST_SHEET_ID',
        'pricelist_sheet_id' => 'PRICELIST_SHEET_ID',
        'shop_positions.pricelist_sheet_id' => 'PRICELIST_SHEET_ID',
        'RefId' => 'REF_ID',
        'Position.RefId' => 'REF_ID',
        'refId' => 'REF_ID',
        'position.refId' => 'REF_ID',
        'PositionTableMap::COL_REF_ID' => 'REF_ID',
        'COL_REF_ID' => 'REF_ID',
        'ref_id' => 'REF_ID',
        'shop_positions.ref_id' => 'REF_ID',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('shop_positions');
        $this->setPhpName('Position');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Infrastructure\\Models\\Position\\Position');
        $this->setPackage('Shop.Infrastructure.Models.Position');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('desc', 'Desc', 'LONGVARCHAR', false, null, null);
        $this->addColumn('remain', 'Remain', 'INTEGER', true, null, 0);
        $this->addColumn('price', 'Price', 'DECIMAL', false, 19, 0.00);
        $this->addColumn('price_old', 'PriceOld', 'DECIMAL', false, 19, 0.00);
        $this->addColumn('destination', 'Destination', 'VARCHAR', false, 255, null);
        $this->addForeignKey('sale_id', 'SaleId', 'INTEGER', 'shop_sales', 'id', false, null, null);
        $this->addColumn('image', 'Image', 'VARCHAR', false, 255, null);
        $this->addForeignKey('product_id', 'ProductId', 'INTEGER', 'shop_products', 'id', true, null, null);
        $this->addForeignKey('pricelist_sheet_id', 'PricelistSheetId', 'INTEGER', 'shop_pricelist_sheets', 'id', true, null, null);
        $this->addColumn('ref_id', 'RefId', 'CHAR', false, 100, null);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
        $this->addRelation('Sale', '\\Shop\\Infrastructure\\Models\\Sale\\Sale', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':sale_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('Product', '\\Shop\\Infrastructure\\Models\\Product\\Product', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':product_id',
    1 => ':id',
  ),
), 'CASCADE', null, null, false);
        $this->addRelation('PricelistSheet', '\\Shop\\Infrastructure\\Models\\PricelistSheet\\PricelistSheet', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':pricelist_sheet_id',
    1 => ':id',
  ),
), 'CASCADE', null, null, false);
        $this->addRelation('ShopPositionSize', '\\Shop\\Infrastructure\\Models\\ShopPositionSize\\ShopPositionSize', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':position_id',
    1 => ':id',
  ),
), 'CASCADE', null, 'ShopPositionSizes', false);
        $this->addRelation('ShopPositionSizeType', '\\Shop\\Infrastructure\\Models\\ShopPositionSizeType\\ShopPositionSizeType', RelationMap::MANY_TO_MANY, array(), null, null, 'ShopPositionSizeTypes');
    }

    /**
     * Method to invalidate the instance pool of all tables related to shop_positions     * by a foreign key with ON DELETE CASCADE
     */
    public static function clearRelatedInstancePool(): void
    {
        // Invalidate objects in related instance pools,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        ShopPositionSizeTableMap::clearInstancePool();
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? PositionTableMap::CLASS_DEFAULT : PositionTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (Position object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = PositionTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = PositionTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + PositionTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = PositionTableMap::OM_CLASS;
            /** @var Position $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            PositionTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = PositionTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = PositionTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var Position $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                PositionTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(PositionTableMap::COL_ID);
            $criteria->addSelectColumn(PositionTableMap::COL_DESC);
            $criteria->addSelectColumn(PositionTableMap::COL_REMAIN);
            $criteria->addSelectColumn(PositionTableMap::COL_PRICE);
            $criteria->addSelectColumn(PositionTableMap::COL_PRICE_OLD);
            $criteria->addSelectColumn(PositionTableMap::COL_DESTINATION);
            $criteria->addSelectColumn(PositionTableMap::COL_SALE_ID);
            $criteria->addSelectColumn(PositionTableMap::COL_IMAGE);
            $criteria->addSelectColumn(PositionTableMap::COL_PRODUCT_ID);
            $criteria->addSelectColumn(PositionTableMap::COL_PRICELIST_SHEET_ID);
            $criteria->addSelectColumn(PositionTableMap::COL_REF_ID);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.desc');
            $criteria->addSelectColumn($alias . '.remain');
            $criteria->addSelectColumn($alias . '.price');
            $criteria->addSelectColumn($alias . '.price_old');
            $criteria->addSelectColumn($alias . '.destination');
            $criteria->addSelectColumn($alias . '.sale_id');
            $criteria->addSelectColumn($alias . '.image');
            $criteria->addSelectColumn($alias . '.product_id');
            $criteria->addSelectColumn($alias . '.pricelist_sheet_id');
            $criteria->addSelectColumn($alias . '.ref_id');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(PositionTableMap::COL_ID);
            $criteria->removeSelectColumn(PositionTableMap::COL_DESC);
            $criteria->removeSelectColumn(PositionTableMap::COL_REMAIN);
            $criteria->removeSelectColumn(PositionTableMap::COL_PRICE);
            $criteria->removeSelectColumn(PositionTableMap::COL_PRICE_OLD);
            $criteria->removeSelectColumn(PositionTableMap::COL_DESTINATION);
            $criteria->removeSelectColumn(PositionTableMap::COL_SALE_ID);
            $criteria->removeSelectColumn(PositionTableMap::COL_IMAGE);
            $criteria->removeSelectColumn(PositionTableMap::COL_PRODUCT_ID);
            $criteria->removeSelectColumn(PositionTableMap::COL_PRICELIST_SHEET_ID);
            $criteria->removeSelectColumn(PositionTableMap::COL_REF_ID);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.desc');
            $criteria->removeSelectColumn($alias . '.remain');
            $criteria->removeSelectColumn($alias . '.price');
            $criteria->removeSelectColumn($alias . '.price_old');
            $criteria->removeSelectColumn($alias . '.destination');
            $criteria->removeSelectColumn($alias . '.sale_id');
            $criteria->removeSelectColumn($alias . '.image');
            $criteria->removeSelectColumn($alias . '.product_id');
            $criteria->removeSelectColumn($alias . '.pricelist_sheet_id');
            $criteria->removeSelectColumn($alias . '.ref_id');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(PositionTableMap::DATABASE_NAME)->getTable(PositionTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a Position or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or Position object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PositionTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Infrastructure\Models\Position\Position) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(PositionTableMap::DATABASE_NAME);
            $criteria->add(PositionTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = PositionQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            PositionTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                PositionTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_positions table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return PositionQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a Position or Criteria object.
     *
     * @param mixed $criteria Criteria or Position object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PositionTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from Position object
        }

        if ($criteria->containsKey(PositionTableMap::COL_ID) && $criteria->keyContainsValue(PositionTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.PositionTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = PositionQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
