<?php

namespace Shop\Domain\Product\Contracts;

use Repo\PaginationInterface;
use Repo\RepositoryCriteriaInterface;

/**
 * Description of Product
 *
 * @author Diamond Code Generator
 */
interface ProductCriteriaInterface extends RepositoryCriteriaInterface, PaginationInterface
{

    public function isStrictWithPosition(): bool;

    public function setStrictWithPosition(bool $strictWithPosition): ProductCriteriaInterface;
    
    /**
     * @return string|null
     */
    public function getSortByTitle(): ?string;

    /**
     * @return string|null
     */
    public function getSearchByBrand(): ?string;

    /**
     * @return string|null
     */
    public function getSearchByArticle(): ?string;

    /**
     * @return string|null
     */
    public function getSearchByTitle(): ?string;

    /**
     * @return array|null
     */
    public function getFilterByIgnoreCategories(): ?array;

    /**
     * @return array|null
     */
    public function getFilterByPriceListScheetIds(): ?array;

    /**
     * @return int|null
     */
    public function getFilterByCategoryId(): ?int;

    /**
     * @return bool|null
     */
    public function getFilterByImageExist(): ?bool;

    /**
     * @return array|null
     */
    public function getFilterByBrandNames(): ?array;


    /**
     * @return string|null
     */
    public function getFilterByName(): ?string;

    /**
     * @return array|null
     */
    public function getFilterByBrandIds(): ?array;

    /**
     * @return int|null4
     */
    public function getFilterByBrandId(): ?int;

    /**
     * @return array|null
     */
    public function getFilterByGroupIds(): ?array;

    /**
     * @return array|null
     */
    public function getFilterBySizeTypeIds(): ?array;

    /**
     * @return float|null
     */
    public function getFilterByPriceMax(): ?float;

    /**
     * @return float|null
     */
    public function getFilterByPriceMin(): ?float;

    /**
     * @return int|null
     */
    public function getFilterBySaleId(): ?int;

    /**
     * @return array|null
     */
    public function getFilterByCategoryIds(): ?array;

    /**
     * @return array|null
     */
    public function getFilterByCategoryParentIds(): ?array;

    /**
     * @return array|null
     */
    public function getFilterByDestinations(): ?array;

    public function getSearchByArticleOrNameOrBrendName(): ?string;

    public function setSearchByArticleOrNameOrBrendName(?string $searchByArticleOrNameOrBrendName): ProductCriteriaInterface;
}           