<?

namespace Shop\Presentation\Helpers;

/**
 * Помошник для отображения цены
 *
 * @author Admin
 */
class Price
{

    /**
     * @param string $n
     * @param int $p
     * @return string
     */
    public static function format($n = '', $p = 2, $thousands_separator = ' '): string
    {
        return ($n === '') ? '' : number_format((float)$n, $p, '.', $thousands_separator);
    }

    /**
     * Форматироание цены, или цен
     * @param array|int $prices
     * @param string $currency
     * @param string $delim
     * @param int $p
     * @return string
     */
    public static function display($prices, string $currency = '', string $delim = "-", int $p = 2): string
    {

        $min = $max = 0;
        foreach ((array)$prices as $price) {
            if ($price > $max)
                $max = $price;
            if ($price < $min || $min == 0)
                $min = $price;
        }

        if ($min != $max)
            $output = self::format($min, $p) . $delim . self::format($max, $p);
        else
            $output = self::format($min, $p);

        return sprintf("%s%s", $output, $currency ? $currency : "");
    }

}
