<?php

namespace Shop\Presentation\Controllers;

use Core\Form\ControlBuilder;
use Shop\Infrastructure\Repositories\City\CityCriteria;
use Shop\Infrastructure\Repositories\City\CityRepository;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Description of City
 *
 * @author Admin
 */
class CityController extends \Core\BaseController
{
    //put your code here

    protected $cityRepo;

    protected $builder;

    public function __construct(CityRepository $cityRepo, ControlBuilder $cBuilder)
    {
        $this->cityRepo = $cityRepo;
        $this->builder = $cBuilder;
    }

    /**
     * @return JsonResponse
     */
    function index()
    {

        $dropdown = $this->cityRepo->findByCriteria(
            CityCriteria::create()->setFilterByRegionId((int)input_get('region'))
        )->getDropdownList();

        $data [] = [
            'id' => null,
            'value' => '- не выбранно -'
        ];
        foreach ($dropdown as $key => $value) {

            $data[] = [
                'id' => $key,
                'value' => $value
            ];
        }

        return new JsonResponse($data);
    }

}
