<?php


namespace Shop\Infrastructure\Repositories\PriceAccess;


use Repo\Concrete\AbstractCriteria;
use Shop\Domain\PriceAccess\Contracts\PriceAccessCriteriaInterface;

class PriceAccessCriteria extends AbstractCriteria implements PriceAccessCriteriaInterface
{
    /**
     * @var int|null
     */
    protected $filterByShopId;

    public static function create()
    {
        return new self;
    }

    /**
     * @return int|null
     */
    public function getFilterByShopId(): ?int
    {
        return $this->filterByShopId;
    }

    /**
     * @param int|null $filterByShopId
     * @return PriceAccessCriteria
     */
    public function setFilterByShopId(?int $filterByShopId): PriceAccessCriteria
    {
        $this->filterByShopId = $filterByShopId;
        return $this;
    }


}