<?php


namespace Shop\Infrastructure\Repositories\Customer;


use Repo\Concrete\AbstractCriteria;
use Shop\Domain\Customer\Contracts\CustomerCriteriaInterface;

class CustomerCriteria extends AbstractCriteria implements CustomerCriteriaInterface
{
    protected string|null $filterByCreateMonthDate = null;

    /**
     * @var string|null
     */
    protected $filterByEmail;

    /**
     * @var string|null
     */
    protected $filterByPassword;

    /**
     * @var string|null
     */
    protected $sortByEmail;
    /**
     * @var int|null
     */
    protected $filterByStockId;
    /**
     * @var int|null
     */
    protected $filterByGroupId;

    /**
     * @var array|null
     */
    protected $filterByGroupIds;

    /**
     * @var string|null
     */
    protected $searchByEmail;

    /**
     * @var string|null
     */
    protected $searchByName;

    /**
     * @var string|null
     */
    protected $sortByRegistred;

    /**
     * @var bool|null
     */
    protected $filterByBlocked;

    /**
     * @var int|null
     */
    protected $filterByManagerId;

    /**
     * @var bool|null
     */
    protected $filterByOnlyAyth;

    public static function create()
    {
        return new self();
    }

    /**
     * @return string|null
     */
    public function getFilterByCreateMonthDate(): ?string
    {
        return $this->filterByCreateMonthDate;
    }

    /**
     * @param string|null $filterByCreateMonthDate
     * @return CustomerCriteria
     */
    public function setFilterByCreateMonthDate(?string $filterByCreateMonthDate): CustomerCriteriaInterface
    {
        $this->filterByCreateMonthDate = $filterByCreateMonthDate;
        return $this;
    }


    /**
     * @return bool|null
     */
    public function getFilterByOnlyAyth(): ?bool
    {
        return $this->filterByOnlyAyth;
    }

    /**
     * @param bool|null $filterByOnlyAyth
     * @return CustomerCriteriaInterface
     */
    public function setFilterByOnlyAyth(?bool $filterByOnlyAyth): CustomerCriteriaInterface
    {
        $this->filterByOnlyAyth = $filterByOnlyAyth;
        return $this;
    }


    /**
     * @return int|null
     */
    public function getFilterByManagerId(): ?int
    {
        return $this->filterByManagerId;
    }

    /**
     * @param int|null $filterByManagerId
     * @return CustomerCriteria
     */
    public function setFilterByManagerId(?int $filterByManagerId): CustomerCriteriaInterface
    {
        $this->filterByManagerId = $filterByManagerId;
        return $this;
    }


    /**
     * @return bool|null
     */
    public function getFilterByBlocked(): ?bool
    {
        return $this->filterByBlocked;
    }

    /**
     * @param bool|null $filterByBlocked
     * @return CustomerCriteria
     */
    public function setFilterByBlocked(?bool $filterByBlocked): CustomerCriteria
    {
        $this->filterByBlocked = $filterByBlocked;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getFilterByPassword(): ?string
    {
        return $this->filterByPassword;
    }

    /**
     * @param string|null $filterByPassword
     * @return CustomerCriteria
     */
    public function setFilterByPassword(?string $filterByPassword): CustomerCriteria
    {
        $this->filterByPassword = $filterByPassword;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFilterByEmail(): ?string
    {
        return $this->filterByEmail;
    }

    /**
     * @param string|null $filterByEmail
     * @return CustomerCriteria
     */
    public function setFilterByEmail(?string $filterByEmail): CustomerCriteria
    {
        $this->filterByEmail = $filterByEmail;
        return $this;
    }

    /**
     * @return array|null
     */
    public function getFilterByGroupIds(): ?array
    {
        return $this->filterByGroupIds;
    }

    /**
     * @param array|null $filterByGroupIds
     * @return CustomerCriteria
     */
    public function setFilterByGroupIds(?array $filterByGroupIds): CustomerCriteria
    {
        $this->filterByGroupIds = $filterByGroupIds;
        return $this;
    }



    /**
     * @return string|null
     */
    public function getSortByEmail(): ?string
    {
        return $this->sortByEmail;
    }

    /**
     * @param string|null $sortByEmail
     * @return CustomerCriteria
     */
    public function setSortByEmail(?string $sortByEmail): CustomerCriteria
    {
        $this->sortByEmail = $sortByEmail;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getFilterByGroupId(): ?int
    {
        return $this->filterByGroupId;
    }

    /**
     * @param int|null $filterByGroupId
     * @return CustomerCriteria
     */
    public function setFilterByGroupId(?int $filterByGroupId): CustomerCriteria
    {
        $this->filterByGroupId = $filterByGroupId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSearchByEmail(): ?string
    {
        return $this->searchByEmail;
    }

    /**
     * @param string|null $searchByEmail
     * @return CustomerCriteria
     */
    public function setSearchByEmail(?string $searchByEmail): CustomerCriteria
    {
        $this->searchByEmail = $searchByEmail;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSearchByName(): ?string
    {
        return $this->searchByName;
    }

    /**
     * @param string|null $searchByName
     */
    public function setSearchByName(?string $searchByName): void
    {
        $this->searchByName = $searchByName;
    }

    /**
     * @return int|null
     */
    public function getFilterByStockId(): ?int
    {
        return $this->filterByStockId;
    }

    /**
     * @param int|null $filterByStockId
     * @return CustomerCriteria
     */
    public function setFilterByStockId(?int $filterByStockId): CustomerCriteria
    {
        $this->filterByStockId = $filterByStockId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSortByRegistred(): ?string
    {
        return $this->sortByRegistred;
    }

    /**
     * @param string|null $sortByRegistred
     * @return CustomerCriteria
     */
    public function setSortByRegistred(?string $sortByRegistred): CustomerCriteria
    {
        $this->sortByRegistred = $sortByRegistred;
        return $this;
    }


}