<?php

namespace Shop\Infrastructure\Models\SizeGridCategoryRel\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Infrastructure\Models\Category\Category;
use Shop\Infrastructure\Models\SizeGrid\SizeGrid;
use Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRel as ChildSizeGridCategoryRel;
use Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRelQuery as ChildSizeGridCategoryRelQuery;
use Shop\Infrastructure\Models\SizeGridCategoryRel\Map\SizeGridCategoryRelTableMap;

/**
 * Base class that represents a query for the 'shop_size_grid_category_rel' table.
 *
 *
 *
 * @method     ChildSizeGridCategoryRelQuery orderByCategoryId($order = Criteria::ASC) Order by the category_id column
 * @method     ChildSizeGridCategoryRelQuery orderBySizeGridId($order = Criteria::ASC) Order by the size_grid_id column
 *
 * @method     ChildSizeGridCategoryRelQuery groupByCategoryId() Group by the category_id column
 * @method     ChildSizeGridCategoryRelQuery groupBySizeGridId() Group by the size_grid_id column
 *
 * @method     ChildSizeGridCategoryRelQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildSizeGridCategoryRelQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildSizeGridCategoryRelQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildSizeGridCategoryRelQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildSizeGridCategoryRelQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildSizeGridCategoryRelQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildSizeGridCategoryRelQuery leftJoinCategory($relationAlias = null) Adds a LEFT JOIN clause to the query using the Category relation
 * @method     ChildSizeGridCategoryRelQuery rightJoinCategory($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Category relation
 * @method     ChildSizeGridCategoryRelQuery innerJoinCategory($relationAlias = null) Adds a INNER JOIN clause to the query using the Category relation
 *
 * @method     ChildSizeGridCategoryRelQuery joinWithCategory($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Category relation
 *
 * @method     ChildSizeGridCategoryRelQuery leftJoinWithCategory() Adds a LEFT JOIN clause and with to the query using the Category relation
 * @method     ChildSizeGridCategoryRelQuery rightJoinWithCategory() Adds a RIGHT JOIN clause and with to the query using the Category relation
 * @method     ChildSizeGridCategoryRelQuery innerJoinWithCategory() Adds a INNER JOIN clause and with to the query using the Category relation
 *
 * @method     ChildSizeGridCategoryRelQuery leftJoinSizeGrid($relationAlias = null) Adds a LEFT JOIN clause to the query using the SizeGrid relation
 * @method     ChildSizeGridCategoryRelQuery rightJoinSizeGrid($relationAlias = null) Adds a RIGHT JOIN clause to the query using the SizeGrid relation
 * @method     ChildSizeGridCategoryRelQuery innerJoinSizeGrid($relationAlias = null) Adds a INNER JOIN clause to the query using the SizeGrid relation
 *
 * @method     ChildSizeGridCategoryRelQuery joinWithSizeGrid($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the SizeGrid relation
 *
 * @method     ChildSizeGridCategoryRelQuery leftJoinWithSizeGrid() Adds a LEFT JOIN clause and with to the query using the SizeGrid relation
 * @method     ChildSizeGridCategoryRelQuery rightJoinWithSizeGrid() Adds a RIGHT JOIN clause and with to the query using the SizeGrid relation
 * @method     ChildSizeGridCategoryRelQuery innerJoinWithSizeGrid() Adds a INNER JOIN clause and with to the query using the SizeGrid relation
 *
 * @method     \Shop\Infrastructure\Models\Category\CategoryQuery|\Shop\Infrastructure\Models\SizeGrid\SizeGridQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildSizeGridCategoryRel findOne(ConnectionInterface $con = null) Return the first ChildSizeGridCategoryRel matching the query
 * @method     ChildSizeGridCategoryRel findOneOrCreate(ConnectionInterface $con = null) Return the first ChildSizeGridCategoryRel matching the query, or a new ChildSizeGridCategoryRel object populated from the query conditions when no match is found
 *
 * @method     ChildSizeGridCategoryRel findOneByCategoryId(int $category_id) Return the first ChildSizeGridCategoryRel filtered by the category_id column
 * @method     ChildSizeGridCategoryRel findOneBySizeGridId(int $size_grid_id) Return the first ChildSizeGridCategoryRel filtered by the size_grid_id column *

 * @method     ChildSizeGridCategoryRel requirePk($key, ConnectionInterface $con = null) Return the ChildSizeGridCategoryRel by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSizeGridCategoryRel requireOne(ConnectionInterface $con = null) Return the first ChildSizeGridCategoryRel matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildSizeGridCategoryRel requireOneByCategoryId(int $category_id) Return the first ChildSizeGridCategoryRel filtered by the category_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSizeGridCategoryRel requireOneBySizeGridId(int $size_grid_id) Return the first ChildSizeGridCategoryRel filtered by the size_grid_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildSizeGridCategoryRel[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildSizeGridCategoryRel objects based on current ModelCriteria
 * @method     ChildSizeGridCategoryRel[]|ObjectCollection findByCategoryId(int $category_id) Return ChildSizeGridCategoryRel objects filtered by the category_id column
 * @method     ChildSizeGridCategoryRel[]|ObjectCollection findBySizeGridId(int $size_grid_id) Return ChildSizeGridCategoryRel objects filtered by the size_grid_id column
 * @method     ChildSizeGridCategoryRel[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class SizeGridCategoryRelQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Infrastructure\Models\SizeGridCategoryRel\Base\SizeGridCategoryRelQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\SizeGridCategoryRel\\SizeGridCategoryRel', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildSizeGridCategoryRelQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildSizeGridCategoryRelQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildSizeGridCategoryRelQuery) {
            return $criteria;
        }
        $query = new ChildSizeGridCategoryRelQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34), $con);
     * </code>
     *
     * @param array[$category_id, $size_grid_id] $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildSizeGridCategoryRel|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(SizeGridCategoryRelTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = SizeGridCategoryRelTableMap::getInstanceFromPool(serialize([(null === $key[0] || is_scalar($key[0]) || is_callable([$key[0], '__toString']) ? (string) $key[0] : $key[0]), (null === $key[1] || is_scalar($key[1]) || is_callable([$key[1], '__toString']) ? (string) $key[1] : $key[1])]))))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildSizeGridCategoryRel A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `category_id`, `size_grid_id` FROM `shop_size_grid_category_rel` WHERE `category_id` = :p0 AND `size_grid_id` = :p1';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildSizeGridCategoryRel $obj */
            $obj = new ChildSizeGridCategoryRel();
            $obj->hydrate($row);
            SizeGridCategoryRelTableMap::addInstanceToPool($obj, serialize([(null === $key[0] || is_scalar($key[0]) || is_callable([$key[0], '__toString']) ? (string) $key[0] : $key[0]), (null === $key[1] || is_scalar($key[1]) || is_callable([$key[1], '__toString']) ? (string) $key[1] : $key[1])]));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildSizeGridCategoryRel|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildSizeGridCategoryRelQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(SizeGridCategoryRelTableMap::COL_CATEGORY_ID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(SizeGridCategoryRelTableMap::COL_SIZE_GRID_ID, $key[1], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildSizeGridCategoryRelQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(SizeGridCategoryRelTableMap::COL_CATEGORY_ID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(SizeGridCategoryRelTableMap::COL_SIZE_GRID_ID, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the category_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCategoryId(1234); // WHERE category_id = 1234
     * $query->filterByCategoryId(array(12, 34)); // WHERE category_id IN (12, 34)
     * $query->filterByCategoryId(array('min' => 12)); // WHERE category_id > 12
     * </code>
     *
     * @see       filterByCategory()
     *
     * @param     mixed $categoryId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSizeGridCategoryRelQuery The current query, for fluid interface
     */
    public function filterByCategoryId($categoryId = null, $comparison = null)
    {
        if (is_array($categoryId)) {
            $useMinMax = false;
            if (isset($categoryId['min'])) {
                $this->addUsingAlias(SizeGridCategoryRelTableMap::COL_CATEGORY_ID, $categoryId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($categoryId['max'])) {
                $this->addUsingAlias(SizeGridCategoryRelTableMap::COL_CATEGORY_ID, $categoryId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SizeGridCategoryRelTableMap::COL_CATEGORY_ID, $categoryId, $comparison);
    }

    /**
     * Filter the query on the size_grid_id column
     *
     * Example usage:
     * <code>
     * $query->filterBySizeGridId(1234); // WHERE size_grid_id = 1234
     * $query->filterBySizeGridId(array(12, 34)); // WHERE size_grid_id IN (12, 34)
     * $query->filterBySizeGridId(array('min' => 12)); // WHERE size_grid_id > 12
     * </code>
     *
     * @see       filterBySizeGrid()
     *
     * @param     mixed $sizeGridId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSizeGridCategoryRelQuery The current query, for fluid interface
     */
    public function filterBySizeGridId($sizeGridId = null, $comparison = null)
    {
        if (is_array($sizeGridId)) {
            $useMinMax = false;
            if (isset($sizeGridId['min'])) {
                $this->addUsingAlias(SizeGridCategoryRelTableMap::COL_SIZE_GRID_ID, $sizeGridId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($sizeGridId['max'])) {
                $this->addUsingAlias(SizeGridCategoryRelTableMap::COL_SIZE_GRID_ID, $sizeGridId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SizeGridCategoryRelTableMap::COL_SIZE_GRID_ID, $sizeGridId, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Category\Category object
     *
     * @param \Shop\Infrastructure\Models\Category\Category|ObjectCollection $category The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildSizeGridCategoryRelQuery The current query, for fluid interface
     */
    public function filterByCategory($category, $comparison = null)
    {
        if ($category instanceof \Shop\Infrastructure\Models\Category\Category) {
            return $this
                ->addUsingAlias(SizeGridCategoryRelTableMap::COL_CATEGORY_ID, $category->getId(), $comparison);
        } elseif ($category instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(SizeGridCategoryRelTableMap::COL_CATEGORY_ID, $category->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByCategory() only accepts arguments of type \Shop\Infrastructure\Models\Category\Category or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Category relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildSizeGridCategoryRelQuery The current query, for fluid interface
     */
    public function joinCategory($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Category');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Category');
        }

        return $this;
    }

    /**
     * Use the Category relation Category object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Category\CategoryQuery A secondary query class using the current class as primary query
     */
    public function useCategoryQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinCategory($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Category', '\Shop\Infrastructure\Models\Category\CategoryQuery');
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\SizeGrid\SizeGrid object
     *
     * @param \Shop\Infrastructure\Models\SizeGrid\SizeGrid|ObjectCollection $sizeGrid The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildSizeGridCategoryRelQuery The current query, for fluid interface
     */
    public function filterBySizeGrid($sizeGrid, $comparison = null)
    {
        if ($sizeGrid instanceof \Shop\Infrastructure\Models\SizeGrid\SizeGrid) {
            return $this
                ->addUsingAlias(SizeGridCategoryRelTableMap::COL_SIZE_GRID_ID, $sizeGrid->getId(), $comparison);
        } elseif ($sizeGrid instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(SizeGridCategoryRelTableMap::COL_SIZE_GRID_ID, $sizeGrid->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterBySizeGrid() only accepts arguments of type \Shop\Infrastructure\Models\SizeGrid\SizeGrid or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the SizeGrid relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildSizeGridCategoryRelQuery The current query, for fluid interface
     */
    public function joinSizeGrid($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('SizeGrid');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'SizeGrid');
        }

        return $this;
    }

    /**
     * Use the SizeGrid relation SizeGrid object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\SizeGrid\SizeGridQuery A secondary query class using the current class as primary query
     */
    public function useSizeGridQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinSizeGrid($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'SizeGrid', '\Shop\Infrastructure\Models\SizeGrid\SizeGridQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildSizeGridCategoryRel $sizeGridCategoryRel Object to remove from the list of results
     *
     * @return $this|ChildSizeGridCategoryRelQuery The current query, for fluid interface
     */
    public function prune($sizeGridCategoryRel = null)
    {
        if ($sizeGridCategoryRel) {
            $this->addCond('pruneCond0', $this->getAliasedColName(SizeGridCategoryRelTableMap::COL_CATEGORY_ID), $sizeGridCategoryRel->getCategoryId(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(SizeGridCategoryRelTableMap::COL_SIZE_GRID_ID), $sizeGridCategoryRel->getSizeGridId(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_size_grid_category_rel table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(SizeGridCategoryRelTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            SizeGridCategoryRelTableMap::clearInstancePool();
            SizeGridCategoryRelTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(SizeGridCategoryRelTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(SizeGridCategoryRelTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            SizeGridCategoryRelTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            SizeGridCategoryRelTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // SizeGridCategoryRelQuery
