<?php

namespace Shop\Infrastructure\Models\SizeGrid\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Infrastructure\Models\SizeGrid\SizeGrid as ChildSizeGrid;
use Shop\Infrastructure\Models\SizeGrid\SizeGridQuery as ChildSizeGridQuery;
use Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRel;
use Shop\Infrastructure\Models\SizeGrid\Map\SizeGridTableMap;

/**
 * Base class that represents a query for the 'shop_size_grids' table.
 *
 *
 *
 * @method     ChildSizeGridQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildSizeGridQuery orderByTitle($order = Criteria::ASC) Order by the title column
 * @method     ChildSizeGridQuery orderByContent($order = Criteria::ASC) Order by the content column
 *
 * @method     ChildSizeGridQuery groupById() Group by the id column
 * @method     ChildSizeGridQuery groupByTitle() Group by the title column
 * @method     ChildSizeGridQuery groupByContent() Group by the content column
 *
 * @method     ChildSizeGridQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildSizeGridQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildSizeGridQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildSizeGridQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildSizeGridQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildSizeGridQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildSizeGridQuery leftJoinSizeGridCategoryRel($relationAlias = null) Adds a LEFT JOIN clause to the query using the SizeGridCategoryRel relation
 * @method     ChildSizeGridQuery rightJoinSizeGridCategoryRel($relationAlias = null) Adds a RIGHT JOIN clause to the query using the SizeGridCategoryRel relation
 * @method     ChildSizeGridQuery innerJoinSizeGridCategoryRel($relationAlias = null) Adds a INNER JOIN clause to the query using the SizeGridCategoryRel relation
 *
 * @method     ChildSizeGridQuery joinWithSizeGridCategoryRel($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the SizeGridCategoryRel relation
 *
 * @method     ChildSizeGridQuery leftJoinWithSizeGridCategoryRel() Adds a LEFT JOIN clause and with to the query using the SizeGridCategoryRel relation
 * @method     ChildSizeGridQuery rightJoinWithSizeGridCategoryRel() Adds a RIGHT JOIN clause and with to the query using the SizeGridCategoryRel relation
 * @method     ChildSizeGridQuery innerJoinWithSizeGridCategoryRel() Adds a INNER JOIN clause and with to the query using the SizeGridCategoryRel relation
 *
 * @method     \Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRelQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildSizeGrid findOne(ConnectionInterface $con = null) Return the first ChildSizeGrid matching the query
 * @method     ChildSizeGrid findOneOrCreate(ConnectionInterface $con = null) Return the first ChildSizeGrid matching the query, or a new ChildSizeGrid object populated from the query conditions when no match is found
 *
 * @method     ChildSizeGrid findOneById(int $id) Return the first ChildSizeGrid filtered by the id column
 * @method     ChildSizeGrid findOneByTitle(string $title) Return the first ChildSizeGrid filtered by the title column
 * @method     ChildSizeGrid findOneByContent(string $content) Return the first ChildSizeGrid filtered by the content column *

 * @method     ChildSizeGrid requirePk($key, ConnectionInterface $con = null) Return the ChildSizeGrid by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSizeGrid requireOne(ConnectionInterface $con = null) Return the first ChildSizeGrid matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildSizeGrid requireOneById(int $id) Return the first ChildSizeGrid filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSizeGrid requireOneByTitle(string $title) Return the first ChildSizeGrid filtered by the title column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSizeGrid requireOneByContent(string $content) Return the first ChildSizeGrid filtered by the content column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildSizeGrid[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildSizeGrid objects based on current ModelCriteria
 * @method     ChildSizeGrid[]|ObjectCollection findById(int $id) Return ChildSizeGrid objects filtered by the id column
 * @method     ChildSizeGrid[]|ObjectCollection findByTitle(string $title) Return ChildSizeGrid objects filtered by the title column
 * @method     ChildSizeGrid[]|ObjectCollection findByContent(string $content) Return ChildSizeGrid objects filtered by the content column
 * @method     ChildSizeGrid[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class SizeGridQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Infrastructure\Models\SizeGrid\Base\SizeGridQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\SizeGrid\\SizeGrid', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildSizeGridQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildSizeGridQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildSizeGridQuery) {
            return $criteria;
        }
        $query = new ChildSizeGridQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildSizeGrid|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(SizeGridTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = SizeGridTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildSizeGrid A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `title`, `content` FROM `shop_size_grids` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildSizeGrid $obj */
            $obj = new ChildSizeGrid();
            $obj->hydrate($row);
            SizeGridTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildSizeGrid|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildSizeGridQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(SizeGridTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildSizeGridQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(SizeGridTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSizeGridQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(SizeGridTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(SizeGridTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SizeGridTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the title column
     *
     * Example usage:
     * <code>
     * $query->filterByTitle('fooValue');   // WHERE title = 'fooValue'
     * $query->filterByTitle('%fooValue%', Criteria::LIKE); // WHERE title LIKE '%fooValue%'
     * </code>
     *
     * @param     string $title The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSizeGridQuery The current query, for fluid interface
     */
    public function filterByTitle($title = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($title)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SizeGridTableMap::COL_TITLE, $title, $comparison);
    }

    /**
     * Filter the query on the content column
     *
     * Example usage:
     * <code>
     * $query->filterByContent('fooValue');   // WHERE content = 'fooValue'
     * $query->filterByContent('%fooValue%', Criteria::LIKE); // WHERE content LIKE '%fooValue%'
     * </code>
     *
     * @param     string $content The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSizeGridQuery The current query, for fluid interface
     */
    public function filterByContent($content = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($content)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SizeGridTableMap::COL_CONTENT, $content, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRel object
     *
     * @param \Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRel|ObjectCollection $sizeGridCategoryRel the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildSizeGridQuery The current query, for fluid interface
     */
    public function filterBySizeGridCategoryRel($sizeGridCategoryRel, $comparison = null)
    {
        if ($sizeGridCategoryRel instanceof \Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRel) {
            return $this
                ->addUsingAlias(SizeGridTableMap::COL_ID, $sizeGridCategoryRel->getSizeGridId(), $comparison);
        } elseif ($sizeGridCategoryRel instanceof ObjectCollection) {
            return $this
                ->useSizeGridCategoryRelQuery()
                ->filterByPrimaryKeys($sizeGridCategoryRel->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterBySizeGridCategoryRel() only accepts arguments of type \Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRel or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the SizeGridCategoryRel relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildSizeGridQuery The current query, for fluid interface
     */
    public function joinSizeGridCategoryRel($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('SizeGridCategoryRel');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'SizeGridCategoryRel');
        }

        return $this;
    }

    /**
     * Use the SizeGridCategoryRel relation SizeGridCategoryRel object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRelQuery A secondary query class using the current class as primary query
     */
    public function useSizeGridCategoryRelQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinSizeGridCategoryRel($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'SizeGridCategoryRel', '\Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRelQuery');
    }

    /**
     * Filter the query by a related Category object
     * using the shop_size_grid_category_rel table as cross reference
     *
     * @param Category $category the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildSizeGridQuery The current query, for fluid interface
     */
    public function filterByCategory($category, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useSizeGridCategoryRelQuery()
            ->filterByCategory($category, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   ChildSizeGrid $sizeGrid Object to remove from the list of results
     *
     * @return $this|ChildSizeGridQuery The current query, for fluid interface
     */
    public function prune($sizeGrid = null)
    {
        if ($sizeGrid) {
            $this->addUsingAlias(SizeGridTableMap::COL_ID, $sizeGrid->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_size_grids table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(SizeGridTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            SizeGridTableMap::clearInstancePool();
            SizeGridTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(SizeGridTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(SizeGridTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            SizeGridTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            SizeGridTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // SizeGridQuery
