<?php

namespace Shop\Infrastructure\Models\ShopPositionSize\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Infrastructure\Models\Position\Position;
use Shop\Infrastructure\Models\ShopPositionSize\ShopPositionSize as ChildShopPositionSize;
use Shop\Infrastructure\Models\ShopPositionSize\ShopPositionSizeQuery as ChildShopPositionSizeQuery;
use Shop\Infrastructure\Models\ShopPositionSizeType\ShopPositionSizeType;
use Shop\Infrastructure\Models\ShopPositionSize\Map\ShopPositionSizeTableMap;

/**
 * Base class that represents a query for the 'shop_position_sizes' table.
 *
 *
 *
 * @method     ChildShopPositionSizeQuery orderByPositionId($order = Criteria::ASC) Order by the position_id column
 * @method     ChildShopPositionSizeQuery orderBySizeTypeId($order = Criteria::ASC) Order by the size_type_id column
 * @method     ChildShopPositionSizeQuery orderByValue($order = Criteria::ASC) Order by the value column
 *
 * @method     ChildShopPositionSizeQuery groupByPositionId() Group by the position_id column
 * @method     ChildShopPositionSizeQuery groupBySizeTypeId() Group by the size_type_id column
 * @method     ChildShopPositionSizeQuery groupByValue() Group by the value column
 *
 * @method     ChildShopPositionSizeQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildShopPositionSizeQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildShopPositionSizeQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildShopPositionSizeQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildShopPositionSizeQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildShopPositionSizeQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildShopPositionSizeQuery leftJoinPosition($relationAlias = null) Adds a LEFT JOIN clause to the query using the Position relation
 * @method     ChildShopPositionSizeQuery rightJoinPosition($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Position relation
 * @method     ChildShopPositionSizeQuery innerJoinPosition($relationAlias = null) Adds a INNER JOIN clause to the query using the Position relation
 *
 * @method     ChildShopPositionSizeQuery joinWithPosition($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Position relation
 *
 * @method     ChildShopPositionSizeQuery leftJoinWithPosition() Adds a LEFT JOIN clause and with to the query using the Position relation
 * @method     ChildShopPositionSizeQuery rightJoinWithPosition() Adds a RIGHT JOIN clause and with to the query using the Position relation
 * @method     ChildShopPositionSizeQuery innerJoinWithPosition() Adds a INNER JOIN clause and with to the query using the Position relation
 *
 * @method     ChildShopPositionSizeQuery leftJoinShopPositionSizeType($relationAlias = null) Adds a LEFT JOIN clause to the query using the ShopPositionSizeType relation
 * @method     ChildShopPositionSizeQuery rightJoinShopPositionSizeType($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ShopPositionSizeType relation
 * @method     ChildShopPositionSizeQuery innerJoinShopPositionSizeType($relationAlias = null) Adds a INNER JOIN clause to the query using the ShopPositionSizeType relation
 *
 * @method     ChildShopPositionSizeQuery joinWithShopPositionSizeType($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the ShopPositionSizeType relation
 *
 * @method     ChildShopPositionSizeQuery leftJoinWithShopPositionSizeType() Adds a LEFT JOIN clause and with to the query using the ShopPositionSizeType relation
 * @method     ChildShopPositionSizeQuery rightJoinWithShopPositionSizeType() Adds a RIGHT JOIN clause and with to the query using the ShopPositionSizeType relation
 * @method     ChildShopPositionSizeQuery innerJoinWithShopPositionSizeType() Adds a INNER JOIN clause and with to the query using the ShopPositionSizeType relation
 *
 * @method     \Shop\Infrastructure\Models\Position\PositionQuery|\Shop\Infrastructure\Models\ShopPositionSizeType\ShopPositionSizeTypeQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildShopPositionSize findOne(ConnectionInterface $con = null) Return the first ChildShopPositionSize matching the query
 * @method     ChildShopPositionSize findOneOrCreate(ConnectionInterface $con = null) Return the first ChildShopPositionSize matching the query, or a new ChildShopPositionSize object populated from the query conditions when no match is found
 *
 * @method     ChildShopPositionSize findOneByPositionId(int $position_id) Return the first ChildShopPositionSize filtered by the position_id column
 * @method     ChildShopPositionSize findOneBySizeTypeId(int $size_type_id) Return the first ChildShopPositionSize filtered by the size_type_id column
 * @method     ChildShopPositionSize findOneByValue(string $value) Return the first ChildShopPositionSize filtered by the value column *

 * @method     ChildShopPositionSize requirePk($key, ConnectionInterface $con = null) Return the ChildShopPositionSize by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopPositionSize requireOne(ConnectionInterface $con = null) Return the first ChildShopPositionSize matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildShopPositionSize requireOneByPositionId(int $position_id) Return the first ChildShopPositionSize filtered by the position_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopPositionSize requireOneBySizeTypeId(int $size_type_id) Return the first ChildShopPositionSize filtered by the size_type_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopPositionSize requireOneByValue(string $value) Return the first ChildShopPositionSize filtered by the value column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildShopPositionSize[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildShopPositionSize objects based on current ModelCriteria
 * @method     ChildShopPositionSize[]|ObjectCollection findByPositionId(int $position_id) Return ChildShopPositionSize objects filtered by the position_id column
 * @method     ChildShopPositionSize[]|ObjectCollection findBySizeTypeId(int $size_type_id) Return ChildShopPositionSize objects filtered by the size_type_id column
 * @method     ChildShopPositionSize[]|ObjectCollection findByValue(string $value) Return ChildShopPositionSize objects filtered by the value column
 * @method     ChildShopPositionSize[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class ShopPositionSizeQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Infrastructure\Models\ShopPositionSize\Base\ShopPositionSizeQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\ShopPositionSize\\ShopPositionSize', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildShopPositionSizeQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildShopPositionSizeQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildShopPositionSizeQuery) {
            return $criteria;
        }
        $query = new ChildShopPositionSizeQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34, 56), $con);
     * </code>
     *
     * @param array[$position_id, $size_type_id, $value] $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildShopPositionSize|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(ShopPositionSizeTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = ShopPositionSizeTableMap::getInstanceFromPool(serialize([(null === $key[0] || is_scalar($key[0]) || is_callable([$key[0], '__toString']) ? (string) $key[0] : $key[0]), (null === $key[1] || is_scalar($key[1]) || is_callable([$key[1], '__toString']) ? (string) $key[1] : $key[1]), (null === $key[2] || is_scalar($key[2]) || is_callable([$key[2], '__toString']) ? (string) $key[2] : $key[2])]))))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildShopPositionSize A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `position_id`, `size_type_id`, `value` FROM `shop_position_sizes` WHERE `position_id` = :p0 AND `size_type_id` = :p1 AND `value` = :p2';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->bindValue(':p2', $key[2], PDO::PARAM_STR);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildShopPositionSize $obj */
            $obj = new ChildShopPositionSize();
            $obj->hydrate($row);
            ShopPositionSizeTableMap::addInstanceToPool($obj, serialize([(null === $key[0] || is_scalar($key[0]) || is_callable([$key[0], '__toString']) ? (string) $key[0] : $key[0]), (null === $key[1] || is_scalar($key[1]) || is_callable([$key[1], '__toString']) ? (string) $key[1] : $key[1]), (null === $key[2] || is_scalar($key[2]) || is_callable([$key[2], '__toString']) ? (string) $key[2] : $key[2])]));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildShopPositionSize|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildShopPositionSizeQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(ShopPositionSizeTableMap::COL_POSITION_ID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(ShopPositionSizeTableMap::COL_SIZE_TYPE_ID, $key[1], Criteria::EQUAL);
        $this->addUsingAlias(ShopPositionSizeTableMap::COL_VALUE, $key[2], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildShopPositionSizeQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(ShopPositionSizeTableMap::COL_POSITION_ID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(ShopPositionSizeTableMap::COL_SIZE_TYPE_ID, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $cton2 = $this->getNewCriterion(ShopPositionSizeTableMap::COL_VALUE, $key[2], Criteria::EQUAL);
            $cton0->addAnd($cton2);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the position_id column
     *
     * Example usage:
     * <code>
     * $query->filterByPositionId(1234); // WHERE position_id = 1234
     * $query->filterByPositionId(array(12, 34)); // WHERE position_id IN (12, 34)
     * $query->filterByPositionId(array('min' => 12)); // WHERE position_id > 12
     * </code>
     *
     * @see       filterByPosition()
     *
     * @param     mixed $positionId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopPositionSizeQuery The current query, for fluid interface
     */
    public function filterByPositionId($positionId = null, $comparison = null)
    {
        if (is_array($positionId)) {
            $useMinMax = false;
            if (isset($positionId['min'])) {
                $this->addUsingAlias(ShopPositionSizeTableMap::COL_POSITION_ID, $positionId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($positionId['max'])) {
                $this->addUsingAlias(ShopPositionSizeTableMap::COL_POSITION_ID, $positionId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopPositionSizeTableMap::COL_POSITION_ID, $positionId, $comparison);
    }

    /**
     * Filter the query on the size_type_id column
     *
     * Example usage:
     * <code>
     * $query->filterBySizeTypeId(1234); // WHERE size_type_id = 1234
     * $query->filterBySizeTypeId(array(12, 34)); // WHERE size_type_id IN (12, 34)
     * $query->filterBySizeTypeId(array('min' => 12)); // WHERE size_type_id > 12
     * </code>
     *
     * @see       filterByShopPositionSizeType()
     *
     * @param     mixed $sizeTypeId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopPositionSizeQuery The current query, for fluid interface
     */
    public function filterBySizeTypeId($sizeTypeId = null, $comparison = null)
    {
        if (is_array($sizeTypeId)) {
            $useMinMax = false;
            if (isset($sizeTypeId['min'])) {
                $this->addUsingAlias(ShopPositionSizeTableMap::COL_SIZE_TYPE_ID, $sizeTypeId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($sizeTypeId['max'])) {
                $this->addUsingAlias(ShopPositionSizeTableMap::COL_SIZE_TYPE_ID, $sizeTypeId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopPositionSizeTableMap::COL_SIZE_TYPE_ID, $sizeTypeId, $comparison);
    }

    /**
     * Filter the query on the value column
     *
     * Example usage:
     * <code>
     * $query->filterByValue('fooValue');   // WHERE value = 'fooValue'
     * $query->filterByValue('%fooValue%', Criteria::LIKE); // WHERE value LIKE '%fooValue%'
     * </code>
     *
     * @param     string $value The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopPositionSizeQuery The current query, for fluid interface
     */
    public function filterByValue($value = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($value)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopPositionSizeTableMap::COL_VALUE, $value, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Position\Position object
     *
     * @param \Shop\Infrastructure\Models\Position\Position|ObjectCollection $position The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildShopPositionSizeQuery The current query, for fluid interface
     */
    public function filterByPosition($position, $comparison = null)
    {
        if ($position instanceof \Shop\Infrastructure\Models\Position\Position) {
            return $this
                ->addUsingAlias(ShopPositionSizeTableMap::COL_POSITION_ID, $position->getId(), $comparison);
        } elseif ($position instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ShopPositionSizeTableMap::COL_POSITION_ID, $position->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByPosition() only accepts arguments of type \Shop\Infrastructure\Models\Position\Position or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Position relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildShopPositionSizeQuery The current query, for fluid interface
     */
    public function joinPosition($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Position');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Position');
        }

        return $this;
    }

    /**
     * Use the Position relation Position object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Position\PositionQuery A secondary query class using the current class as primary query
     */
    public function usePositionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinPosition($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Position', '\Shop\Infrastructure\Models\Position\PositionQuery');
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\ShopPositionSizeType\ShopPositionSizeType object
     *
     * @param \Shop\Infrastructure\Models\ShopPositionSizeType\ShopPositionSizeType|ObjectCollection $shopPositionSizeType The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildShopPositionSizeQuery The current query, for fluid interface
     */
    public function filterByShopPositionSizeType($shopPositionSizeType, $comparison = null)
    {
        if ($shopPositionSizeType instanceof \Shop\Infrastructure\Models\ShopPositionSizeType\ShopPositionSizeType) {
            return $this
                ->addUsingAlias(ShopPositionSizeTableMap::COL_SIZE_TYPE_ID, $shopPositionSizeType->getId(), $comparison);
        } elseif ($shopPositionSizeType instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ShopPositionSizeTableMap::COL_SIZE_TYPE_ID, $shopPositionSizeType->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByShopPositionSizeType() only accepts arguments of type \Shop\Infrastructure\Models\ShopPositionSizeType\ShopPositionSizeType or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ShopPositionSizeType relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildShopPositionSizeQuery The current query, for fluid interface
     */
    public function joinShopPositionSizeType($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ShopPositionSizeType');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ShopPositionSizeType');
        }

        return $this;
    }

    /**
     * Use the ShopPositionSizeType relation ShopPositionSizeType object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\ShopPositionSizeType\ShopPositionSizeTypeQuery A secondary query class using the current class as primary query
     */
    public function useShopPositionSizeTypeQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinShopPositionSizeType($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ShopPositionSizeType', '\Shop\Infrastructure\Models\ShopPositionSizeType\ShopPositionSizeTypeQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildShopPositionSize $shopPositionSize Object to remove from the list of results
     *
     * @return $this|ChildShopPositionSizeQuery The current query, for fluid interface
     */
    public function prune($shopPositionSize = null)
    {
        if ($shopPositionSize) {
            $this->addCond('pruneCond0', $this->getAliasedColName(ShopPositionSizeTableMap::COL_POSITION_ID), $shopPositionSize->getPositionId(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(ShopPositionSizeTableMap::COL_SIZE_TYPE_ID), $shopPositionSize->getSizeTypeId(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond2', $this->getAliasedColName(ShopPositionSizeTableMap::COL_VALUE), $shopPositionSize->getValue(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1', 'pruneCond2'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_position_sizes table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopPositionSizeTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ShopPositionSizeTableMap::clearInstancePool();
            ShopPositionSizeTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopPositionSizeTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(ShopPositionSizeTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            ShopPositionSizeTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            ShopPositionSizeTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // ShopPositionSizeQuery
