<?php

namespace Shop\Infrastructure\Models\ProviderOrderItem\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Infrastructure\Models\OrderItem\OrderItem;
use Shop\Infrastructure\Models\ProviderOrderItem\ProviderOrderItem as ChildProviderOrderItem;
use Shop\Infrastructure\Models\ProviderOrderItem\ProviderOrderItemQuery as ChildProviderOrderItemQuery;
use Shop\Infrastructure\Models\ProviderOrderItem\Map\ProviderOrderItemTableMap;

/**
 * Base class that represents a query for the 'shop_provider_order_item_rel' table.
 *
 *
 *
 * @method     ChildProviderOrderItemQuery orderByProviderOrderItemId($order = Criteria::ASC) Order by the provider_order_item_id column
 *
 * @method     ChildProviderOrderItemQuery groupByProviderOrderItemId() Group by the provider_order_item_id column
 *
 * @method     ChildProviderOrderItemQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildProviderOrderItemQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildProviderOrderItemQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildProviderOrderItemQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildProviderOrderItemQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildProviderOrderItemQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildProviderOrderItemQuery leftJoinOrderItem($relationAlias = null) Adds a LEFT JOIN clause to the query using the OrderItem relation
 * @method     ChildProviderOrderItemQuery rightJoinOrderItem($relationAlias = null) Adds a RIGHT JOIN clause to the query using the OrderItem relation
 * @method     ChildProviderOrderItemQuery innerJoinOrderItem($relationAlias = null) Adds a INNER JOIN clause to the query using the OrderItem relation
 *
 * @method     ChildProviderOrderItemQuery joinWithOrderItem($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the OrderItem relation
 *
 * @method     ChildProviderOrderItemQuery leftJoinWithOrderItem() Adds a LEFT JOIN clause and with to the query using the OrderItem relation
 * @method     ChildProviderOrderItemQuery rightJoinWithOrderItem() Adds a RIGHT JOIN clause and with to the query using the OrderItem relation
 * @method     ChildProviderOrderItemQuery innerJoinWithOrderItem() Adds a INNER JOIN clause and with to the query using the OrderItem relation
 *
 * @method     \Shop\Infrastructure\Models\OrderItem\OrderItemQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildProviderOrderItem findOne(ConnectionInterface $con = null) Return the first ChildProviderOrderItem matching the query
 * @method     ChildProviderOrderItem findOneOrCreate(ConnectionInterface $con = null) Return the first ChildProviderOrderItem matching the query, or a new ChildProviderOrderItem object populated from the query conditions when no match is found
 *
 * @method     ChildProviderOrderItem findOneByProviderOrderItemId(int $provider_order_item_id) Return the first ChildProviderOrderItem filtered by the provider_order_item_id column *

 * @method     ChildProviderOrderItem requirePk($key, ConnectionInterface $con = null) Return the ChildProviderOrderItem by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProviderOrderItem requireOne(ConnectionInterface $con = null) Return the first ChildProviderOrderItem matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildProviderOrderItem requireOneByProviderOrderItemId(int $provider_order_item_id) Return the first ChildProviderOrderItem filtered by the provider_order_item_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildProviderOrderItem[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildProviderOrderItem objects based on current ModelCriteria
 * @method     ChildProviderOrderItem[]|ObjectCollection findByProviderOrderItemId(int $provider_order_item_id) Return ChildProviderOrderItem objects filtered by the provider_order_item_id column
 * @method     ChildProviderOrderItem[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class ProviderOrderItemQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Infrastructure\Models\ProviderOrderItem\Base\ProviderOrderItemQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\ProviderOrderItem\\ProviderOrderItem', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildProviderOrderItemQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildProviderOrderItemQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildProviderOrderItemQuery) {
            return $criteria;
        }
        $query = new ChildProviderOrderItemQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildProviderOrderItem|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(ProviderOrderItemTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = ProviderOrderItemTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildProviderOrderItem A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `provider_order_item_id` FROM `shop_provider_order_item_rel` WHERE `provider_order_item_id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildProviderOrderItem $obj */
            $obj = new ChildProviderOrderItem();
            $obj->hydrate($row);
            ProviderOrderItemTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildProviderOrderItem|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildProviderOrderItemQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ProviderOrderItemTableMap::COL_PROVIDER_ORDER_ITEM_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildProviderOrderItemQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ProviderOrderItemTableMap::COL_PROVIDER_ORDER_ITEM_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the provider_order_item_id column
     *
     * Example usage:
     * <code>
     * $query->filterByProviderOrderItemId(1234); // WHERE provider_order_item_id = 1234
     * $query->filterByProviderOrderItemId(array(12, 34)); // WHERE provider_order_item_id IN (12, 34)
     * $query->filterByProviderOrderItemId(array('min' => 12)); // WHERE provider_order_item_id > 12
     * </code>
     *
     * @see       filterByOrderItem()
     *
     * @param     mixed $providerOrderItemId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProviderOrderItemQuery The current query, for fluid interface
     */
    public function filterByProviderOrderItemId($providerOrderItemId = null, $comparison = null)
    {
        if (is_array($providerOrderItemId)) {
            $useMinMax = false;
            if (isset($providerOrderItemId['min'])) {
                $this->addUsingAlias(ProviderOrderItemTableMap::COL_PROVIDER_ORDER_ITEM_ID, $providerOrderItemId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($providerOrderItemId['max'])) {
                $this->addUsingAlias(ProviderOrderItemTableMap::COL_PROVIDER_ORDER_ITEM_ID, $providerOrderItemId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProviderOrderItemTableMap::COL_PROVIDER_ORDER_ITEM_ID, $providerOrderItemId, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\OrderItem\OrderItem object
     *
     * @param \Shop\Infrastructure\Models\OrderItem\OrderItem|ObjectCollection $orderItem The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildProviderOrderItemQuery The current query, for fluid interface
     */
    public function filterByOrderItem($orderItem, $comparison = null)
    {
        if ($orderItem instanceof \Shop\Infrastructure\Models\OrderItem\OrderItem) {
            return $this
                ->addUsingAlias(ProviderOrderItemTableMap::COL_PROVIDER_ORDER_ITEM_ID, $orderItem->getId(), $comparison);
        } elseif ($orderItem instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProviderOrderItemTableMap::COL_PROVIDER_ORDER_ITEM_ID, $orderItem->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByOrderItem() only accepts arguments of type \Shop\Infrastructure\Models\OrderItem\OrderItem or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the OrderItem relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildProviderOrderItemQuery The current query, for fluid interface
     */
    public function joinOrderItem($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('OrderItem');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'OrderItem');
        }

        return $this;
    }

    /**
     * Use the OrderItem relation OrderItem object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\OrderItem\OrderItemQuery A secondary query class using the current class as primary query
     */
    public function useOrderItemQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinOrderItem($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'OrderItem', '\Shop\Infrastructure\Models\OrderItem\OrderItemQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildProviderOrderItem $providerOrderItem Object to remove from the list of results
     *
     * @return $this|ChildProviderOrderItemQuery The current query, for fluid interface
     */
    public function prune($providerOrderItem = null)
    {
        if ($providerOrderItem) {
            $this->addUsingAlias(ProviderOrderItemTableMap::COL_PROVIDER_ORDER_ITEM_ID, $providerOrderItem->getProviderOrderItemId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_provider_order_item_rel table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProviderOrderItemTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ProviderOrderItemTableMap::clearInstancePool();
            ProviderOrderItemTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProviderOrderItemTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(ProviderOrderItemTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            ProviderOrderItemTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            ProviderOrderItemTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // ProviderOrderItemQuery
