<?php declare(strict_types=1);

namespace Shop\Application\Auth;

use Core\Concrete\UserAuthAwareTrait;
use Core\Contracts\UserAuthAwareInterface;
use Core\Contracts\UserInterface;
use Core\Exceptions\ForbiddenAccessException;
use Diamond\Application\User\Exceptions\UserNotAuthException;

class AdminAuthService implements UserAuthAwareInterface
{

    use UserAuthAwareTrait;

    public function getCurrentUser(): UserInterface
    {
        try {
            return $this->userAuth->getAuthUser();
        }
        catch (UserNotAuthException $ex){
            throw new ForbiddenAccessException('доступ запрещен');
        }
    }
}