<?php

namespace Shop\Infrastructure\Models\Brand\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Infrastructure\Models\Brand\Brand;
use Shop\Infrastructure\Models\Brand\BrandQuery;


/**
 * This class defines the structure of the 'shop_brands' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class BrandTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Shop.Infrastructure.Models.Brand.Map.BrandTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = 'shop_brands';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Shop\\Infrastructure\\Models\\Brand\\Brand';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Shop.Infrastructure.Models.Brand.Brand';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 4;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 4;

    /**
     * the column name for the id field
     */
    public const COL_ID = 'shop_brands.id';

    /**
     * the column name for the name field
     */
    public const COL_NAME = 'shop_brands.name';

    /**
     * the column name for the alias field
     */
    public const COL_ALIAS = 'shop_brands.alias';

    /**
     * the column name for the desc field
     */
    public const COL_DESC = 'shop_brands.desc';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'Name', 'Alias', 'Desc', ],
        self::TYPE_CAMELNAME     => ['id', 'name', 'alias', 'desc', ],
        self::TYPE_COLNAME       => [BrandTableMap::COL_ID, BrandTableMap::COL_NAME, BrandTableMap::COL_ALIAS, BrandTableMap::COL_DESC, ],
        self::TYPE_FIELDNAME     => ['id', 'name', 'alias', 'desc', ],
        self::TYPE_NUM           => [0, 1, 2, 3, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'Name' => 1, 'Alias' => 2, 'Desc' => 3, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'name' => 1, 'alias' => 2, 'desc' => 3, ],
        self::TYPE_COLNAME       => [BrandTableMap::COL_ID => 0, BrandTableMap::COL_NAME => 1, BrandTableMap::COL_ALIAS => 2, BrandTableMap::COL_DESC => 3, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'name' => 1, 'alias' => 2, 'desc' => 3, ],
        self::TYPE_NUM           => [0, 1, 2, 3, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'Brand.Id' => 'ID',
        'id' => 'ID',
        'brand.id' => 'ID',
        'BrandTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        'shop_brands.id' => 'ID',
        'Name' => 'NAME',
        'Brand.Name' => 'NAME',
        'name' => 'NAME',
        'brand.name' => 'NAME',
        'BrandTableMap::COL_NAME' => 'NAME',
        'COL_NAME' => 'NAME',
        'shop_brands.name' => 'NAME',
        'Alias' => 'ALIAS',
        'Brand.Alias' => 'ALIAS',
        'alias' => 'ALIAS',
        'brand.alias' => 'ALIAS',
        'BrandTableMap::COL_ALIAS' => 'ALIAS',
        'COL_ALIAS' => 'ALIAS',
        'shop_brands.alias' => 'ALIAS',
        'Desc' => 'DESC',
        'Brand.Desc' => 'DESC',
        'desc' => 'DESC',
        'brand.desc' => 'DESC',
        'BrandTableMap::COL_DESC' => 'DESC',
        'COL_DESC' => 'DESC',
        'shop_brands.desc' => 'DESC',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('shop_brands');
        $this->setPhpName('Brand');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Infrastructure\\Models\\Brand\\Brand');
        $this->setPackage('Shop.Infrastructure.Models.Brand');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('name', 'Name', 'VARCHAR', false, 255, null);
        $this->addColumn('alias', 'Alias', 'VARCHAR', false, 100, null);
        $this->addColumn('desc', 'Desc', 'LONGVARCHAR', false, null, null);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
        $this->addRelation('Product', '\\Shop\\Infrastructure\\Models\\Product\\Product', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':brand_id',
    1 => ':id',
  ),
), null, null, 'Products', false);
        $this->addRelation('DiscountRule', '\\Shop\\Infrastructure\\Models\\DiscountRule\\DiscountRule', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':brand_id',
    1 => ':id',
  ),
), null, null, 'DiscountRules', false);
        $this->addRelation('ImageDefault', '\\Shop\\Infrastructure\\Models\\ImageDefault\\ImageDefault', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':brand_id',
    1 => ':id',
  ),
), null, null, 'ImageDefaults', false);
        $this->addRelation('DraftProduct', '\\Shop\\Infrastructure\\Models\\DraftProduct\\DraftProduct', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':brand_id',
    1 => ':id',
  ),
), null, null, 'DraftProducts', false);
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? BrandTableMap::CLASS_DEFAULT : BrandTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (Brand object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = BrandTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = BrandTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + BrandTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = BrandTableMap::OM_CLASS;
            /** @var Brand $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            BrandTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = BrandTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = BrandTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var Brand $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                BrandTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(BrandTableMap::COL_ID);
            $criteria->addSelectColumn(BrandTableMap::COL_NAME);
            $criteria->addSelectColumn(BrandTableMap::COL_ALIAS);
            $criteria->addSelectColumn(BrandTableMap::COL_DESC);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.name');
            $criteria->addSelectColumn($alias . '.alias');
            $criteria->addSelectColumn($alias . '.desc');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(BrandTableMap::COL_ID);
            $criteria->removeSelectColumn(BrandTableMap::COL_NAME);
            $criteria->removeSelectColumn(BrandTableMap::COL_ALIAS);
            $criteria->removeSelectColumn(BrandTableMap::COL_DESC);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.name');
            $criteria->removeSelectColumn($alias . '.alias');
            $criteria->removeSelectColumn($alias . '.desc');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(BrandTableMap::DATABASE_NAME)->getTable(BrandTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a Brand or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or Brand object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(BrandTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Infrastructure\Models\Brand\Brand) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(BrandTableMap::DATABASE_NAME);
            $criteria->add(BrandTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = BrandQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            BrandTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                BrandTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_brands table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return BrandQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a Brand or Criteria object.
     *
     * @param mixed $criteria Criteria or Brand object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(BrandTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from Brand object
        }


        // Set the correct dbName
        $query = BrandQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
