<?php

namespace Shop\Domain\PriceList\Contracts;

use Repo\PaginationInterface;
use Repo\RepositoryCriteriaInterface;

/**
 * Description of PriceList
 *
 * @author Diamond Code Generator
 */
interface PriceListCriteriaInterface extends RepositoryCriteriaInterface, PaginationInterface
{
    /**
     * @return int|null
     */
    public function getFilterByProviderId(): ?int;

    public function getSearchByTitle():?string ;

    public function getSortByDateUpdate():?string ;

    public function getSortByTitle(): ?string;

    public function getFilterByPricelistFileId(): ?int;

    public function setFilterByPricelistFileId(?int $filterByPricelistFileId): PriceListCriteriaInterface;

    public function setSortByTitle(?string $sortByTitle): PriceListCriteriaInterface;

    public function setSearchByTitle(?string $searchByTitle): PriceListCriteriaInterface;

    public function setFilterByProviderId(?int $filterByProviderId): PriceListCriteriaInterface;

    public function setSortByDateUpdate(?string $sortByDateUpdate): PriceListCriteriaInterface;
}           