<?php

namespace Shop\Domain\Payment;

use Core\Repository\DropDownInterface;
use Repo\Concrete\AbstractCollection;
use Shop\Domain\Payment\Contracts\PaymentEntityInterface;

/**
 * Description of Payment
 *
 * @author Diamond Code Generator
 */
class PaymentCollection extends AbstractCollection implements DropDownInterface
{

    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return PaymentEntityInterface::class;
    }

    /**
     * @return array
     */
    public function getDropdownList(): array
    {
        $ar = [];
        foreach ($this->_entities as $entity) {
            $ar[$entity->getId()] = $entity->getTitle();
        }

        return $ar;
    }
}               