<?php

namespace Shop\Presentation\Modules\AdminPriceFiles;

use ActiveTable\ColumnTable;
use Core\Form\ControlBuilder;
use Diamond\Helpers\Form;
use DiamondTable\TableFactory;
use Shop\Domain\PriceFile\Contracts\PriceFileEntityInterface;
use Shop\Infrastructure\Models\PricelistSheet\PricelistSheet;
use Shop\Infrastructure\Repositories\PriceFile\PriceFileCriteria;
use Shop\Infrastructure\Repositories\PriceFile\PriceFileRepository;
use Shop\Infrastructure\Repositories\Provider\ProviderCriteria;
use Shop\Infrastructure\Repositories\Provider\ProviderRepository;

/**
 * Description of AdminPriceFiles
 *
 * @author Diamond Code Generator
 */
class AdminPriceFiles extends \Core\ModuleController
{


    protected $priceFileRepository;
    protected $tableFactory;
    protected $controlBuilder;
    protected $providerRepository;

    public function __construct(PriceFileRepository $priceFileRepository, TableFactory $tableFactory,
                                ControlBuilder $controlBuilder, ProviderRepository $providerRepository)
    {
        $this->priceFileRepository = $priceFileRepository;
        $this->tableFactory = $tableFactory;
        $this->controlBuilder = $controlBuilder;
        $this->providerRepository = $providerRepository;
    }

    /**
     * @return string
     * @throws \ReflectionException
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    public function process(): string
    {

        $providers = $this->providerRepository->findByCriteria(
          ProviderCriteria::create()
        );

        $providersAr = Form::prepareDropdown($providers);

        $table = $this->tableFactory->buildAdminTable($this->priceFileRepository, PriceFileCriteria::create());

        $table
            ->setDefaultSortColumn('id', 'DESC')
            ->addColumn(
                (new ColumnTable('id', '№'))->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('name', 'Название прайс-файла'))
            )
            ->addColumn(
                (new ColumnTable('providerId', 'Поставщик'))
                    ->setFormat($this, 'formatProvider')

            )
            ->addColumn(
                (new ColumnTable('pricelists', 'Прайс-листов'))
                    ->setFormat($this, 'formatPricelistCount')

            )
            ->addColumn(
                (new ColumnTable('positions', 'Позиций'))
                    ->setFormat($this, 'formatPositions')

            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setFormat($this->tableFactory, 'formatActions')
                    ->setWidth(120)
            );

        $table
            ->addField(
                $this->controlBuilder->buildInput('name')
            )
            ->addField(
                $this->controlBuilder->buildAutoDropdown('providerId',$providersAr),true
            )
            ;

        $table
            ->addFilter(
                $this->controlBuilder->buildInput('search_by_name')
            );

        return $table->render();
    }

    /**
     * @param PriceFileEntityInterface $priceFile
     * @return string
     */
    public function formatPricelistCount(PriceFileEntityInterface $priceFile): string
    {
        if (!$sheets = $priceFile->getPricelistSheets()) {
            return '';
        }
        return $sheets->count();
    }

    /**
     * @param PriceFileEntityInterface $priceFile
     * @return string
     */
    public function formatPositions(PriceFileEntityInterface $priceFile): string
    {
        /**
         * @var PricelistSheet $sheets
         */
        if (!$sheets = $priceFile->getPricelistSheets()) {
            return '';
        }

        $pos = 0;

        foreach ($sheets as $sheet) {
            if (!$positions = $sheet->getPositions()) {
                continue;
            }
            $pos += $positions->count();
        }

        return $pos;
    }

    /**
     * @param PriceFileEntityInterface $priceFile
     * @return string
     */
    public function formatProvider(PriceFileEntityInterface $priceFile): string
    {
        $name = $priceFile->getProvider()->getName();
        return anchor('/admin/shop/stocks/providers',$name,[],[
            'fn'    => 'edit',
            'id'    => $priceFile->getProvider()->getId()
        ]);
    }

}               