<?php


namespace Shop\Infrastructure\Repositories\Sale;


use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\Sale\SaleCollection;
use Shop\Infrastructure\Models\Sale\Sale;
use Shop\Infrastructure\Models\Sale\SaleQuery;

class SaleRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    public static function createEntity(): EntityInterface
    {
        return new Sale();
    }

    protected function createQuery(): ModelCriteria
    {
        return SaleQuery::create();
    }

    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        
    }
    
    protected function createCollection(): CollectionInterface
    {
        return new SaleCollection();
    }
}