<?php


namespace Shop\Application\Shopping\CreateCustomerOrder;


use Shop\Domain\OrderItem\Contracts\OrderItemEntityInterface;
use Shop\Infrastructure\Repositories\OrderItem\OrderItemRepository;

/**
 * Trait BuildOrderPositionTrait
 * @package Shop\Application\Shopping\CreateCustomerOrder
 */
trait BuildOrderPositionTrait
{
    /**
     * @param \Shop\Application\Shopping\Dto\OrderItemRequest $item
     * @return OrderItemEntityInterface
     */
    protected function buildOrderItem(\Shop\Application\Shopping\Dto\OrderItemRequest $item): OrderItemEntityInterface
    {
        /**
         * @var $item OrderItemRequest
         */
        $orderItem = OrderItemRepository::createEntity()
            ->setAmount($item->getAmount())
            ->setBrand($item->getBrand())
            ->setDesc($item->getDesc())
            ->setMenagerComment($item->getManagerComment())
            ->setName($item->getName())
            ->setArticle($item->getArticle())
            ->setPrice($item->getPrice())
            ->setRefId($item->getRefId())
            ->setProviderId($item->getProviderId())
            ->setDestination($item->getDestination())
            ->setCurrencyId($item->getCurrencyId() ?? $this->mainConf->getDefaultCurrency());

        return $orderItem;
    }
}