<?php

namespace Shop\Infrastructure\Repositories\Catalog;

use Repo\Concrete\AbstractCriteria;
use Shop\Domain\Catalog\Contracts\CatalogCriteriaInterface;

/**
 * Description of ProductCriteria
 *
 * @author Admin
 */
class CatalogCriteria extends AbstractCriteria implements CatalogCriteriaInterface
{

    /**
     * @var string|null
     */
    protected $searchByName;

    /**
     * @var string|null
     */
    protected $searchByAlias;

    /**
     * @var int|null
     */
    protected $filterByDomainId;

    /**
     * @var string|null
     */
    protected $filterByAlias;

    /**
     * @var array|null
     */
    protected $filterByWeights;

    /**
     * @var string|null
     */
    protected $sortByName;

    /**
     * @return array|null
     */
    public function getFilterByWeights(): ?array
    {
        return $this->filterByWeights;
    }

    /**
     * @param array|null $filterByWeights
     * @return CatalogCriteria
     */
    public function setFilterByWeights(?array $filterByWeights): CatalogCriteria
    {
        $this->filterByWeights = $filterByWeights;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSortByName(): ?string
    {
        return $this->sortByName;
    }

    /**
     * @param string|null $sortByName
     * @return CatalogCriteria
     */
    public function setSortByName(?string $sortByName): CatalogCriteria
    {
        $this->sortByName = $sortByName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFilterByAlias(): ?string
    {
        return $this->filterByAlias;
    }

    /**
     * @param string|null $filterByAlias
     * @return CatalogCriteria
     */
    public function setFilterByAlias(?string $filterByAlias): CatalogCriteria
    {
        $this->filterByAlias = $filterByAlias;
        return $this;
    }


    /**
     * @return int|null
     */
    public function getFilterByDomainId(): ?int
    {
        return $this->filterByDomainId;
    }

    /**
     * @param int|null $filterByDomainInt
     * @return CatalogCriteria
     */
    public function setFilterByDomainId(?int $filterByDomainInt): CatalogCriteria
    {
        $this->filterByDomainId = $filterByDomainInt;
        return $this;
    }


    /**
     * @return mixed|CatalogCriteria
     */
    public static function create()
    {
        return new self;
    }




    /**
     * @return string|null
     */
    public function getSearchByName(): ?string
    {
        return $this->searchByName;
    }

    /**
     * @param string|null $searchByName
     * @return BrandCriteria
     */
    public function setSearchByName(?string $searchByName): BrandCriteria
    {
        $this->searchByName = $searchByName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSearchByAlias(): ?string
    {
        return $this->searchByAlias;
    }

    /**
     * @param string|null $searchByAlias
     * @return BrandCriteria
     */
    public function setSearchByAlias(?string $searchByAlias): BrandCriteria
    {
        $this->searchByAlias = $searchByAlias;
        return $this;
    }

}