<?php

namespace Shop\Application\Shopping\CreateCustomerOrder;

use Shop\Domain\Customer\Contracts\CustomerEntityInterface;

/**
 * Class CreateCustomerOrderCommand
 * @package Shop\Presentation\UseCases\Checkout
 */
class CreateCustomerOrderCommand
{

    /**
     * @var OrderRequest
     */
    protected $orderRequest;

    /**
     * @var CustomerEntityInterface
     */
    protected $customer;

    /**
     * @var OrderResult
     */
    protected $orderResult;

    public function __construct(OrderRequest $orderRequest, OrderResult $orderResult)
    {
        $this->orderRequest = $orderRequest;
        $this->orderResult = $orderResult;
    }

    /**
     * @return OrderRequest
     */
    public function getOrderRequest(): OrderRequest
    {
        return $this->orderRequest;
    }

    /**
     * @return CustomerEntityInterface
     */
    public function getCustomer(): CustomerEntityInterface
    {
        return $this->customer;
    }

    /**
     * @return mixed
     */
    public function getOrderResult(): OrderResult
    {
        return $this->orderResult;
    }


}