<?php

namespace Shop\Presentation\Modules\AdminDiscounts;

use ActiveTable\ColumnTable;
use Core\Form\ControlBuilder;
use Core\ModuleController;
use Core\Registry\Column;
use Core\Registry\Field;
use DiamondTable\TableFactory;
use Shop\Presentation\Config\Main;
use Shop\Infrastructure\Repositories\Discount\DiscountCriteria;
use Shop\Infrastructure\Repositories\Discount\DiscountRepository;

/**
 * Description of AdminDiscounts
 *
 * @author Diamond Code Generator
 */
class AdminDiscounts extends ModuleController
{

    protected $tableFactory;
    protected $repo;
    protected $cBuilder;
    protected $confMain;

    public function __construct(TableFactory $tableFactory,
                                DiscountRepository $discountRepo,
                                ControlBuilder $cBuilder,
                                Main $confMain
    )
    {
        $this->tableFactory = $tableFactory;
        $this->repo = $discountRepo;
        $this->cBuilder = $cBuilder;
        $this->confMain = $confMain;
    }

    /**
     * @return string
     * @throws \ReflectionException
     */
    public function process(): string
    {

        $table = $this->tableFactory->buildAdminTable($this->repo, DiscountCriteria::create());
        $cur = $this->confMain->getCurencyDisplay();
        $table
            ->addColumn(new ColumnTable("id", "№"))
            ->addColumn(new ColumnTable("priceFrom", "Сумма от," . $cur))
            ->addColumn(new ColumnTable("priceTo", "Сумма до," . $cur))
            ->addColumn(new ColumnTable("percent", "Скидка,%"))
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setFormat($this->tableFactory, 'formatActions')
                    ->setWidth(120)
            );

        $table
            ->addField(
                $this->cBuilder
                    ->buildInputLittle("priceFrom"), true
            )
            ->addField(
                $this->cBuilder
                    ->buildInputLittle("priceTo"), true, null, "Включительно"
            )
            ->addField(
                $this->cBuilder
                    ->buildInputLittle("percent"), true
            );

        return $table->render();
    }

}               