<?php

namespace Shop\Presentation\Helpers;

use Shop\Domain\CustomerOrder\Contracts\CustomerOrderEntityInterface;
use Shop\Domain\State\Contracts\StateEntityInterface;

/**
 * Функции форматирования колонок таблиц и полей форм
 *
 * @author Admin
 */
class Formatter
{
    /**
     * @param CustomerOrderEntityInterface|null $order
     * @return string
     */
    public static function linkOrderCode(CustomerOrderEntityInterface $order = null):string{
        return !$order ? "" : anchor("/admin/shop/customers/orders",$order->getOrderCode(),[], [
            "id"    => $order->getId()
        ]);
    }

    /**
     * @param StateEntityInterface $state
     * @return string
     */
    public static function formatColor(StateEntityInterface $state): string
    {
        return sprintf('<font style="color:%s">%s</font>', $state->getColor() ?: "#000" , $state->getTitle());
    }
}