<?php


namespace Shop\Infrastructure\Repositories\Provider;


use Repo\Concrete\AbstractCriteria;
use Shop\Domain\Provider\Contracts\ProviderCriteriaInterface;

class ProviderCriteria extends AbstractCriteria implements ProviderCriteriaInterface
{
    /**
     * @var string|null
     */
    private $filterByName;

    /**
     * @var  string|null
     */
    private $searchByName;

    /**
     * @var  string|null
     */
    private $searchByDestination;

    /**
     * @var string|null
     */
    protected $sortByName;

    public static function create()
    {
        return new self();
    }

    /**
     * @return string|null
     */
    public function getSortByName(): ?string
    {
        return $this->sortByName;
    }

    /**
     * @param string|null $sortByName
     * @return ProviderCriteriaInterface
     */
    public function setSortByName(?string $sortByName): ProviderCriteriaInterface
    {
        $this->sortByName = $sortByName;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getSearchByDestination(): ?string
    {
        return $this->searchByDestination;
    }

    /**
     * @param string|null $searchByDestination
     * @return ProviderCriteria
     */
    public function setSearchByDestination(?string $searchByDestination): ProviderCriteriaInterface
    {
        $this->searchByDestination = $searchByDestination;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getSearchByName(): ?string
    {
        return $this->searchByName;
    }

    /**
     * @param mixed $searchByName
     * @return ProviderCriteria
     */
    public function setSearchByName($searchByName): ProviderCriteriaInterface
    {
        $this->searchByName = $searchByName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFilterByName(): ?string
    {
        return $this->filterByName;
    }

    /**
     * @param string|null $filterByName
     * @return ProviderCriteria
     */
    public function setFilterByName(?string $filterByName): ProviderCriteriaInterface
    {
        $this->filterByName = $filterByName;
        return $this;
    }

}