<?php


namespace Shop\Infrastructure\Repositories\ProductCategory;


use Repo\Concrete\AbstractCriteria;
use Shop\Domain\ProductCategory\Contracts\ProductCategoryCriteriaInterface;

class ProductCategoryCriteria extends AbstractCriteria implements ProductCategoryCriteriaInterface
{
    /**
     * @var
     */
    protected $filterByTitle;

    /**
     * @var string|null
     */
    protected $searchByTitle;

    /**
     * @var string|null
     */
    protected $sortByTitle;

    /**
     * @var bool |null
     */
    protected $asTreeView = false;

    /**
     * @var array|null
     */
    protected $ignoreIds;

    /**
     * @var array|null
     */
    protected $filterByPriceListIds;

    /**
     * @var bool
     */
    protected $filterByFoundPositions = false;


    protected $filterByParentIdIsNull = false;

    /**
     * @var array|null
     */
    protected $filterByParentIds;

    protected string|null $filterByAlias = null;

    public static function create()
    {
        return new self;
    }

    public function getFilterByAlias(): ?string
    {
        return $this->filterByAlias;
    }

    public function setFilterByAlias(?string $filterByAlias): ProductCategoryCriteriaInterface
    {
        $this->filterByAlias = $filterByAlias;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getFilterByTitle()
    {
        return $this->filterByTitle;
    }

    /**
     * @param mixed $filterByTitle
     * @return ProductCategoryCriteria
     */
    public function setFilterByTitle($filterByTitle)
    {
        $this->filterByTitle = $filterByTitle;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSearchByTitle(): ?string
    {
        return $this->searchByTitle;
    }

    /**
     * @param string|null $searchByTitle
     * @return ProductCategoryCriteria
     */
    public function setSearchByTitle(?string $searchByTitle): ProductCategoryCriteria
    {
        $this->searchByTitle = $searchByTitle;
        return $this;
    }




    /**
     * @return array
     */
    public function getFilterByParentIds(): ?array
    {
        return $this->filterByParentIds;
    }

    /**
     * @param array $filterByParentIds
     * @return ProductCategoryCriteria
     */
    public function setFilterByParentIds(?array $filterByParentIds): ProductCategoryCriteria
    {
        $this->filterByParentIds = $filterByParentIds;
        return $this;
    }


    /**
     * @return bool
     */
    public function getFilterByParentIdIsNull(): bool
    {
        return $this->filterByParentIdIsNull;
    }

    /**
     * @param bool $filterByParentIdIsNull
     * @return ProductCategoryCriteria
     */
    public function setFilterByParentIdIsNull(bool $filterByParentIdIsNull): ProductCategoryCriteria
    {
        $this->filterByParentIdIsNull = $filterByParentIdIsNull;
        return $this;
    }



    /**
     * @return string|null
     */
    public function getSortByTitle(): ?string
    {
        return $this->sortByTitle;
    }

    /**
     * @param string|null $sortByTitle
     * @return ProductCategoryCriteria
     */
    public function setSortByTitle(?string $sortByTitle): ProductCategoryCriteria
    {
        $this->sortByTitle = $sortByTitle;
        return $this;
    }


    /**
     * @return bool
     */
    public function getFindPositionCounts(): bool
    {
        return $this->filterByFoundPositions;
    }

    /**
     * @param bool $filterByFoundPositions
     * @return ProductCategoryCriteria
     */
    public function setFindPositionCounts(bool $filterByFoundPositions): ProductCategoryCriteria
    {
        $this->filterByFoundPositions = $filterByFoundPositions;
        return $this;
    }



    /**
     * @return array|null
     */
    public function getIgnoreIds(): ?array
    {
        return $this->ignoreIds;
    }

    /**
     * @param array|null $ignoreIds
     * @return ProductCategoryCriteria
     */
    public function setIgnoreIds(?array $ignoreIds): ProductCategoryCriteria
    {
        $this->ignoreIds = $ignoreIds;
        return $this;
    }

    /**
     * @return array|null
     */
    public function getFilterByPriceListIds(): ?array
    {
        return $this->filterByPriceListIds;
    }

    /**
     * @param array|null $filterByPriceListIds
     * @return ProductCategoryCriteria
     */
    public function setFilterByPriceListIds(?array $filterByPriceListIds): ProductCategoryCriteria
    {
        $this->filterByPriceListIds = $filterByPriceListIds;
        return $this;
    }



    /**
     * @return bool
     */
    public function asTreeView(): bool
    {
        return $this->asTreeView;
    }

    /**
     * @param bool $asTreeView
     * @return ProductCategoryCriteria
     */
    public function setAsTreeView(bool $asTreeView): ProductCategoryCriteria
    {
        $this->asTreeView = $asTreeView;
        return $this;
    }


}