<?php

namespace Shop\Infrastructure\Models\Shop\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Infrastructure\Models\Shop\ShopShopsArchive;
use Shop\Infrastructure\Models\Shop\ShopShopsArchiveQuery;


/**
 * This class defines the structure of the 'shop_shops_archive' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class ShopShopsArchiveTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Shop.Infrastructure.Models.Shop.Map.ShopShopsArchiveTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = 'shop_shops_archive';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Shop\\Infrastructure\\Models\\Shop\\ShopShopsArchive';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Shop.Infrastructure.Models.Shop.ShopShopsArchive';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 15;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 15;

    /**
     * the column name for the id field
     */
    public const COL_ID = 'shop_shops_archive.id';

    /**
     * the column name for the title field
     */
    public const COL_TITLE = 'shop_shops_archive.title';

    /**
     * the column name for the desc field
     */
    public const COL_DESC = 'shop_shops_archive.desc';

    /**
     * the column name for the image field
     */
    public const COL_IMAGE = 'shop_shops_archive.image';

    /**
     * the column name for the logo field
     */
    public const COL_LOGO = 'shop_shops_archive.logo';

    /**
     * the column name for the work_time field
     */
    public const COL_WORK_TIME = 'shop_shops_archive.work_time';

    /**
     * the column name for the director_contact field
     */
    public const COL_DIRECTOR_CONTACT = 'shop_shops_archive.director_contact';

    /**
     * the column name for the phones field
     */
    public const COL_PHONES = 'shop_shops_archive.phones';

    /**
     * the column name for the emails field
     */
    public const COL_EMAILS = 'shop_shops_archive.emails';

    /**
     * the column name for the type field
     */
    public const COL_TYPE = 'shop_shops_archive.type';

    /**
     * the column name for the parent_id field
     */
    public const COL_PARENT_ID = 'shop_shops_archive.parent_id';

    /**
     * the column name for the domain_id field
     */
    public const COL_DOMAIN_ID = 'shop_shops_archive.domain_id';

    /**
     * the column name for the active field
     */
    public const COL_ACTIVE = 'shop_shops_archive.active';

    /**
     * the column name for the contractor_id field
     */
    public const COL_CONTRACTOR_ID = 'shop_shops_archive.contractor_id';

    /**
     * the column name for the archived_at field
     */
    public const COL_ARCHIVED_AT = 'shop_shops_archive.archived_at';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'Title', 'Desc', 'Image', 'Logo', 'WorkTime', 'directorContact', 'Phones', 'emails', 'Type', 'ParentId', 'DomainId', 'Active', 'ContractorId', 'ArchivedAt', ],
        self::TYPE_CAMELNAME     => ['id', 'title', 'desc', 'image', 'logo', 'workTime', 'directorContact', 'phones', 'emails', 'type', 'parentId', 'domainId', 'active', 'contractorId', 'archivedAt', ],
        self::TYPE_COLNAME       => [ShopShopsArchiveTableMap::COL_ID, ShopShopsArchiveTableMap::COL_TITLE, ShopShopsArchiveTableMap::COL_DESC, ShopShopsArchiveTableMap::COL_IMAGE, ShopShopsArchiveTableMap::COL_LOGO, ShopShopsArchiveTableMap::COL_WORK_TIME, ShopShopsArchiveTableMap::COL_DIRECTOR_CONTACT, ShopShopsArchiveTableMap::COL_PHONES, ShopShopsArchiveTableMap::COL_EMAILS, ShopShopsArchiveTableMap::COL_TYPE, ShopShopsArchiveTableMap::COL_PARENT_ID, ShopShopsArchiveTableMap::COL_DOMAIN_ID, ShopShopsArchiveTableMap::COL_ACTIVE, ShopShopsArchiveTableMap::COL_CONTRACTOR_ID, ShopShopsArchiveTableMap::COL_ARCHIVED_AT, ],
        self::TYPE_FIELDNAME     => ['id', 'title', 'desc', 'image', 'logo', 'work_time', 'director_contact', 'phones', 'emails', 'type', 'parent_id', 'domain_id', 'active', 'contractor_id', 'archived_at', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'Title' => 1, 'Desc' => 2, 'Image' => 3, 'Logo' => 4, 'WorkTime' => 5, 'directorContact' => 6, 'Phones' => 7, 'emails' => 8, 'Type' => 9, 'ParentId' => 10, 'DomainId' => 11, 'Active' => 12, 'ContractorId' => 13, 'ArchivedAt' => 14, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'title' => 1, 'desc' => 2, 'image' => 3, 'logo' => 4, 'workTime' => 5, 'directorContact' => 6, 'phones' => 7, 'emails' => 8, 'type' => 9, 'parentId' => 10, 'domainId' => 11, 'active' => 12, 'contractorId' => 13, 'archivedAt' => 14, ],
        self::TYPE_COLNAME       => [ShopShopsArchiveTableMap::COL_ID => 0, ShopShopsArchiveTableMap::COL_TITLE => 1, ShopShopsArchiveTableMap::COL_DESC => 2, ShopShopsArchiveTableMap::COL_IMAGE => 3, ShopShopsArchiveTableMap::COL_LOGO => 4, ShopShopsArchiveTableMap::COL_WORK_TIME => 5, ShopShopsArchiveTableMap::COL_DIRECTOR_CONTACT => 6, ShopShopsArchiveTableMap::COL_PHONES => 7, ShopShopsArchiveTableMap::COL_EMAILS => 8, ShopShopsArchiveTableMap::COL_TYPE => 9, ShopShopsArchiveTableMap::COL_PARENT_ID => 10, ShopShopsArchiveTableMap::COL_DOMAIN_ID => 11, ShopShopsArchiveTableMap::COL_ACTIVE => 12, ShopShopsArchiveTableMap::COL_CONTRACTOR_ID => 13, ShopShopsArchiveTableMap::COL_ARCHIVED_AT => 14, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'title' => 1, 'desc' => 2, 'image' => 3, 'logo' => 4, 'work_time' => 5, 'director_contact' => 6, 'phones' => 7, 'emails' => 8, 'type' => 9, 'parent_id' => 10, 'domain_id' => 11, 'active' => 12, 'contractor_id' => 13, 'archived_at' => 14, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'ShopShopsArchive.Id' => 'ID',
        'id' => 'ID',
        'shopShopsArchive.id' => 'ID',
        'ShopShopsArchiveTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        'shop_shops_archive.id' => 'ID',
        'Title' => 'TITLE',
        'ShopShopsArchive.Title' => 'TITLE',
        'title' => 'TITLE',
        'shopShopsArchive.title' => 'TITLE',
        'ShopShopsArchiveTableMap::COL_TITLE' => 'TITLE',
        'COL_TITLE' => 'TITLE',
        'shop_shops_archive.title' => 'TITLE',
        'Desc' => 'DESC',
        'ShopShopsArchive.Desc' => 'DESC',
        'desc' => 'DESC',
        'shopShopsArchive.desc' => 'DESC',
        'ShopShopsArchiveTableMap::COL_DESC' => 'DESC',
        'COL_DESC' => 'DESC',
        'shop_shops_archive.desc' => 'DESC',
        'Image' => 'IMAGE',
        'ShopShopsArchive.Image' => 'IMAGE',
        'image' => 'IMAGE',
        'shopShopsArchive.image' => 'IMAGE',
        'ShopShopsArchiveTableMap::COL_IMAGE' => 'IMAGE',
        'COL_IMAGE' => 'IMAGE',
        'shop_shops_archive.image' => 'IMAGE',
        'Logo' => 'LOGO',
        'ShopShopsArchive.Logo' => 'LOGO',
        'logo' => 'LOGO',
        'shopShopsArchive.logo' => 'LOGO',
        'ShopShopsArchiveTableMap::COL_LOGO' => 'LOGO',
        'COL_LOGO' => 'LOGO',
        'shop_shops_archive.logo' => 'LOGO',
        'WorkTime' => 'WORK_TIME',
        'ShopShopsArchive.WorkTime' => 'WORK_TIME',
        'workTime' => 'WORK_TIME',
        'shopShopsArchive.workTime' => 'WORK_TIME',
        'ShopShopsArchiveTableMap::COL_WORK_TIME' => 'WORK_TIME',
        'COL_WORK_TIME' => 'WORK_TIME',
        'work_time' => 'WORK_TIME',
        'shop_shops_archive.work_time' => 'WORK_TIME',
        'directorContact' => 'DIRECTOR_CONTACT',
        'ShopShopsArchive.directorContact' => 'DIRECTOR_CONTACT',
        'shopShopsArchive.directorContact' => 'DIRECTOR_CONTACT',
        'ShopShopsArchiveTableMap::COL_DIRECTOR_CONTACT' => 'DIRECTOR_CONTACT',
        'COL_DIRECTOR_CONTACT' => 'DIRECTOR_CONTACT',
        'director_contact' => 'DIRECTOR_CONTACT',
        'shop_shops_archive.director_contact' => 'DIRECTOR_CONTACT',
        'Phones' => 'PHONES',
        'ShopShopsArchive.Phones' => 'PHONES',
        'phones' => 'PHONES',
        'shopShopsArchive.phones' => 'PHONES',
        'ShopShopsArchiveTableMap::COL_PHONES' => 'PHONES',
        'COL_PHONES' => 'PHONES',
        'shop_shops_archive.phones' => 'PHONES',
        'emails' => 'EMAILS',
        'ShopShopsArchive.emails' => 'EMAILS',
        'shopShopsArchive.emails' => 'EMAILS',
        'ShopShopsArchiveTableMap::COL_EMAILS' => 'EMAILS',
        'COL_EMAILS' => 'EMAILS',
        'shop_shops_archive.emails' => 'EMAILS',
        'Type' => 'TYPE',
        'ShopShopsArchive.Type' => 'TYPE',
        'type' => 'TYPE',
        'shopShopsArchive.type' => 'TYPE',
        'ShopShopsArchiveTableMap::COL_TYPE' => 'TYPE',
        'COL_TYPE' => 'TYPE',
        'shop_shops_archive.type' => 'TYPE',
        'ParentId' => 'PARENT_ID',
        'ShopShopsArchive.ParentId' => 'PARENT_ID',
        'parentId' => 'PARENT_ID',
        'shopShopsArchive.parentId' => 'PARENT_ID',
        'ShopShopsArchiveTableMap::COL_PARENT_ID' => 'PARENT_ID',
        'COL_PARENT_ID' => 'PARENT_ID',
        'parent_id' => 'PARENT_ID',
        'shop_shops_archive.parent_id' => 'PARENT_ID',
        'DomainId' => 'DOMAIN_ID',
        'ShopShopsArchive.DomainId' => 'DOMAIN_ID',
        'domainId' => 'DOMAIN_ID',
        'shopShopsArchive.domainId' => 'DOMAIN_ID',
        'ShopShopsArchiveTableMap::COL_DOMAIN_ID' => 'DOMAIN_ID',
        'COL_DOMAIN_ID' => 'DOMAIN_ID',
        'domain_id' => 'DOMAIN_ID',
        'shop_shops_archive.domain_id' => 'DOMAIN_ID',
        'Active' => 'ACTIVE',
        'ShopShopsArchive.Active' => 'ACTIVE',
        'active' => 'ACTIVE',
        'shopShopsArchive.active' => 'ACTIVE',
        'ShopShopsArchiveTableMap::COL_ACTIVE' => 'ACTIVE',
        'COL_ACTIVE' => 'ACTIVE',
        'shop_shops_archive.active' => 'ACTIVE',
        'ContractorId' => 'CONTRACTOR_ID',
        'ShopShopsArchive.ContractorId' => 'CONTRACTOR_ID',
        'contractorId' => 'CONTRACTOR_ID',
        'shopShopsArchive.contractorId' => 'CONTRACTOR_ID',
        'ShopShopsArchiveTableMap::COL_CONTRACTOR_ID' => 'CONTRACTOR_ID',
        'COL_CONTRACTOR_ID' => 'CONTRACTOR_ID',
        'contractor_id' => 'CONTRACTOR_ID',
        'shop_shops_archive.contractor_id' => 'CONTRACTOR_ID',
        'ArchivedAt' => 'ARCHIVED_AT',
        'ShopShopsArchive.ArchivedAt' => 'ARCHIVED_AT',
        'archivedAt' => 'ARCHIVED_AT',
        'shopShopsArchive.archivedAt' => 'ARCHIVED_AT',
        'ShopShopsArchiveTableMap::COL_ARCHIVED_AT' => 'ARCHIVED_AT',
        'COL_ARCHIVED_AT' => 'ARCHIVED_AT',
        'archived_at' => 'ARCHIVED_AT',
        'shop_shops_archive.archived_at' => 'ARCHIVED_AT',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('shop_shops_archive');
        $this->setPhpName('ShopShopsArchive');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Infrastructure\\Models\\Shop\\ShopShopsArchive');
        $this->setPackage('Shop.Infrastructure.Models.Shop');
        $this->setUseIdGenerator(false);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('title', 'Title', 'VARCHAR', true, 255, null);
        $this->addColumn('desc', 'Desc', 'LONGVARCHAR', false, null, null);
        $this->addColumn('image', 'Image', 'VARCHAR', false, 255, null);
        $this->addColumn('logo', 'Logo', 'VARCHAR', false, 255, null);
        $this->addColumn('work_time', 'WorkTime', 'VARCHAR', false, 100, null);
        $this->addColumn('director_contact', 'directorContact', 'LONGVARCHAR', false, null, null);
        $this->addColumn('phones', 'Phones', 'LONGVARCHAR', false, null, null);
        $this->addColumn('emails', 'emails', 'LONGVARCHAR', false, null, null);
        $this->addColumn('type', 'Type', 'CHAR', true, null, 'main');
        $this->addColumn('parent_id', 'ParentId', 'INTEGER', false, null, null);
        $this->addColumn('domain_id', 'DomainId', 'INTEGER', false, null, null);
        $this->addColumn('active', 'Active', 'CHAR', true, null, 'Y');
        $this->addColumn('contractor_id', 'ContractorId', 'INTEGER', false, null, null);
        $this->addColumn('archived_at', 'ArchivedAt', 'TIMESTAMP', false, null, null);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? ShopShopsArchiveTableMap::CLASS_DEFAULT : ShopShopsArchiveTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (ShopShopsArchive object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = ShopShopsArchiveTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = ShopShopsArchiveTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + ShopShopsArchiveTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = ShopShopsArchiveTableMap::OM_CLASS;
            /** @var ShopShopsArchive $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            ShopShopsArchiveTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = ShopShopsArchiveTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = ShopShopsArchiveTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var ShopShopsArchive $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                ShopShopsArchiveTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(ShopShopsArchiveTableMap::COL_ID);
            $criteria->addSelectColumn(ShopShopsArchiveTableMap::COL_TITLE);
            $criteria->addSelectColumn(ShopShopsArchiveTableMap::COL_DESC);
            $criteria->addSelectColumn(ShopShopsArchiveTableMap::COL_IMAGE);
            $criteria->addSelectColumn(ShopShopsArchiveTableMap::COL_LOGO);
            $criteria->addSelectColumn(ShopShopsArchiveTableMap::COL_WORK_TIME);
            $criteria->addSelectColumn(ShopShopsArchiveTableMap::COL_DIRECTOR_CONTACT);
            $criteria->addSelectColumn(ShopShopsArchiveTableMap::COL_PHONES);
            $criteria->addSelectColumn(ShopShopsArchiveTableMap::COL_EMAILS);
            $criteria->addSelectColumn(ShopShopsArchiveTableMap::COL_TYPE);
            $criteria->addSelectColumn(ShopShopsArchiveTableMap::COL_PARENT_ID);
            $criteria->addSelectColumn(ShopShopsArchiveTableMap::COL_DOMAIN_ID);
            $criteria->addSelectColumn(ShopShopsArchiveTableMap::COL_ACTIVE);
            $criteria->addSelectColumn(ShopShopsArchiveTableMap::COL_CONTRACTOR_ID);
            $criteria->addSelectColumn(ShopShopsArchiveTableMap::COL_ARCHIVED_AT);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.title');
            $criteria->addSelectColumn($alias . '.desc');
            $criteria->addSelectColumn($alias . '.image');
            $criteria->addSelectColumn($alias . '.logo');
            $criteria->addSelectColumn($alias . '.work_time');
            $criteria->addSelectColumn($alias . '.director_contact');
            $criteria->addSelectColumn($alias . '.phones');
            $criteria->addSelectColumn($alias . '.emails');
            $criteria->addSelectColumn($alias . '.type');
            $criteria->addSelectColumn($alias . '.parent_id');
            $criteria->addSelectColumn($alias . '.domain_id');
            $criteria->addSelectColumn($alias . '.active');
            $criteria->addSelectColumn($alias . '.contractor_id');
            $criteria->addSelectColumn($alias . '.archived_at');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(ShopShopsArchiveTableMap::COL_ID);
            $criteria->removeSelectColumn(ShopShopsArchiveTableMap::COL_TITLE);
            $criteria->removeSelectColumn(ShopShopsArchiveTableMap::COL_DESC);
            $criteria->removeSelectColumn(ShopShopsArchiveTableMap::COL_IMAGE);
            $criteria->removeSelectColumn(ShopShopsArchiveTableMap::COL_LOGO);
            $criteria->removeSelectColumn(ShopShopsArchiveTableMap::COL_WORK_TIME);
            $criteria->removeSelectColumn(ShopShopsArchiveTableMap::COL_DIRECTOR_CONTACT);
            $criteria->removeSelectColumn(ShopShopsArchiveTableMap::COL_PHONES);
            $criteria->removeSelectColumn(ShopShopsArchiveTableMap::COL_EMAILS);
            $criteria->removeSelectColumn(ShopShopsArchiveTableMap::COL_TYPE);
            $criteria->removeSelectColumn(ShopShopsArchiveTableMap::COL_PARENT_ID);
            $criteria->removeSelectColumn(ShopShopsArchiveTableMap::COL_DOMAIN_ID);
            $criteria->removeSelectColumn(ShopShopsArchiveTableMap::COL_ACTIVE);
            $criteria->removeSelectColumn(ShopShopsArchiveTableMap::COL_CONTRACTOR_ID);
            $criteria->removeSelectColumn(ShopShopsArchiveTableMap::COL_ARCHIVED_AT);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.title');
            $criteria->removeSelectColumn($alias . '.desc');
            $criteria->removeSelectColumn($alias . '.image');
            $criteria->removeSelectColumn($alias . '.logo');
            $criteria->removeSelectColumn($alias . '.work_time');
            $criteria->removeSelectColumn($alias . '.director_contact');
            $criteria->removeSelectColumn($alias . '.phones');
            $criteria->removeSelectColumn($alias . '.emails');
            $criteria->removeSelectColumn($alias . '.type');
            $criteria->removeSelectColumn($alias . '.parent_id');
            $criteria->removeSelectColumn($alias . '.domain_id');
            $criteria->removeSelectColumn($alias . '.active');
            $criteria->removeSelectColumn($alias . '.contractor_id');
            $criteria->removeSelectColumn($alias . '.archived_at');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(ShopShopsArchiveTableMap::DATABASE_NAME)->getTable(ShopShopsArchiveTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a ShopShopsArchive or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or ShopShopsArchive object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopShopsArchiveTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Infrastructure\Models\Shop\ShopShopsArchive) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(ShopShopsArchiveTableMap::DATABASE_NAME);
            $criteria->add(ShopShopsArchiveTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = ShopShopsArchiveQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            ShopShopsArchiveTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                ShopShopsArchiveTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_shops_archive table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return ShopShopsArchiveQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a ShopShopsArchive or Criteria object.
     *
     * @param mixed $criteria Criteria or ShopShopsArchive object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopShopsArchiveTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from ShopShopsArchive object
        }


        // Set the correct dbName
        $query = ShopShopsArchiveQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
