<?php

namespace Shop\Domain\ProductCategory\Contracts;

use Repo\PaginationInterface;
use Repo\RepositoryCriteriaInterface;

/**
 * Description of ProductCategory
 *
 * @author Diamond Code Generator
 */
interface ProductCategoryCriteriaInterface extends RepositoryCriteriaInterface, PaginationInterface
{

    public function setFilterByAlias(?string $filterByAlias): ProductCategoryCriteriaInterface;

    public function getFilterByAlias(): ?string;

    /**
     * @return bool
     */
    public function asTreeView(): bool;

    /**
     * @return array|null
     */
    public function getIgnoreIds(): ?array;

    /**
     * @return mixed
     */
    public function getFilterByPriceListIds(): ?array;

    /**
     * @param bool $value
     * @return mixed
     */
    public function setFindPositionCounts(bool $value);

    /**
     * @return bool
     */
    public function getFindPositionCounts():bool ;

    /**
     * @return string|null
     */
    public function getSortByTitle():?string;

    /**
     * @return int|null
     */
    public function getFilterByParentIds():?array;

    /**
     * @return bool
     */
    public function getFilterByParentIdIsNull(): bool ;

    /**
     * @param string $title
     * @return mixed
     */
    public function setSearchByTitle(string $title);

    /**
     * @param string $title
     * @return mixed
     */
    public function setFilterByTitle(string $title);
}           