<?php

namespace Shop\Infrastructure\Models\DraftProduct\Base;

use \DateTime;
use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\BadMethodCallException;
use Propel\Runtime\Exception\LogicException;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Parser\AbstractParser;
use Propel\Runtime\Util\PropelDateTime;
use Shop\Infrastructure\Models\Brand\Brand;
use Shop\Infrastructure\Models\Brand\BrandQuery;
use Shop\Infrastructure\Models\Category\Category;
use Shop\Infrastructure\Models\Category\CategoryQuery;
use Shop\Infrastructure\Models\Customer\Customer;
use Shop\Infrastructure\Models\Customer\CustomerQuery;
use Shop\Infrastructure\Models\DraftProduct\DraftProductQuery as ChildDraftProductQuery;
use Shop\Infrastructure\Models\DraftProduct\Map\DraftProductTableMap;
use Shop\Infrastructure\Models\Product\Product;
use Shop\Infrastructure\Models\Product\ProductQuery;

/**
 * Base class that represents a row from the 'shop_product_drafts' table.
 *
 *
 *
 * @package    propel.generator.Shop.Infrastructure.Models.DraftProduct.Base
 */
abstract class DraftProduct implements ActiveRecordInterface
{
    /**
     * TableMap class name
     *
     * @var string
     */
    public const TABLE_MAP = '\\Shop\\Infrastructure\\Models\\DraftProduct\\Map\\DraftProductTableMap';


    /**
     * attribute to determine if this object has previously been saved.
     * @var bool
     */
    protected $new = true;

    /**
     * attribute to determine whether this object has been deleted.
     * @var bool
     */
    protected $deleted = false;

    /**
     * The columns that have been modified in current object.
     * Tracking modified columns allows us to only update modified columns.
     * @var array
     */
    protected $modifiedColumns = [];

    /**
     * The (virtual) columns that are added at runtime
     * The formatters can add supplementary columns based on a resultset
     * @var array
     */
    protected $virtualColumns = [];

    /**
     * The value for the id field.
     *
     * @var        int
     */
    protected $id;

    /**
     * The value for the title field.
     *
     * @var        string
     */
    protected $title;

    /**
     * The value for the desc field.
     *
     * @var        string|null
     */
    protected $desc;

    /**
     * The value for the short_desc field.
     *
     * @var        string|null
     */
    protected $short_desc;

    /**
     * The value for the article field.
     *
     * @var        string|null
     */
    protected $article;

    /**
     * The value for the price field.
     *
     * @var        string|null
     */
    protected $price;

    /**
     * The value for the weight field.
     *
     * @var        string|null
     */
    protected $weight;

    /**
     * The value for the img field.
     *
     * @var        string|null
     */
    protected $img;

    /**
     * The value for the special field.
     *
     * Note: this column has a database default value of: 'N'
     * @var        string
     */
    protected $special;

    /**
     * The value for the active field.
     *
     * Note: this column has a database default value of: 'Y'
     * @var        string
     */
    protected $active;

    /**
     * The value for the mt_title field.
     *
     * @var        string|null
     */
    protected $mt_title;

    /**
     * The value for the mt_description field.
     *
     * @var        string|null
     */
    protected $mt_description;

    /**
     * The value for the mt_keywords field.
     *
     * @var        string|null
     */
    protected $mt_keywords;

    /**
     * The value for the remains field.
     *
     * @var        string|null
     */
    protected $remains;

    /**
     * The value for the udate field.
     *
     * Note: this column has a database default value of: (expression) CURRENT_TIMESTAMP
     * @var        DateTime|null
     */
    protected $udate;

    /**
     * The value for the cdate field.
     *
     * Note: this column has a database default value of: (expression) CURRENT_TIMESTAMP
     * @var        DateTime
     */
    protected $cdate;

    /**
     * The value for the pdate field.
     *
     * @var        DateTime|null
     */
    protected $pdate;

    /**
     * The value for the ref field.
     *
     * @var        int|null
     */
    protected $ref;

    /**
     * The value for the min_quality field.
     *
     * @var        string|null
     */
    protected $min_quality;

    /**
     * The value for the seazon field.
     *
     * @var        string|null
     */
    protected $seazon;

    /**
     * The value for the product_id field.
     *
     * @var        int|null
     */
    protected $product_id;

    /**
     * The value for the category_id field.
     *
     * @var        int
     */
    protected $category_id;

    /**
     * The value for the brand_id field.
     *
     * @var        int
     */
    protected $brand_id;

    /**
     * The value for the customer_id field.
     *
     * @var        int
     */
    protected $customer_id;

    /**
     * @var        Product
     */
    protected $aProduct;

    /**
     * @var        Category
     */
    protected $aCategory;

    /**
     * @var        Brand
     */
    protected $aBrand;

    /**
     * @var        Customer
     */
    protected $aCustomer;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     *
     * @var bool
     */
    protected $alreadyInSave = false;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see __construct()
     */
    public function applyDefaultValues(): void
    {
        $this->special = 'N';
        $this->active = 'Y';
    }

    /**
     * Initializes internal state of Shop\Infrastructure\Models\DraftProduct\Base\DraftProduct object.
     * @see applyDefaults()
     */
    public function __construct()
    {
        $this->applyDefaultValues();
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return bool True if the object has been modified.
     */
    public function isModified(): bool
    {
        return !!$this->modifiedColumns;
    }

    /**
     * Has specified column been modified?
     *
     * @param string $col column fully qualified name (TableMap::TYPE_COLNAME), e.g. Book::AUTHOR_ID
     * @return bool True if $col has been modified.
     */
    public function isColumnModified(string $col): bool
    {
        return $this->modifiedColumns && isset($this->modifiedColumns[$col]);
    }

    /**
     * Get the columns that have been modified in this object.
     * @return array A unique list of the modified column names for this object.
     */
    public function getModifiedColumns(): array
    {
        return $this->modifiedColumns ? array_keys($this->modifiedColumns) : [];
    }

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return bool True, if the object has never been persisted.
     */
    public function isNew(): bool
    {
        return $this->new;
    }

    /**
     * Setter for the isNew attribute.  This method will be called
     * by Propel-generated children and objects.
     *
     * @param bool $b the state of the object.
     */
    public function setNew(bool $b): void
    {
        $this->new = $b;
    }

    /**
     * Whether this object has been deleted.
     * @return bool The deleted state of this object.
     */
    public function isDeleted(): bool
    {
        return $this->deleted;
    }

    /**
     * Specify whether this object has been deleted.
     * @param bool $b The deleted state of this object.
     * @return void
     */
    public function setDeleted(bool $b): void
    {
        $this->deleted = $b;
    }

    /**
     * Sets the modified state for the object to be false.
     * @param string $col If supplied, only the specified column is reset.
     * @return void
     */
    public function resetModified(?string $col = null): void
    {
        if (null !== $col) {
            unset($this->modifiedColumns[$col]);
        } else {
            $this->modifiedColumns = [];
        }
    }

    /**
     * Compares this with another <code>DraftProduct</code> instance.  If
     * <code>obj</code> is an instance of <code>DraftProduct</code>, delegates to
     * <code>equals(DraftProduct)</code>.  Otherwise, returns <code>false</code>.
     *
     * @param mixed $obj The object to compare to.
     * @return bool Whether equal to the object specified.
     */
    public function equals($obj): bool
    {
        if (!$obj instanceof static) {
            return false;
        }

        if ($this === $obj) {
            return true;
        }

        if (null === $this->getPrimaryKey() || null === $obj->getPrimaryKey()) {
            return false;
        }

        return $this->getPrimaryKey() === $obj->getPrimaryKey();
    }

    /**
     * Get the associative array of the virtual columns in this object
     *
     * @return array
     */
    public function getVirtualColumns(): array
    {
        return $this->virtualColumns;
    }

    /**
     * Checks the existence of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @return bool
     */
    public function hasVirtualColumn(string $name): bool
    {
        return array_key_exists($name, $this->virtualColumns);
    }

    /**
     * Get the value of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @return mixed
     *
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getVirtualColumn(string $name)
    {
        if (!$this->hasVirtualColumn($name)) {
            throw new PropelException(sprintf('Cannot get value of nonexistent virtual column `%s`.', $name));
        }

        return $this->virtualColumns[$name];
    }

    /**
     * Set the value of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @param mixed $value The value to give to the virtual column
     *
     * @return $this The current object, for fluid interface
     */
    public function setVirtualColumn(string $name, $value)
    {
        $this->virtualColumns[$name] = $value;

        return $this;
    }

    /**
     * Logs a message using Propel::log().
     *
     * @param string $msg
     * @param int $priority One of the Propel::LOG_* logging levels
     * @return void
     */
    protected function log(string $msg, int $priority = Propel::LOG_INFO): void
    {
        Propel::log(get_class($this) . ': ' . $msg, $priority);
    }

    /**
     * Export the current object properties to a string, using a given parser format
     * <code>
     * $book = BookQuery::create()->findPk(9012);
     * echo $book->exportTo('JSON');
     *  => {"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * @param \Propel\Runtime\Parser\AbstractParser|string $parser An AbstractParser instance, or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param bool $includeLazyLoadColumns (optional) Whether to include lazy load(ed) columns. Defaults to TRUE.
     * @param string $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME, TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM. Defaults to TableMap::TYPE_PHPNAME.
     * @return string The exported data
     */
    public function exportTo($parser, bool $includeLazyLoadColumns = true, string $keyType = TableMap::TYPE_PHPNAME): string
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        return $parser->fromArray($this->toArray($keyType, $includeLazyLoadColumns, array(), true));
    }

    /**
     * Clean up internal collections prior to serializing
     * Avoids recursive loops that turn into segmentation faults when serializing
     *
     * @return array<string>
     */
    public function __sleep(): array
    {
        $this->clearAllReferences();

        $cls = new \ReflectionClass($this);
        $propertyNames = [];
        $serializableProperties = array_diff($cls->getProperties(), $cls->getProperties(\ReflectionProperty::IS_STATIC));

        foreach($serializableProperties as $property) {
            $propertyNames[] = $property->getName();
        }

        return $propertyNames;
    }

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [title] column value.
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Get the [desc] column value.
     *
     * @return string|null
     */
    public function getDesc()
    {
        return $this->desc;
    }

    /**
     * Get the [short_desc] column value.
     *
     * @return string|null
     */
    public function getShortDesc()
    {
        return $this->short_desc;
    }

    /**
     * Get the [article] column value.
     *
     * @return string|null
     */
    public function getArticle()
    {
        return $this->article;
    }

    /**
     * Get the [price] column value.
     *
     * @return string|null
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * Get the [weight] column value.
     *
     * @return string|null
     */
    public function getWeight()
    {
        return $this->weight;
    }

    /**
     * Get the [img] column value.
     *
     * @return string|null
     */
    public function getImg()
    {
        return $this->img;
    }

    /**
     * Get the [special] column value.
     *
     * @return string
     */
    public function getSpecial()
    {
        return $this->special;
    }

    /**
     * Get the [active] column value.
     *
     * @return string
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * Get the [mt_title] column value.
     *
     * @return string|null
     */
    public function getMtTitle()
    {
        return $this->mt_title;
    }

    /**
     * Get the [mt_description] column value.
     *
     * @return string|null
     */
    public function getMtDescription()
    {
        return $this->mt_description;
    }

    /**
     * Get the [mt_keywords] column value.
     *
     * @return string|null
     */
    public function getMtKeywords()
    {
        return $this->mt_keywords;
    }

    /**
     * Get the [remains] column value.
     *
     * @return string|null
     */
    public function getRemains()
    {
        return $this->remains;
    }

    /**
     * Get the [optionally formatted] temporal [udate] column value.
     *
     *
     * @param string|null $format The date/time format string (either date()-style or strftime()-style).
     *   If format is NULL, then the raw DateTime object will be returned.
     *
     * @return string|DateTime|null Formatted date/time value as string or DateTime object (if format is NULL), NULL if column is NULL, and 0 if column value is 0000-00-00 00:00:00.
     *
     * @throws \Propel\Runtime\Exception\PropelException - if unable to parse/validate the date/time value.
     *
     * @psalm-return ($format is null ? DateTime|null : string|null)
     */
    public function getdateUpdate($format = null)
    {
        if ($format === null) {
            return $this->udate;
        } else {
            return $this->udate instanceof \DateTimeInterface ? $this->udate->format($format) : null;
        }
    }

    /**
     * Get the [optionally formatted] temporal [cdate] column value.
     *
     *
     * @param string|null $format The date/time format string (either date()-style or strftime()-style).
     *   If format is NULL, then the raw DateTime object will be returned.
     *
     * @return string|DateTime Formatted date/time value as string or DateTime object (if format is NULL), and 0 if column value is 0000-00-00 00:00:00.
     *
     * @throws \Propel\Runtime\Exception\PropelException - if unable to parse/validate the date/time value.
     *
     * @psalm-return ($format is null ? DateTime : string)
     */
    public function getdateCreate($format = null)
    {
        if ($format === null) {
            return $this->cdate;
        } else {
            return $this->cdate instanceof \DateTimeInterface ? $this->cdate->format($format) : null;
        }
    }

    /**
     * Get the [optionally formatted] temporal [pdate] column value.
     *
     *
     * @param string|null $format The date/time format string (either date()-style or strftime()-style).
     *   If format is NULL, then the raw DateTime object will be returned.
     *
     * @return string|DateTime|null Formatted date/time value as string or DateTime object (if format is NULL), NULL if column is NULL, and 0 if column value is 0000-00-00 00:00:00.
     *
     * @throws \Propel\Runtime\Exception\PropelException - if unable to parse/validate the date/time value.
     *
     * @psalm-return ($format is null ? DateTime|null : string|null)
     */
    public function getdatePublic($format = null)
    {
        if ($format === null) {
            return $this->pdate;
        } else {
            return $this->pdate instanceof \DateTimeInterface ? $this->pdate->format($format) : null;
        }
    }

    /**
     * Get the [ref] column value.
     *
     * @return int|null
     */
    public function getRef()
    {
        return $this->ref;
    }

    /**
     * Get the [min_quality] column value.
     *
     * @return string|null
     */
    public function getMinQuality()
    {
        return $this->min_quality;
    }

    /**
     * Get the [seazon] column value.
     *
     * @return string|null
     */
    public function getSeazon()
    {
        return $this->seazon;
    }

    /**
     * Get the [product_id] column value.
     *
     * @return int|null
     */
    public function getProductId()
    {
        return $this->product_id;
    }

    /**
     * Get the [category_id] column value.
     *
     * @return int
     */
    public function getCategoryId()
    {
        return $this->category_id;
    }

    /**
     * Get the [brand_id] column value.
     *
     * @return int
     */
    public function getBrandId()
    {
        return $this->brand_id;
    }

    /**
     * Get the [customer_id] column value.
     *
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customer_id;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[DraftProductTableMap::COL_ID] = true;
        }

        return $this;
    }

    /**
     * Set the value of [title] column.
     *
     * @param string $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setTitle($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->title !== $v) {
            $this->title = $v;
            $this->modifiedColumns[DraftProductTableMap::COL_TITLE] = true;
        }

        return $this;
    }

    /**
     * Set the value of [desc] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setDesc($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->desc !== $v) {
            $this->desc = $v;
            $this->modifiedColumns[DraftProductTableMap::COL_DESC] = true;
        }

        return $this;
    }

    /**
     * Set the value of [short_desc] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setShortDesc($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->short_desc !== $v) {
            $this->short_desc = $v;
            $this->modifiedColumns[DraftProductTableMap::COL_SHORT_DESC] = true;
        }

        return $this;
    }

    /**
     * Set the value of [article] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setArticle($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->article !== $v) {
            $this->article = $v;
            $this->modifiedColumns[DraftProductTableMap::COL_ARTICLE] = true;
        }

        return $this;
    }

    /**
     * Set the value of [price] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setPrice($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->price !== $v) {
            $this->price = $v;
            $this->modifiedColumns[DraftProductTableMap::COL_PRICE] = true;
        }

        return $this;
    }

    /**
     * Set the value of [weight] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setWeight($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->weight !== $v) {
            $this->weight = $v;
            $this->modifiedColumns[DraftProductTableMap::COL_WEIGHT] = true;
        }

        return $this;
    }

    /**
     * Set the value of [img] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setImg($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->img !== $v) {
            $this->img = $v;
            $this->modifiedColumns[DraftProductTableMap::COL_IMG] = true;
        }

        return $this;
    }

    /**
     * Set the value of [special] column.
     *
     * @param string $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setSpecial($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->special !== $v) {
            $this->special = $v;
            $this->modifiedColumns[DraftProductTableMap::COL_SPECIAL] = true;
        }

        return $this;
    }

    /**
     * Set the value of [active] column.
     *
     * @param string $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setActive($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->active !== $v) {
            $this->active = $v;
            $this->modifiedColumns[DraftProductTableMap::COL_ACTIVE] = true;
        }

        return $this;
    }

    /**
     * Set the value of [mt_title] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setMtTitle($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->mt_title !== $v) {
            $this->mt_title = $v;
            $this->modifiedColumns[DraftProductTableMap::COL_MT_TITLE] = true;
        }

        return $this;
    }

    /**
     * Set the value of [mt_description] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setMtDescription($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->mt_description !== $v) {
            $this->mt_description = $v;
            $this->modifiedColumns[DraftProductTableMap::COL_MT_DESCRIPTION] = true;
        }

        return $this;
    }

    /**
     * Set the value of [mt_keywords] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setMtKeywords($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->mt_keywords !== $v) {
            $this->mt_keywords = $v;
            $this->modifiedColumns[DraftProductTableMap::COL_MT_KEYWORDS] = true;
        }

        return $this;
    }

    /**
     * Set the value of [remains] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setRemains($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->remains !== $v) {
            $this->remains = $v;
            $this->modifiedColumns[DraftProductTableMap::COL_REMAINS] = true;
        }

        return $this;
    }

    /**
     * Sets the value of [udate] column to a normalized version of the date/time value specified.
     *
     * @param string|integer|\DateTimeInterface|null $v string, integer (timestamp), or \DateTimeInterface value.
     *               Empty strings are treated as NULL.
     * @return $this The current object (for fluent API support)
     */
    public function setdateUpdate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->udate !== null || $dt !== null) {
            if ($this->udate === null || $dt === null || $dt->format("Y-m-d H:i:s.u") !== $this->udate->format("Y-m-d H:i:s.u")) {
                $this->udate = $dt === null ? null : clone $dt;
                $this->modifiedColumns[DraftProductTableMap::COL_UDATE] = true;
            }
        } // if either are not null

        return $this;
    }

    /**
     * Sets the value of [cdate] column to a normalized version of the date/time value specified.
     *
     * @param string|integer|\DateTimeInterface $v string, integer (timestamp), or \DateTimeInterface value.
     *               Empty strings are treated as NULL.
     * @return $this The current object (for fluent API support)
     */
    public function setdateCreate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->cdate !== null || $dt !== null) {
            if ($this->cdate === null || $dt === null || $dt->format("Y-m-d H:i:s.u") !== $this->cdate->format("Y-m-d H:i:s.u")) {
                $this->cdate = $dt === null ? null : clone $dt;
                $this->modifiedColumns[DraftProductTableMap::COL_CDATE] = true;
            }
        } // if either are not null

        return $this;
    }

    /**
     * Sets the value of [pdate] column to a normalized version of the date/time value specified.
     *
     * @param string|integer|\DateTimeInterface|null $v string, integer (timestamp), or \DateTimeInterface value.
     *               Empty strings are treated as NULL.
     * @return $this The current object (for fluent API support)
     */
    public function setdatePublic($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->pdate !== null || $dt !== null) {
            if ($this->pdate === null || $dt === null || $dt->format("Y-m-d H:i:s.u") !== $this->pdate->format("Y-m-d H:i:s.u")) {
                $this->pdate = $dt === null ? null : clone $dt;
                $this->modifiedColumns[DraftProductTableMap::COL_PDATE] = true;
            }
        } // if either are not null

        return $this;
    }

    /**
     * Set the value of [ref] column.
     *
     * @param int|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setRef($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->ref !== $v) {
            $this->ref = $v;
            $this->modifiedColumns[DraftProductTableMap::COL_REF] = true;
        }

        return $this;
    }

    /**
     * Set the value of [min_quality] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setMinQuality($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->min_quality !== $v) {
            $this->min_quality = $v;
            $this->modifiedColumns[DraftProductTableMap::COL_MIN_QUALITY] = true;
        }

        return $this;
    }

    /**
     * Set the value of [seazon] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setSeazon($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->seazon !== $v) {
            $this->seazon = $v;
            $this->modifiedColumns[DraftProductTableMap::COL_SEAZON] = true;
        }

        return $this;
    }

    /**
     * Set the value of [product_id] column.
     *
     * @param int|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setProductId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->product_id !== $v) {
            $this->product_id = $v;
            $this->modifiedColumns[DraftProductTableMap::COL_PRODUCT_ID] = true;
        }

        if ($this->aProduct !== null && $this->aProduct->getId() !== $v) {
            $this->aProduct = null;
        }

        return $this;
    }

    /**
     * Set the value of [category_id] column.
     *
     * @param int $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setCategoryId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->category_id !== $v) {
            $this->category_id = $v;
            $this->modifiedColumns[DraftProductTableMap::COL_CATEGORY_ID] = true;
        }

        if ($this->aCategory !== null && $this->aCategory->getId() !== $v) {
            $this->aCategory = null;
        }

        return $this;
    }

    /**
     * Set the value of [brand_id] column.
     *
     * @param int $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setBrandId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->brand_id !== $v) {
            $this->brand_id = $v;
            $this->modifiedColumns[DraftProductTableMap::COL_BRAND_ID] = true;
        }

        if ($this->aBrand !== null && $this->aBrand->getId() !== $v) {
            $this->aBrand = null;
        }

        return $this;
    }

    /**
     * Set the value of [customer_id] column.
     *
     * @param int $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setCustomerId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->customer_id !== $v) {
            $this->customer_id = $v;
            $this->modifiedColumns[DraftProductTableMap::COL_CUSTOMER_ID] = true;
        }

        if ($this->aCustomer !== null && $this->aCustomer->getId() !== $v) {
            $this->aCustomer = null;
        }

        return $this;
    }

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return bool Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues(): bool
    {
            if ($this->special !== 'N') {
                return false;
            }

            if ($this->active !== 'Y') {
                return false;
            }

        // otherwise, everything was equal, so return TRUE
        return true;
    }

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by DataFetcher->fetch().
     * @param int $startcol 0-based offset column which indicates which resultset column to start with.
     * @param bool $rehydrate Whether this object is being re-hydrated from the database.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                  One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                            TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @return int next starting column
     * @throws \Propel\Runtime\Exception\PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate(array $row, int $startcol = 0, bool $rehydrate = false, string $indexType = TableMap::TYPE_NUM): int
    {
        try {

            $col = $row[TableMap::TYPE_NUM == $indexType ? 0 + $startcol : DraftProductTableMap::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
            $this->id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 1 + $startcol : DraftProductTableMap::translateFieldName('Title', TableMap::TYPE_PHPNAME, $indexType)];
            $this->title = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 2 + $startcol : DraftProductTableMap::translateFieldName('Desc', TableMap::TYPE_PHPNAME, $indexType)];
            $this->desc = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 3 + $startcol : DraftProductTableMap::translateFieldName('ShortDesc', TableMap::TYPE_PHPNAME, $indexType)];
            $this->short_desc = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 4 + $startcol : DraftProductTableMap::translateFieldName('Article', TableMap::TYPE_PHPNAME, $indexType)];
            $this->article = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 5 + $startcol : DraftProductTableMap::translateFieldName('Price', TableMap::TYPE_PHPNAME, $indexType)];
            $this->price = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 6 + $startcol : DraftProductTableMap::translateFieldName('Weight', TableMap::TYPE_PHPNAME, $indexType)];
            $this->weight = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 7 + $startcol : DraftProductTableMap::translateFieldName('Img', TableMap::TYPE_PHPNAME, $indexType)];
            $this->img = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 8 + $startcol : DraftProductTableMap::translateFieldName('Special', TableMap::TYPE_PHPNAME, $indexType)];
            $this->special = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 9 + $startcol : DraftProductTableMap::translateFieldName('Active', TableMap::TYPE_PHPNAME, $indexType)];
            $this->active = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 10 + $startcol : DraftProductTableMap::translateFieldName('MtTitle', TableMap::TYPE_PHPNAME, $indexType)];
            $this->mt_title = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 11 + $startcol : DraftProductTableMap::translateFieldName('MtDescription', TableMap::TYPE_PHPNAME, $indexType)];
            $this->mt_description = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 12 + $startcol : DraftProductTableMap::translateFieldName('MtKeywords', TableMap::TYPE_PHPNAME, $indexType)];
            $this->mt_keywords = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 13 + $startcol : DraftProductTableMap::translateFieldName('Remains', TableMap::TYPE_PHPNAME, $indexType)];
            $this->remains = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 14 + $startcol : DraftProductTableMap::translateFieldName('dateUpdate', TableMap::TYPE_PHPNAME, $indexType)];
            if ($col === '0000-00-00 00:00:00') {
                $col = null;
            }
            $this->udate = (null !== $col) ? PropelDateTime::newInstance($col, null, 'DateTime') : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 15 + $startcol : DraftProductTableMap::translateFieldName('dateCreate', TableMap::TYPE_PHPNAME, $indexType)];
            if ($col === '0000-00-00 00:00:00') {
                $col = null;
            }
            $this->cdate = (null !== $col) ? PropelDateTime::newInstance($col, null, 'DateTime') : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 16 + $startcol : DraftProductTableMap::translateFieldName('datePublic', TableMap::TYPE_PHPNAME, $indexType)];
            if ($col === '0000-00-00 00:00:00') {
                $col = null;
            }
            $this->pdate = (null !== $col) ? PropelDateTime::newInstance($col, null, 'DateTime') : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 17 + $startcol : DraftProductTableMap::translateFieldName('Ref', TableMap::TYPE_PHPNAME, $indexType)];
            $this->ref = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 18 + $startcol : DraftProductTableMap::translateFieldName('MinQuality', TableMap::TYPE_PHPNAME, $indexType)];
            $this->min_quality = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 19 + $startcol : DraftProductTableMap::translateFieldName('Seazon', TableMap::TYPE_PHPNAME, $indexType)];
            $this->seazon = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 20 + $startcol : DraftProductTableMap::translateFieldName('ProductId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->product_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 21 + $startcol : DraftProductTableMap::translateFieldName('CategoryId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->category_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 22 + $startcol : DraftProductTableMap::translateFieldName('BrandId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->brand_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 23 + $startcol : DraftProductTableMap::translateFieldName('CustomerId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->customer_id = (null !== $col) ? (int) $col : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 24; // 24 = DraftProductTableMap::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException(sprintf('Error populating %s object', '\\Shop\\Infrastructure\\Models\\DraftProduct\\DraftProduct'), 0, $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws \Propel\Runtime\Exception\PropelException
     * @return void
     */
    public function ensureConsistency(): void
    {
        if ($this->aProduct !== null && $this->product_id !== $this->aProduct->getId()) {
            $this->aProduct = null;
        }
        if ($this->aCategory !== null && $this->category_id !== $this->aCategory->getId()) {
            $this->aCategory = null;
        }
        if ($this->aBrand !== null && $this->brand_id !== $this->aBrand->getId()) {
            $this->aBrand = null;
        }
        if ($this->aCustomer !== null && $this->customer_id !== $this->aCustomer->getId()) {
            $this->aCustomer = null;
        }
    }

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param bool $deep (optional) Whether to also de-associated any related objects.
     * @param ConnectionInterface $con (optional) The ConnectionInterface connection to use.
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload(bool $deep = false, ?ConnectionInterface $con = null): void
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(DraftProductTableMap::DATABASE_NAME);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $dataFetcher = ChildDraftProductQuery::create(null, $this->buildPkeyCriteria())->setFormatter(ModelCriteria::FORMAT_STATEMENT)->find($con);
        $row = $dataFetcher->fetch();
        $dataFetcher->close();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true, $dataFetcher->getIndexType()); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aProduct = null;
            $this->aCategory = null;
            $this->aBrand = null;
            $this->aCustomer = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param ConnectionInterface $con
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     * @see DraftProduct::setDeleted()
     * @see DraftProduct::isDeleted()
     */
    public function delete(?ConnectionInterface $con = null): void
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(DraftProductTableMap::DATABASE_NAME);
        }

        $con->transaction(function () use ($con) {
            $deleteQuery = ChildDraftProductQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $this->setDeleted(true);
            }
        });
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param ConnectionInterface $con
     * @return int The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws \Propel\Runtime\Exception\PropelException
     * @see doSave()
     */
    public function save(?ConnectionInterface $con = null): int
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($this->alreadyInSave) {
            return 0;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(DraftProductTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con) {
            $ret = $this->preSave($con);
            $isInsert = $this->isNew();
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                DraftProductTableMap::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }

            return $affectedRows;
        });
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param ConnectionInterface $con
     * @return int The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws \Propel\Runtime\Exception\PropelException
     * @see save()
     */
    protected function doSave(ConnectionInterface $con): int
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their corresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aProduct !== null) {
                if ($this->aProduct->isModified() || $this->aProduct->isNew()) {
                    $affectedRows += $this->aProduct->save($con);
                }
                $this->setProduct($this->aProduct);
            }

            if ($this->aCategory !== null) {
                if ($this->aCategory->isModified() || $this->aCategory->isNew()) {
                    $affectedRows += $this->aCategory->save($con);
                }
                $this->setCategory($this->aCategory);
            }

            if ($this->aBrand !== null) {
                if ($this->aBrand->isModified() || $this->aBrand->isNew()) {
                    $affectedRows += $this->aBrand->save($con);
                }
                $this->setBrand($this->aBrand);
            }

            if ($this->aCustomer !== null) {
                if ($this->aCustomer->isModified() || $this->aCustomer->isNew()) {
                    $affectedRows += $this->aCustomer->save($con);
                }
                $this->setCustomer($this->aCustomer);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                    $affectedRows += 1;
                } else {
                    $affectedRows += $this->doUpdate($con);
                }
                $this->resetModified();
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    }

    /**
     * Insert the row in the database.
     *
     * @param ConnectionInterface $con
     *
     * @throws \Propel\Runtime\Exception\PropelException
     * @see doSave()
     */
    protected function doInsert(ConnectionInterface $con): void
    {
        $modifiedColumns = [];
        $index = 0;

        $this->modifiedColumns[DraftProductTableMap::COL_ID] = true;

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(DraftProductTableMap::COL_ID)) {
            $modifiedColumns[':p' . $index++]  = '`id`';
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_TITLE)) {
            $modifiedColumns[':p' . $index++]  = '`title`';
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_DESC)) {
            $modifiedColumns[':p' . $index++]  = '`desc`';
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_SHORT_DESC)) {
            $modifiedColumns[':p' . $index++]  = '`short_desc`';
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_ARTICLE)) {
            $modifiedColumns[':p' . $index++]  = '`article`';
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_PRICE)) {
            $modifiedColumns[':p' . $index++]  = '`price`';
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_WEIGHT)) {
            $modifiedColumns[':p' . $index++]  = '`weight`';
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_IMG)) {
            $modifiedColumns[':p' . $index++]  = '`img`';
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_SPECIAL)) {
            $modifiedColumns[':p' . $index++]  = '`special`';
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_ACTIVE)) {
            $modifiedColumns[':p' . $index++]  = '`active`';
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_MT_TITLE)) {
            $modifiedColumns[':p' . $index++]  = '`mt_title`';
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_MT_DESCRIPTION)) {
            $modifiedColumns[':p' . $index++]  = '`mt_description`';
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_MT_KEYWORDS)) {
            $modifiedColumns[':p' . $index++]  = '`mt_keywords`';
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_REMAINS)) {
            $modifiedColumns[':p' . $index++]  = '`remains`';
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_UDATE)) {
            $modifiedColumns[':p' . $index++]  = '`udate`';
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_CDATE)) {
            $modifiedColumns[':p' . $index++]  = '`cdate`';
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_PDATE)) {
            $modifiedColumns[':p' . $index++]  = '`pdate`';
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_REF)) {
            $modifiedColumns[':p' . $index++]  = '`ref`';
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_MIN_QUALITY)) {
            $modifiedColumns[':p' . $index++]  = '`min_quality`';
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_SEAZON)) {
            $modifiedColumns[':p' . $index++]  = '`seazon`';
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_PRODUCT_ID)) {
            $modifiedColumns[':p' . $index++]  = '`product_id`';
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_CATEGORY_ID)) {
            $modifiedColumns[':p' . $index++]  = '`category_id`';
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_BRAND_ID)) {
            $modifiedColumns[':p' . $index++]  = '`brand_id`';
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_CUSTOMER_ID)) {
            $modifiedColumns[':p' . $index++]  = '`customer_id`';
        }

        $sql = sprintf(
            'INSERT INTO `shop_product_drafts` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`id`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`title`':
                        $stmt->bindValue($identifier, $this->title, PDO::PARAM_STR);
                        break;
                    case '`desc`':
                        $stmt->bindValue($identifier, $this->desc, PDO::PARAM_STR);
                        break;
                    case '`short_desc`':
                        $stmt->bindValue($identifier, $this->short_desc, PDO::PARAM_STR);
                        break;
                    case '`article`':
                        $stmt->bindValue($identifier, $this->article, PDO::PARAM_STR);
                        break;
                    case '`price`':
                        $stmt->bindValue($identifier, $this->price, PDO::PARAM_STR);
                        break;
                    case '`weight`':
                        $stmt->bindValue($identifier, $this->weight, PDO::PARAM_STR);
                        break;
                    case '`img`':
                        $stmt->bindValue($identifier, $this->img, PDO::PARAM_STR);
                        break;
                    case '`special`':
                        $stmt->bindValue($identifier, $this->special, PDO::PARAM_STR);
                        break;
                    case '`active`':
                        $stmt->bindValue($identifier, $this->active, PDO::PARAM_STR);
                        break;
                    case '`mt_title`':
                        $stmt->bindValue($identifier, $this->mt_title, PDO::PARAM_STR);
                        break;
                    case '`mt_description`':
                        $stmt->bindValue($identifier, $this->mt_description, PDO::PARAM_STR);
                        break;
                    case '`mt_keywords`':
                        $stmt->bindValue($identifier, $this->mt_keywords, PDO::PARAM_STR);
                        break;
                    case '`remains`':
                        $stmt->bindValue($identifier, $this->remains, PDO::PARAM_STR);
                        break;
                    case '`udate`':
                        $stmt->bindValue($identifier, $this->udate ? $this->udate->format("Y-m-d H:i:s.u") : null, PDO::PARAM_STR);
                        break;
                    case '`cdate`':
                        $stmt->bindValue($identifier, $this->cdate ? $this->cdate->format("Y-m-d H:i:s.u") : null, PDO::PARAM_STR);
                        break;
                    case '`pdate`':
                        $stmt->bindValue($identifier, $this->pdate ? $this->pdate->format("Y-m-d H:i:s.u") : null, PDO::PARAM_STR);
                        break;
                    case '`ref`':
                        $stmt->bindValue($identifier, $this->ref, PDO::PARAM_INT);
                        break;
                    case '`min_quality`':
                        $stmt->bindValue($identifier, $this->min_quality, PDO::PARAM_STR);
                        break;
                    case '`seazon`':
                        $stmt->bindValue($identifier, $this->seazon, PDO::PARAM_STR);
                        break;
                    case '`product_id`':
                        $stmt->bindValue($identifier, $this->product_id, PDO::PARAM_INT);
                        break;
                    case '`category_id`':
                        $stmt->bindValue($identifier, $this->category_id, PDO::PARAM_INT);
                        break;
                    case '`brand_id`':
                        $stmt->bindValue($identifier, $this->brand_id, PDO::PARAM_INT);
                        break;
                    case '`customer_id`':
                        $stmt->bindValue($identifier, $this->customer_id, PDO::PARAM_INT);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), 0, $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', 0, $e);
        }
        if ($pk !== null) {
            $this->setId($pk);
        }

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param ConnectionInterface $con
     *
     * @return int Number of updated rows
     * @see doSave()
     */
    protected function doUpdate(ConnectionInterface $con): int
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();

        return $selectCriteria->doUpdate($valuesCriteria, $con);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                     TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                     Defaults to TableMap::TYPE_PHPNAME.
     * @return mixed Value of field.
     */
    public function getByName(string $name, string $type = TableMap::TYPE_PHPNAME)
    {
        $pos = DraftProductTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos Position in XML schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition(int $pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();

            case 1:
                return $this->getTitle();

            case 2:
                return $this->getDesc();

            case 3:
                return $this->getShortDesc();

            case 4:
                return $this->getArticle();

            case 5:
                return $this->getPrice();

            case 6:
                return $this->getWeight();

            case 7:
                return $this->getImg();

            case 8:
                return $this->getSpecial();

            case 9:
                return $this->getActive();

            case 10:
                return $this->getMtTitle();

            case 11:
                return $this->getMtDescription();

            case 12:
                return $this->getMtKeywords();

            case 13:
                return $this->getRemains();

            case 14:
                return $this->getdateUpdate();

            case 15:
                return $this->getdateCreate();

            case 16:
                return $this->getdatePublic();

            case 17:
                return $this->getRef();

            case 18:
                return $this->getMinQuality();

            case 19:
                return $this->getSeazon();

            case 20:
                return $this->getProductId();

            case 21:
                return $this->getCategoryId();

            case 22:
                return $this->getBrandId();

            case 23:
                return $this->getCustomerId();

            default:
                return null;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param string $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     *                    TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                    Defaults to TableMap::TYPE_PHPNAME.
     * @param bool $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to TRUE.
     * @param array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param bool $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array An associative array containing the field names (as keys) and field values
     */
    public function toArray(string $keyType = TableMap::TYPE_PHPNAME, bool $includeLazyLoadColumns = true, array $alreadyDumpedObjects = [], bool $includeForeignObjects = false): array
    {
        if (isset($alreadyDumpedObjects['DraftProduct'][$this->hashCode()])) {
            return ['*RECURSION*'];
        }
        $alreadyDumpedObjects['DraftProduct'][$this->hashCode()] = true;
        $keys = DraftProductTableMap::getFieldNames($keyType);
        $result = [
            $keys[0] => $this->getId(),
            $keys[1] => $this->getTitle(),
            $keys[2] => $this->getDesc(),
            $keys[3] => $this->getShortDesc(),
            $keys[4] => $this->getArticle(),
            $keys[5] => $this->getPrice(),
            $keys[6] => $this->getWeight(),
            $keys[7] => $this->getImg(),
            $keys[8] => $this->getSpecial(),
            $keys[9] => $this->getActive(),
            $keys[10] => $this->getMtTitle(),
            $keys[11] => $this->getMtDescription(),
            $keys[12] => $this->getMtKeywords(),
            $keys[13] => $this->getRemains(),
            $keys[14] => $this->getdateUpdate(),
            $keys[15] => $this->getdateCreate(),
            $keys[16] => $this->getdatePublic(),
            $keys[17] => $this->getRef(),
            $keys[18] => $this->getMinQuality(),
            $keys[19] => $this->getSeazon(),
            $keys[20] => $this->getProductId(),
            $keys[21] => $this->getCategoryId(),
            $keys[22] => $this->getBrandId(),
            $keys[23] => $this->getCustomerId(),
        ];
        if ($result[$keys[14]] instanceof \DateTimeInterface) {
            $result[$keys[14]] = $result[$keys[14]]->format('Y-m-d H:i:s.u');
        }

        if ($result[$keys[15]] instanceof \DateTimeInterface) {
            $result[$keys[15]] = $result[$keys[15]]->format('Y-m-d H:i:s.u');
        }

        if ($result[$keys[16]] instanceof \DateTimeInterface) {
            $result[$keys[16]] = $result[$keys[16]]->format('Y-m-d H:i:s.u');
        }

        $virtualColumns = $this->virtualColumns;
        foreach ($virtualColumns as $key => $virtualColumn) {
            $result[$key] = $virtualColumn;
        }

        if ($includeForeignObjects) {
            if (null !== $this->aProduct) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'product';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_products';
                        break;
                    default:
                        $key = 'Product';
                }

                $result[$key] = $this->aProduct->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aCategory) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'category';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_categories';
                        break;
                    default:
                        $key = 'Category';
                }

                $result[$key] = $this->aCategory->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aBrand) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'brand';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_brands';
                        break;
                    default:
                        $key = 'Brand';
                }

                $result[$key] = $this->aBrand->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aCustomer) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'customer';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_customer';
                        break;
                    default:
                        $key = 'Customer';
                }

                $result[$key] = $this->aCustomer->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                Defaults to TableMap::TYPE_PHPNAME.
     * @return $this
     */
    public function setByName(string $name, $value, string $type = TableMap::TYPE_PHPNAME)
    {
        $pos = DraftProductTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);

        $this->setByPosition($pos, $value);

        return $this;
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return $this
     */
    public function setByPosition(int $pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setTitle($value);
                break;
            case 2:
                $this->setDesc($value);
                break;
            case 3:
                $this->setShortDesc($value);
                break;
            case 4:
                $this->setArticle($value);
                break;
            case 5:
                $this->setPrice($value);
                break;
            case 6:
                $this->setWeight($value);
                break;
            case 7:
                $this->setImg($value);
                break;
            case 8:
                $this->setSpecial($value);
                break;
            case 9:
                $this->setActive($value);
                break;
            case 10:
                $this->setMtTitle($value);
                break;
            case 11:
                $this->setMtDescription($value);
                break;
            case 12:
                $this->setMtKeywords($value);
                break;
            case 13:
                $this->setRemains($value);
                break;
            case 14:
                $this->setdateUpdate($value);
                break;
            case 15:
                $this->setdateCreate($value);
                break;
            case 16:
                $this->setdatePublic($value);
                break;
            case 17:
                $this->setRef($value);
                break;
            case 18:
                $this->setMinQuality($value);
                break;
            case 19:
                $this->setSeazon($value);
                break;
            case 20:
                $this->setProductId($value);
                break;
            case 21:
                $this->setCategoryId($value);
                break;
            case 22:
                $this->setBrandId($value);
                break;
            case 23:
                $this->setCustomerId($value);
                break;
        } // switch()

        return $this;
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param array $arr An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return $this
     */
    public function fromArray(array $arr, string $keyType = TableMap::TYPE_PHPNAME)
    {
        $keys = DraftProductTableMap::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) {
            $this->setId($arr[$keys[0]]);
        }
        if (array_key_exists($keys[1], $arr)) {
            $this->setTitle($arr[$keys[1]]);
        }
        if (array_key_exists($keys[2], $arr)) {
            $this->setDesc($arr[$keys[2]]);
        }
        if (array_key_exists($keys[3], $arr)) {
            $this->setShortDesc($arr[$keys[3]]);
        }
        if (array_key_exists($keys[4], $arr)) {
            $this->setArticle($arr[$keys[4]]);
        }
        if (array_key_exists($keys[5], $arr)) {
            $this->setPrice($arr[$keys[5]]);
        }
        if (array_key_exists($keys[6], $arr)) {
            $this->setWeight($arr[$keys[6]]);
        }
        if (array_key_exists($keys[7], $arr)) {
            $this->setImg($arr[$keys[7]]);
        }
        if (array_key_exists($keys[8], $arr)) {
            $this->setSpecial($arr[$keys[8]]);
        }
        if (array_key_exists($keys[9], $arr)) {
            $this->setActive($arr[$keys[9]]);
        }
        if (array_key_exists($keys[10], $arr)) {
            $this->setMtTitle($arr[$keys[10]]);
        }
        if (array_key_exists($keys[11], $arr)) {
            $this->setMtDescription($arr[$keys[11]]);
        }
        if (array_key_exists($keys[12], $arr)) {
            $this->setMtKeywords($arr[$keys[12]]);
        }
        if (array_key_exists($keys[13], $arr)) {
            $this->setRemains($arr[$keys[13]]);
        }
        if (array_key_exists($keys[14], $arr)) {
            $this->setdateUpdate($arr[$keys[14]]);
        }
        if (array_key_exists($keys[15], $arr)) {
            $this->setdateCreate($arr[$keys[15]]);
        }
        if (array_key_exists($keys[16], $arr)) {
            $this->setdatePublic($arr[$keys[16]]);
        }
        if (array_key_exists($keys[17], $arr)) {
            $this->setRef($arr[$keys[17]]);
        }
        if (array_key_exists($keys[18], $arr)) {
            $this->setMinQuality($arr[$keys[18]]);
        }
        if (array_key_exists($keys[19], $arr)) {
            $this->setSeazon($arr[$keys[19]]);
        }
        if (array_key_exists($keys[20], $arr)) {
            $this->setProductId($arr[$keys[20]]);
        }
        if (array_key_exists($keys[21], $arr)) {
            $this->setCategoryId($arr[$keys[21]]);
        }
        if (array_key_exists($keys[22], $arr)) {
            $this->setBrandId($arr[$keys[22]]);
        }
        if (array_key_exists($keys[23], $arr)) {
            $this->setCustomerId($arr[$keys[23]]);
        }

        return $this;
    }

     /**
     * Populate the current object from a string, using a given parser format
     * <code>
     * $book = new Book();
     * $book->importFrom('JSON', '{"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param mixed $parser A AbstractParser instance,
     *                       or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param string $data The source data to import from
     * @param string $keyType The type of keys the array uses.
     *
     * @return $this The current object, for fluid interface
     */
    public function importFrom($parser, string $data, string $keyType = TableMap::TYPE_PHPNAME)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        $this->fromArray($parser->toArray($data), $keyType);

        return $this;
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return \Propel\Runtime\ActiveQuery\Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria(): Criteria
    {
        $criteria = new Criteria(DraftProductTableMap::DATABASE_NAME);

        if ($this->isColumnModified(DraftProductTableMap::COL_ID)) {
            $criteria->add(DraftProductTableMap::COL_ID, $this->id);
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_TITLE)) {
            $criteria->add(DraftProductTableMap::COL_TITLE, $this->title);
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_DESC)) {
            $criteria->add(DraftProductTableMap::COL_DESC, $this->desc);
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_SHORT_DESC)) {
            $criteria->add(DraftProductTableMap::COL_SHORT_DESC, $this->short_desc);
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_ARTICLE)) {
            $criteria->add(DraftProductTableMap::COL_ARTICLE, $this->article);
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_PRICE)) {
            $criteria->add(DraftProductTableMap::COL_PRICE, $this->price);
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_WEIGHT)) {
            $criteria->add(DraftProductTableMap::COL_WEIGHT, $this->weight);
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_IMG)) {
            $criteria->add(DraftProductTableMap::COL_IMG, $this->img);
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_SPECIAL)) {
            $criteria->add(DraftProductTableMap::COL_SPECIAL, $this->special);
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_ACTIVE)) {
            $criteria->add(DraftProductTableMap::COL_ACTIVE, $this->active);
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_MT_TITLE)) {
            $criteria->add(DraftProductTableMap::COL_MT_TITLE, $this->mt_title);
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_MT_DESCRIPTION)) {
            $criteria->add(DraftProductTableMap::COL_MT_DESCRIPTION, $this->mt_description);
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_MT_KEYWORDS)) {
            $criteria->add(DraftProductTableMap::COL_MT_KEYWORDS, $this->mt_keywords);
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_REMAINS)) {
            $criteria->add(DraftProductTableMap::COL_REMAINS, $this->remains);
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_UDATE)) {
            $criteria->add(DraftProductTableMap::COL_UDATE, $this->udate);
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_CDATE)) {
            $criteria->add(DraftProductTableMap::COL_CDATE, $this->cdate);
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_PDATE)) {
            $criteria->add(DraftProductTableMap::COL_PDATE, $this->pdate);
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_REF)) {
            $criteria->add(DraftProductTableMap::COL_REF, $this->ref);
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_MIN_QUALITY)) {
            $criteria->add(DraftProductTableMap::COL_MIN_QUALITY, $this->min_quality);
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_SEAZON)) {
            $criteria->add(DraftProductTableMap::COL_SEAZON, $this->seazon);
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_PRODUCT_ID)) {
            $criteria->add(DraftProductTableMap::COL_PRODUCT_ID, $this->product_id);
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_CATEGORY_ID)) {
            $criteria->add(DraftProductTableMap::COL_CATEGORY_ID, $this->category_id);
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_BRAND_ID)) {
            $criteria->add(DraftProductTableMap::COL_BRAND_ID, $this->brand_id);
        }
        if ($this->isColumnModified(DraftProductTableMap::COL_CUSTOMER_ID)) {
            $criteria->add(DraftProductTableMap::COL_CUSTOMER_ID, $this->customer_id);
        }

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether they have been modified.
     *
     * @throws LogicException if no primary key is defined
     *
     * @return \Propel\Runtime\ActiveQuery\Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria(): Criteria
    {
        $criteria = ChildDraftProductQuery::create();
        $criteria->add(DraftProductTableMap::COL_ID, $this->id);

        return $criteria;
    }

    /**
     * If the primary key is not null, return the hashcode of the
     * primary key. Otherwise, return the hash code of the object.
     *
     * @return int|string Hashcode
     */
    public function hashCode()
    {
        $validPk = null !== $this->getId();

        $validPrimaryKeyFKs = 0;
        $primaryKeyFKs = [];

        if ($validPk) {
            return crc32(json_encode($this->getPrimaryKey(), JSON_UNESCAPED_UNICODE));
        } elseif ($validPrimaryKeyFKs) {
            return crc32(json_encode($primaryKeyFKs, JSON_UNESCAPED_UNICODE));
        }

        return spl_object_hash($this);
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param int|null $key Primary key.
     * @return void
     */
    public function setPrimaryKey(?int $key = null): void
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     *
     * @return bool
     */
    public function isPrimaryKeyNull(): bool
    {
        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of \Shop\Infrastructure\Models\DraftProduct\DraftProduct (or compatible) type.
     * @param bool $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param bool $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws \Propel\Runtime\Exception\PropelException
     * @return void
     */
    public function copyInto(object $copyObj, bool $deepCopy = false, bool $makeNew = true): void
    {
        $copyObj->setTitle($this->getTitle());
        $copyObj->setDesc($this->getDesc());
        $copyObj->setShortDesc($this->getShortDesc());
        $copyObj->setArticle($this->getArticle());
        $copyObj->setPrice($this->getPrice());
        $copyObj->setWeight($this->getWeight());
        $copyObj->setImg($this->getImg());
        $copyObj->setSpecial($this->getSpecial());
        $copyObj->setActive($this->getActive());
        $copyObj->setMtTitle($this->getMtTitle());
        $copyObj->setMtDescription($this->getMtDescription());
        $copyObj->setMtKeywords($this->getMtKeywords());
        $copyObj->setRemains($this->getRemains());
        $copyObj->setdateUpdate($this->getdateUpdate());
        $copyObj->setdateCreate($this->getdateCreate());
        $copyObj->setdatePublic($this->getdatePublic());
        $copyObj->setRef($this->getRef());
        $copyObj->setMinQuality($this->getMinQuality());
        $copyObj->setSeazon($this->getSeazon());
        $copyObj->setProductId($this->getProductId());
        $copyObj->setCategoryId($this->getCategoryId());
        $copyObj->setBrandId($this->getBrandId());
        $copyObj->setCustomerId($this->getCustomerId());
        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param bool $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return \Shop\Infrastructure\Models\DraftProduct\DraftProduct Clone of current object.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function copy(bool $deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Declares an association between this object and a Product object.
     *
     * @param Product|null $v
     * @return $this The current object (for fluent API support)
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function setProduct(Product $v = null)
    {
        if ($v === null) {
            $this->setProductId(NULL);
        } else {
            $this->setProductId($v->getId());
        }

        $this->aProduct = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Product object, it will not be re-added.
        if ($v !== null) {
            $v->addDraftProduct($this);
        }


        return $this;
    }


    /**
     * Get the associated Product object
     *
     * @param ConnectionInterface $con Optional Connection object.
     * @return Product|null The associated Product object.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getProduct(?ConnectionInterface $con = null)
    {
        if ($this->aProduct === null && ($this->product_id != 0)) {
            $this->aProduct = ProductQuery::create()->findPk($this->product_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aProduct->addDraftProducts($this);
             */
        }

        return $this->aProduct;
    }

    /**
     * Declares an association between this object and a Category object.
     *
     * @param Category $v
     * @return $this The current object (for fluent API support)
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function setCategory(Category $v = null)
    {
        if ($v === null) {
            $this->setCategoryId(NULL);
        } else {
            $this->setCategoryId($v->getId());
        }

        $this->aCategory = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Category object, it will not be re-added.
        if ($v !== null) {
            $v->addDraftProduct($this);
        }


        return $this;
    }


    /**
     * Get the associated Category object
     *
     * @param ConnectionInterface $con Optional Connection object.
     * @return Category The associated Category object.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getCategory(?ConnectionInterface $con = null)
    {
        if ($this->aCategory === null && ($this->category_id != 0)) {
            $this->aCategory = CategoryQuery::create()->findPk($this->category_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aCategory->addDraftProducts($this);
             */
        }

        return $this->aCategory;
    }

    /**
     * Declares an association between this object and a Brand object.
     *
     * @param Brand $v
     * @return $this The current object (for fluent API support)
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function setBrand(Brand $v = null)
    {
        if ($v === null) {
            $this->setBrandId(NULL);
        } else {
            $this->setBrandId($v->getId());
        }

        $this->aBrand = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Brand object, it will not be re-added.
        if ($v !== null) {
            $v->addDraftProduct($this);
        }


        return $this;
    }


    /**
     * Get the associated Brand object
     *
     * @param ConnectionInterface $con Optional Connection object.
     * @return Brand The associated Brand object.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getBrand(?ConnectionInterface $con = null)
    {
        if ($this->aBrand === null && ($this->brand_id != 0)) {
            $this->aBrand = BrandQuery::create()->findPk($this->brand_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aBrand->addDraftProducts($this);
             */
        }

        return $this->aBrand;
    }

    /**
     * Declares an association between this object and a Customer object.
     *
     * @param Customer $v
     * @return $this The current object (for fluent API support)
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function setCustomer(Customer $v = null)
    {
        if ($v === null) {
            $this->setCustomerId(NULL);
        } else {
            $this->setCustomerId($v->getId());
        }

        $this->aCustomer = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Customer object, it will not be re-added.
        if ($v !== null) {
            $v->addDraftProduct($this);
        }


        return $this;
    }


    /**
     * Get the associated Customer object
     *
     * @param ConnectionInterface $con Optional Connection object.
     * @return Customer The associated Customer object.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getCustomer(?ConnectionInterface $con = null)
    {
        if ($this->aCustomer === null && ($this->customer_id != 0)) {
            $this->aCustomer = CustomerQuery::create()->findPk($this->customer_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aCustomer->addDraftProducts($this);
             */
        }

        return $this->aCustomer;
    }

    /**
     * Clears the current object, sets all attributes to their default values and removes
     * outgoing references as well as back-references (from other objects to this one. Results probably in a database
     * change of those foreign objects when you call `save` there).
     *
     * @return $this
     */
    public function clear()
    {
        if (null !== $this->aProduct) {
            $this->aProduct->removeDraftProduct($this);
        }
        if (null !== $this->aCategory) {
            $this->aCategory->removeDraftProduct($this);
        }
        if (null !== $this->aBrand) {
            $this->aBrand->removeDraftProduct($this);
        }
        if (null !== $this->aCustomer) {
            $this->aCustomer->removeDraftProduct($this);
        }
        $this->id = null;
        $this->title = null;
        $this->desc = null;
        $this->short_desc = null;
        $this->article = null;
        $this->price = null;
        $this->weight = null;
        $this->img = null;
        $this->special = null;
        $this->active = null;
        $this->mt_title = null;
        $this->mt_description = null;
        $this->mt_keywords = null;
        $this->remains = null;
        $this->udate = null;
        $this->cdate = null;
        $this->pdate = null;
        $this->ref = null;
        $this->min_quality = null;
        $this->seazon = null;
        $this->product_id = null;
        $this->category_id = null;
        $this->brand_id = null;
        $this->customer_id = null;
        $this->alreadyInSave = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);

        return $this;
    }

    /**
     * Resets all references and back-references to other model objects or collections of model objects.
     *
     * This method is used to reset all php object references (not the actual reference in the database).
     * Necessary for object serialisation.
     *
     * @param bool $deep Whether to also clear the references on all referrer objects.
     * @return $this
     */
    public function clearAllReferences(bool $deep = false)
    {
        if ($deep) {
        } // if ($deep)

        $this->aProduct = null;
        $this->aCategory = null;
        $this->aBrand = null;
        $this->aCustomer = null;
        return $this;
    }

    /**
     * Return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(DraftProductTableMap::DEFAULT_STRING_FORMAT);
    }

    /**
     * Code to be run before persisting the object
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preSave(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after persisting the object
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postSave(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before inserting to database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preInsert(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after inserting to database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postInsert(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before updating the object in database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preUpdate(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after updating the object in database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postUpdate(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before deleting the object in database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preDelete(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after deleting the object in database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postDelete(?ConnectionInterface $con = null): void
    {
            }


    /**
     * Derived method to catches calls to undefined methods.
     *
     * Provides magic import/export method support (fromXML()/toXML(), fromYAML()/toYAML(), etc.).
     * Allows to define default __call() behavior if you overwrite __call()
     *
     * @param string $name
     * @param mixed $params
     *
     * @return array|string
     */
    public function __call($name, $params)
    {
        if (0 === strpos($name, 'get')) {
            $virtualColumn = substr($name, 3);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }

            $virtualColumn = lcfirst($virtualColumn);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }
        }

        if (0 === strpos($name, 'from')) {
            $format = substr($name, 4);
            $inputData = $params[0];
            $keyType = $params[1] ?? TableMap::TYPE_PHPNAME;

            return $this->importFrom($format, $inputData, $keyType);
        }

        if (0 === strpos($name, 'to')) {
            $format = substr($name, 2);
            $includeLazyLoadColumns = $params[0] ?? true;
            $keyType = $params[1] ?? TableMap::TYPE_PHPNAME;

            return $this->exportTo($format, $includeLazyLoadColumns, $keyType);
        }

        throw new BadMethodCallException(sprintf('Call to undefined method: %s.', $name));
    }

}
