<?php

namespace Shop\Presentation\Modules\AdminClientGroups;


use ActiveTable\ColumnTable;
use Core\Form\ControlBuilder;
use Core\Helpers\Text;
use DiamondTable\TableFactory;
use Shop\Domain\CustomerGroup\Contracts\CustomerGroupEntityInterface;
use Shop\Infrastructure\Repositories\CustomerGroup\CustomerGroupCriteria;
use Shop\Infrastructure\Repositories\CustomerGroup\CustomerGroupRepository;

/**
 * Description of AdminClientGroups
 *
 * @author Diamond Code Generator
 */
class AdminClientGroups extends \Core\ModuleController
{


    protected $customerGroupRepository;
    protected $tableFactory;
    protected $controlBuilder;

    public function __construct(CustomerGroupRepository $customerGroupRepository,
                                TableFactory $tableFactory,
                                ControlBuilder $controlBuilder)
    {
        $this->customerGroupRepository = $customerGroupRepository;
        $this->controlBuilder = $controlBuilder;
        $this->tableFactory = $tableFactory;
    }


    public function process(): string
    {

        $table = $this->tableFactory->buildAdminTable($this->customerGroupRepository, CustomerGroupCriteria::create());

        $table
            ->setDefaultSortColumn('id','DESC')
            ->addColumn(
                (new ColumnTable('id', '№'))->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('name', 'Наименование'))
            )
            ->addColumn(
                (new ColumnTable('desc', 'Описание'))
                    ->setFormat($this, 'formatDesc')
            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setWidth(120)
                    ->setFormat($this->tableFactory, 'formatActions')
            );

        $table
            ->addField(
                $this->controlBuilder->buildInput('name')
            )
            ->addField(
                $this->controlBuilder
                    ->buildTextEditor("desc")
                    ->setHeight(200)
                    ->setCompact(true)
            )
            ;

        return $table->render();
    }

    /**
     * @param CustomerGroupEntityInterface $groupEntity
     * @return string
     */
    public function formatDesc(CustomerGroupEntityInterface $groupEntity): string
    {
        return Text::clearText((string)$groupEntity->getDesc());
    }

}