<?php

namespace Shop\Infrastructure\Models\State\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Infrastructure\Models\Order\Order;
use Shop\Infrastructure\Models\OrderItem\OrderItem;
use Shop\Infrastructure\Models\State\ShopStatesArchive as ChildShopStatesArchive;
use Shop\Infrastructure\Models\State\State as ChildState;
use Shop\Infrastructure\Models\State\StateQuery as ChildStateQuery;
use Shop\Infrastructure\Models\StateLog\StateLog;
use Shop\Infrastructure\Models\State\Map\StateTableMap;

/**
 * Base class that represents a query for the 'shop_states' table.
 *
 *
 *
 * @method     ChildStateQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildStateQuery orderByTitle($order = Criteria::ASC) Order by the title column
 * @method     ChildStateQuery orderByColor($order = Criteria::ASC) Order by the color column
 *
 * @method     ChildStateQuery groupById() Group by the id column
 * @method     ChildStateQuery groupByTitle() Group by the title column
 * @method     ChildStateQuery groupByColor() Group by the color column
 *
 * @method     ChildStateQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildStateQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildStateQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildStateQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildStateQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildStateQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildStateQuery leftJoinStateLogRelatedByOldStateId($relationAlias = null) Adds a LEFT JOIN clause to the query using the StateLogRelatedByOldStateId relation
 * @method     ChildStateQuery rightJoinStateLogRelatedByOldStateId($relationAlias = null) Adds a RIGHT JOIN clause to the query using the StateLogRelatedByOldStateId relation
 * @method     ChildStateQuery innerJoinStateLogRelatedByOldStateId($relationAlias = null) Adds a INNER JOIN clause to the query using the StateLogRelatedByOldStateId relation
 *
 * @method     ChildStateQuery joinWithStateLogRelatedByOldStateId($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the StateLogRelatedByOldStateId relation
 *
 * @method     ChildStateQuery leftJoinWithStateLogRelatedByOldStateId() Adds a LEFT JOIN clause and with to the query using the StateLogRelatedByOldStateId relation
 * @method     ChildStateQuery rightJoinWithStateLogRelatedByOldStateId() Adds a RIGHT JOIN clause and with to the query using the StateLogRelatedByOldStateId relation
 * @method     ChildStateQuery innerJoinWithStateLogRelatedByOldStateId() Adds a INNER JOIN clause and with to the query using the StateLogRelatedByOldStateId relation
 *
 * @method     ChildStateQuery leftJoinStateLogRelatedByNewStateId($relationAlias = null) Adds a LEFT JOIN clause to the query using the StateLogRelatedByNewStateId relation
 * @method     ChildStateQuery rightJoinStateLogRelatedByNewStateId($relationAlias = null) Adds a RIGHT JOIN clause to the query using the StateLogRelatedByNewStateId relation
 * @method     ChildStateQuery innerJoinStateLogRelatedByNewStateId($relationAlias = null) Adds a INNER JOIN clause to the query using the StateLogRelatedByNewStateId relation
 *
 * @method     ChildStateQuery joinWithStateLogRelatedByNewStateId($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the StateLogRelatedByNewStateId relation
 *
 * @method     ChildStateQuery leftJoinWithStateLogRelatedByNewStateId() Adds a LEFT JOIN clause and with to the query using the StateLogRelatedByNewStateId relation
 * @method     ChildStateQuery rightJoinWithStateLogRelatedByNewStateId() Adds a RIGHT JOIN clause and with to the query using the StateLogRelatedByNewStateId relation
 * @method     ChildStateQuery innerJoinWithStateLogRelatedByNewStateId() Adds a INNER JOIN clause and with to the query using the StateLogRelatedByNewStateId relation
 *
 * @method     ChildStateQuery leftJoinOrder($relationAlias = null) Adds a LEFT JOIN clause to the query using the Order relation
 * @method     ChildStateQuery rightJoinOrder($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Order relation
 * @method     ChildStateQuery innerJoinOrder($relationAlias = null) Adds a INNER JOIN clause to the query using the Order relation
 *
 * @method     ChildStateQuery joinWithOrder($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Order relation
 *
 * @method     ChildStateQuery leftJoinWithOrder() Adds a LEFT JOIN clause and with to the query using the Order relation
 * @method     ChildStateQuery rightJoinWithOrder() Adds a RIGHT JOIN clause and with to the query using the Order relation
 * @method     ChildStateQuery innerJoinWithOrder() Adds a INNER JOIN clause and with to the query using the Order relation
 *
 * @method     ChildStateQuery leftJoinOrderItem($relationAlias = null) Adds a LEFT JOIN clause to the query using the OrderItem relation
 * @method     ChildStateQuery rightJoinOrderItem($relationAlias = null) Adds a RIGHT JOIN clause to the query using the OrderItem relation
 * @method     ChildStateQuery innerJoinOrderItem($relationAlias = null) Adds a INNER JOIN clause to the query using the OrderItem relation
 *
 * @method     ChildStateQuery joinWithOrderItem($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the OrderItem relation
 *
 * @method     ChildStateQuery leftJoinWithOrderItem() Adds a LEFT JOIN clause and with to the query using the OrderItem relation
 * @method     ChildStateQuery rightJoinWithOrderItem() Adds a RIGHT JOIN clause and with to the query using the OrderItem relation
 * @method     ChildStateQuery innerJoinWithOrderItem() Adds a INNER JOIN clause and with to the query using the OrderItem relation
 *
 * @method     \Shop\Infrastructure\Models\StateLog\StateLogQuery|\Shop\Infrastructure\Models\Order\OrderQuery|\Shop\Infrastructure\Models\OrderItem\OrderItemQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildState findOne(ConnectionInterface $con = null) Return the first ChildState matching the query
 * @method     ChildState findOneOrCreate(ConnectionInterface $con = null) Return the first ChildState matching the query, or a new ChildState object populated from the query conditions when no match is found
 *
 * @method     ChildState findOneById(int $id) Return the first ChildState filtered by the id column
 * @method     ChildState findOneByTitle(string $title) Return the first ChildState filtered by the title column
 * @method     ChildState findOneByColor(string $color) Return the first ChildState filtered by the color column *

 * @method     ChildState requirePk($key, ConnectionInterface $con = null) Return the ChildState by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildState requireOne(ConnectionInterface $con = null) Return the first ChildState matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildState requireOneById(int $id) Return the first ChildState filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildState requireOneByTitle(string $title) Return the first ChildState filtered by the title column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildState requireOneByColor(string $color) Return the first ChildState filtered by the color column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildState[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildState objects based on current ModelCriteria
 * @method     ChildState[]|ObjectCollection findById(int $id) Return ChildState objects filtered by the id column
 * @method     ChildState[]|ObjectCollection findByTitle(string $title) Return ChildState objects filtered by the title column
 * @method     ChildState[]|ObjectCollection findByColor(string $color) Return ChildState objects filtered by the color column
 * @method     ChildState[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class StateQuery extends ModelCriteria
{

    // archivable behavior
    protected $archiveOnDelete = true;
protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Infrastructure\Models\State\Base\StateQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\State\\State', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildStateQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildStateQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildStateQuery) {
            return $criteria;
        }
        $query = new ChildStateQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildState|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(StateTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = StateTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildState A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `title`, `color` FROM `shop_states` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildState $obj */
            $obj = new ChildState();
            $obj->hydrate($row);
            StateTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildState|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildStateQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(StateTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildStateQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(StateTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStateQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(StateTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(StateTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StateTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the title column
     *
     * Example usage:
     * <code>
     * $query->filterByTitle('fooValue');   // WHERE title = 'fooValue'
     * $query->filterByTitle('%fooValue%', Criteria::LIKE); // WHERE title LIKE '%fooValue%'
     * </code>
     *
     * @param     string $title The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStateQuery The current query, for fluid interface
     */
    public function filterByTitle($title = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($title)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StateTableMap::COL_TITLE, $title, $comparison);
    }

    /**
     * Filter the query on the color column
     *
     * Example usage:
     * <code>
     * $query->filterByColor('fooValue');   // WHERE color = 'fooValue'
     * $query->filterByColor('%fooValue%', Criteria::LIKE); // WHERE color LIKE '%fooValue%'
     * </code>
     *
     * @param     string $color The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStateQuery The current query, for fluid interface
     */
    public function filterByColor($color = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($color)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StateTableMap::COL_COLOR, $color, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\StateLog\StateLog object
     *
     * @param \Shop\Infrastructure\Models\StateLog\StateLog|ObjectCollection $stateLog the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildStateQuery The current query, for fluid interface
     */
    public function filterByStateLogRelatedByOldStateId($stateLog, $comparison = null)
    {
        if ($stateLog instanceof \Shop\Infrastructure\Models\StateLog\StateLog) {
            return $this
                ->addUsingAlias(StateTableMap::COL_ID, $stateLog->getOldStateId(), $comparison);
        } elseif ($stateLog instanceof ObjectCollection) {
            return $this
                ->useStateLogRelatedByOldStateIdQuery()
                ->filterByPrimaryKeys($stateLog->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByStateLogRelatedByOldStateId() only accepts arguments of type \Shop\Infrastructure\Models\StateLog\StateLog or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the StateLogRelatedByOldStateId relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildStateQuery The current query, for fluid interface
     */
    public function joinStateLogRelatedByOldStateId($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('StateLogRelatedByOldStateId');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'StateLogRelatedByOldStateId');
        }

        return $this;
    }

    /**
     * Use the StateLogRelatedByOldStateId relation StateLog object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\StateLog\StateLogQuery A secondary query class using the current class as primary query
     */
    public function useStateLogRelatedByOldStateIdQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinStateLogRelatedByOldStateId($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'StateLogRelatedByOldStateId', '\Shop\Infrastructure\Models\StateLog\StateLogQuery');
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\StateLog\StateLog object
     *
     * @param \Shop\Infrastructure\Models\StateLog\StateLog|ObjectCollection $stateLog the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildStateQuery The current query, for fluid interface
     */
    public function filterByStateLogRelatedByNewStateId($stateLog, $comparison = null)
    {
        if ($stateLog instanceof \Shop\Infrastructure\Models\StateLog\StateLog) {
            return $this
                ->addUsingAlias(StateTableMap::COL_ID, $stateLog->getNewStateId(), $comparison);
        } elseif ($stateLog instanceof ObjectCollection) {
            return $this
                ->useStateLogRelatedByNewStateIdQuery()
                ->filterByPrimaryKeys($stateLog->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByStateLogRelatedByNewStateId() only accepts arguments of type \Shop\Infrastructure\Models\StateLog\StateLog or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the StateLogRelatedByNewStateId relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildStateQuery The current query, for fluid interface
     */
    public function joinStateLogRelatedByNewStateId($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('StateLogRelatedByNewStateId');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'StateLogRelatedByNewStateId');
        }

        return $this;
    }

    /**
     * Use the StateLogRelatedByNewStateId relation StateLog object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\StateLog\StateLogQuery A secondary query class using the current class as primary query
     */
    public function useStateLogRelatedByNewStateIdQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinStateLogRelatedByNewStateId($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'StateLogRelatedByNewStateId', '\Shop\Infrastructure\Models\StateLog\StateLogQuery');
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Order\Order object
     *
     * @param \Shop\Infrastructure\Models\Order\Order|ObjectCollection $order the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildStateQuery The current query, for fluid interface
     */
    public function filterByOrder($order, $comparison = null)
    {
        if ($order instanceof \Shop\Infrastructure\Models\Order\Order) {
            return $this
                ->addUsingAlias(StateTableMap::COL_ID, $order->getStateId(), $comparison);
        } elseif ($order instanceof ObjectCollection) {
            return $this
                ->useOrderQuery()
                ->filterByPrimaryKeys($order->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByOrder() only accepts arguments of type \Shop\Infrastructure\Models\Order\Order or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Order relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildStateQuery The current query, for fluid interface
     */
    public function joinOrder($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Order');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Order');
        }

        return $this;
    }

    /**
     * Use the Order relation Order object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Order\OrderQuery A secondary query class using the current class as primary query
     */
    public function useOrderQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinOrder($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Order', '\Shop\Infrastructure\Models\Order\OrderQuery');
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\OrderItem\OrderItem object
     *
     * @param \Shop\Infrastructure\Models\OrderItem\OrderItem|ObjectCollection $orderItem the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildStateQuery The current query, for fluid interface
     */
    public function filterByOrderItem($orderItem, $comparison = null)
    {
        if ($orderItem instanceof \Shop\Infrastructure\Models\OrderItem\OrderItem) {
            return $this
                ->addUsingAlias(StateTableMap::COL_ID, $orderItem->getStateId(), $comparison);
        } elseif ($orderItem instanceof ObjectCollection) {
            return $this
                ->useOrderItemQuery()
                ->filterByPrimaryKeys($orderItem->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByOrderItem() only accepts arguments of type \Shop\Infrastructure\Models\OrderItem\OrderItem or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the OrderItem relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildStateQuery The current query, for fluid interface
     */
    public function joinOrderItem($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('OrderItem');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'OrderItem');
        }

        return $this;
    }

    /**
     * Use the OrderItem relation OrderItem object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\OrderItem\OrderItemQuery A secondary query class using the current class as primary query
     */
    public function useOrderItemQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinOrderItem($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'OrderItem', '\Shop\Infrastructure\Models\OrderItem\OrderItemQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildState $state Object to remove from the list of results
     *
     * @return $this|ChildStateQuery The current query, for fluid interface
     */
    public function prune($state = null)
    {
        if ($state) {
            $this->addUsingAlias(StateTableMap::COL_ID, $state->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     ConnectionInterface $con The connection object used by the query
     */
    protected function basePreDelete(ConnectionInterface $con)
    {
        // archivable behavior

        if ($this->archiveOnDelete) {
            $this->archive($con);
        } else {
            $this->archiveOnDelete = true;
        }


        return $this->preDelete($con);
    }

    /**
     * Deletes all rows from the shop_states table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(StateTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            StateTableMap::clearInstancePool();
            StateTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(StateTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(StateTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            StateTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            StateTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    // archivable behavior

    /**
     * Copy the data of the objects satisfying the query into ChildShopStatesArchive archive objects.
     * The archived objects are then saved.
     * If any of the objects has already been archived, the archived object
     * is updated and not duplicated.
     * Warning: This termination methods issues 2n+1 queries.
     *
     * @param      ConnectionInterface $con    Connection to use.
     * @param      Boolean $useLittleMemory    Whether or not to use OnDemandFormatter to retrieve objects.
     *               Set to false if the identity map matters.
     *               Set to true (default) to use less memory.
     *
     * @return     int the number of archived objects
     */
    public function archive($con = null, $useLittleMemory = true)
    {
        $criteria = clone $this;
        // prepare the query
        $criteria->setWith(array());
        if ($useLittleMemory) {
            $criteria->setFormatter(ModelCriteria::FORMAT_ON_DEMAND);
        }
        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(StateTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con, $criteria) {
            $totalArchivedObjects = 0;

            // archive all results one by one
            foreach ($criteria->find($con) as $object) {
                $object->archive($con);
                $totalArchivedObjects++;
            }

            return $totalArchivedObjects;
        });
    }

    /**
     * Enable/disable auto-archiving on delete for the next query.
     *
     * @param boolean True if the query must archive deleted objects, false otherwise.
     */
    public function setArchiveOnDelete($archiveOnDelete)
    {
        $this->archiveOnDelete = $archiveOnDelete;
    }

    /**
     * Delete records matching the current query without archiving them.
     *
     * @param      ConnectionInterface $con    Connection to use.
     *
     * @return integer the number of deleted rows
     */
    public function deleteWithoutArchive($con = null)
    {
        $this->archiveOnDelete = false;

        return $this->delete($con);
    }

    /**
     * Delete all records without archiving them.
     *
     * @param      ConnectionInterface $con    Connection to use.
     *
     * @return integer the number of deleted rows
     */
    public function deleteAllWithoutArchive($con = null)
    {
        $this->archiveOnDelete = false;

        return $this->deleteAll($con);
    }

} // StateQuery
