<?php

namespace Shop\Infrastructure\Models\Currency\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Infrastructure\Models\Currency\ShopCurrenciesArchive as ChildShopCurrenciesArchive;
use Shop\Infrastructure\Models\Currency\ShopCurrenciesArchiveQuery as ChildShopCurrenciesArchiveQuery;
use Shop\Infrastructure\Models\Currency\Map\ShopCurrenciesArchiveTableMap;

/**
 * Base class that represents a query for the 'shop_currencies_archive' table.
 *
 *
 *
 * @method     ChildShopCurrenciesArchiveQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildShopCurrenciesArchiveQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method     ChildShopCurrenciesArchiveQuery orderByNative($order = Criteria::ASC) Order by the native column
 * @method     ChildShopCurrenciesArchiveQuery orderByPosition($order = Criteria::ASC) Order by the position column
 * @method     ChildShopCurrenciesArchiveQuery orderByHtmlSign($order = Criteria::ASC) Order by the html_sign column
 * @method     ChildShopCurrenciesArchiveQuery orderByRoundPrice($order = Criteria::ASC) Order by the round_price column
 * @method     ChildShopCurrenciesArchiveQuery orderByDisplayed($order = Criteria::ASC) Order by the displayed column
 * @method     ChildShopCurrenciesArchiveQuery orderByIso($order = Criteria::ASC) Order by the iso column
 * @method     ChildShopCurrenciesArchiveQuery orderByRbkSync($order = Criteria::ASC) Order by the rbk_sync column
 * @method     ChildShopCurrenciesArchiveQuery orderByRoundMode($order = Criteria::ASC) Order by the round_mode column
 * @method     ChildShopCurrenciesArchiveQuery orderByArchivedAt($order = Criteria::ASC) Order by the archived_at column
 *
 * @method     ChildShopCurrenciesArchiveQuery groupById() Group by the id column
 * @method     ChildShopCurrenciesArchiveQuery groupByName() Group by the name column
 * @method     ChildShopCurrenciesArchiveQuery groupByNative() Group by the native column
 * @method     ChildShopCurrenciesArchiveQuery groupByPosition() Group by the position column
 * @method     ChildShopCurrenciesArchiveQuery groupByHtmlSign() Group by the html_sign column
 * @method     ChildShopCurrenciesArchiveQuery groupByRoundPrice() Group by the round_price column
 * @method     ChildShopCurrenciesArchiveQuery groupByDisplayed() Group by the displayed column
 * @method     ChildShopCurrenciesArchiveQuery groupByIso() Group by the iso column
 * @method     ChildShopCurrenciesArchiveQuery groupByRbkSync() Group by the rbk_sync column
 * @method     ChildShopCurrenciesArchiveQuery groupByRoundMode() Group by the round_mode column
 * @method     ChildShopCurrenciesArchiveQuery groupByArchivedAt() Group by the archived_at column
 *
 * @method     ChildShopCurrenciesArchiveQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildShopCurrenciesArchiveQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildShopCurrenciesArchiveQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildShopCurrenciesArchiveQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildShopCurrenciesArchiveQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildShopCurrenciesArchiveQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildShopCurrenciesArchive findOne(ConnectionInterface $con = null) Return the first ChildShopCurrenciesArchive matching the query
 * @method     ChildShopCurrenciesArchive findOneOrCreate(ConnectionInterface $con = null) Return the first ChildShopCurrenciesArchive matching the query, or a new ChildShopCurrenciesArchive object populated from the query conditions when no match is found
 *
 * @method     ChildShopCurrenciesArchive findOneById(int $id) Return the first ChildShopCurrenciesArchive filtered by the id column
 * @method     ChildShopCurrenciesArchive findOneByName(string $name) Return the first ChildShopCurrenciesArchive filtered by the name column
 * @method     ChildShopCurrenciesArchive findOneByNative(string $native) Return the first ChildShopCurrenciesArchive filtered by the native column
 * @method     ChildShopCurrenciesArchive findOneByPosition(int $position) Return the first ChildShopCurrenciesArchive filtered by the position column
 * @method     ChildShopCurrenciesArchive findOneByHtmlSign(string $html_sign) Return the first ChildShopCurrenciesArchive filtered by the html_sign column
 * @method     ChildShopCurrenciesArchive findOneByRoundPrice(int $round_price) Return the first ChildShopCurrenciesArchive filtered by the round_price column
 * @method     ChildShopCurrenciesArchive findOneByDisplayed(string $displayed) Return the first ChildShopCurrenciesArchive filtered by the displayed column
 * @method     ChildShopCurrenciesArchive findOneByIso(string $iso) Return the first ChildShopCurrenciesArchive filtered by the iso column
 * @method     ChildShopCurrenciesArchive findOneByRbkSync(string $rbk_sync) Return the first ChildShopCurrenciesArchive filtered by the rbk_sync column
 * @method     ChildShopCurrenciesArchive findOneByRoundMode(string $round_mode) Return the first ChildShopCurrenciesArchive filtered by the round_mode column
 * @method     ChildShopCurrenciesArchive findOneByArchivedAt(string $archived_at) Return the first ChildShopCurrenciesArchive filtered by the archived_at column *

 * @method     ChildShopCurrenciesArchive requirePk($key, ConnectionInterface $con = null) Return the ChildShopCurrenciesArchive by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopCurrenciesArchive requireOne(ConnectionInterface $con = null) Return the first ChildShopCurrenciesArchive matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildShopCurrenciesArchive requireOneById(int $id) Return the first ChildShopCurrenciesArchive filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopCurrenciesArchive requireOneByName(string $name) Return the first ChildShopCurrenciesArchive filtered by the name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopCurrenciesArchive requireOneByNative(string $native) Return the first ChildShopCurrenciesArchive filtered by the native column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopCurrenciesArchive requireOneByPosition(int $position) Return the first ChildShopCurrenciesArchive filtered by the position column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopCurrenciesArchive requireOneByHtmlSign(string $html_sign) Return the first ChildShopCurrenciesArchive filtered by the html_sign column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopCurrenciesArchive requireOneByRoundPrice(int $round_price) Return the first ChildShopCurrenciesArchive filtered by the round_price column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopCurrenciesArchive requireOneByDisplayed(string $displayed) Return the first ChildShopCurrenciesArchive filtered by the displayed column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopCurrenciesArchive requireOneByIso(string $iso) Return the first ChildShopCurrenciesArchive filtered by the iso column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopCurrenciesArchive requireOneByRbkSync(string $rbk_sync) Return the first ChildShopCurrenciesArchive filtered by the rbk_sync column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopCurrenciesArchive requireOneByRoundMode(string $round_mode) Return the first ChildShopCurrenciesArchive filtered by the round_mode column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopCurrenciesArchive requireOneByArchivedAt(string $archived_at) Return the first ChildShopCurrenciesArchive filtered by the archived_at column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildShopCurrenciesArchive[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildShopCurrenciesArchive objects based on current ModelCriteria
 * @method     ChildShopCurrenciesArchive[]|ObjectCollection findById(int $id) Return ChildShopCurrenciesArchive objects filtered by the id column
 * @method     ChildShopCurrenciesArchive[]|ObjectCollection findByName(string $name) Return ChildShopCurrenciesArchive objects filtered by the name column
 * @method     ChildShopCurrenciesArchive[]|ObjectCollection findByNative(string $native) Return ChildShopCurrenciesArchive objects filtered by the native column
 * @method     ChildShopCurrenciesArchive[]|ObjectCollection findByPosition(int $position) Return ChildShopCurrenciesArchive objects filtered by the position column
 * @method     ChildShopCurrenciesArchive[]|ObjectCollection findByHtmlSign(string $html_sign) Return ChildShopCurrenciesArchive objects filtered by the html_sign column
 * @method     ChildShopCurrenciesArchive[]|ObjectCollection findByRoundPrice(int $round_price) Return ChildShopCurrenciesArchive objects filtered by the round_price column
 * @method     ChildShopCurrenciesArchive[]|ObjectCollection findByDisplayed(string $displayed) Return ChildShopCurrenciesArchive objects filtered by the displayed column
 * @method     ChildShopCurrenciesArchive[]|ObjectCollection findByIso(string $iso) Return ChildShopCurrenciesArchive objects filtered by the iso column
 * @method     ChildShopCurrenciesArchive[]|ObjectCollection findByRbkSync(string $rbk_sync) Return ChildShopCurrenciesArchive objects filtered by the rbk_sync column
 * @method     ChildShopCurrenciesArchive[]|ObjectCollection findByRoundMode(string $round_mode) Return ChildShopCurrenciesArchive objects filtered by the round_mode column
 * @method     ChildShopCurrenciesArchive[]|ObjectCollection findByArchivedAt(string $archived_at) Return ChildShopCurrenciesArchive objects filtered by the archived_at column
 * @method     ChildShopCurrenciesArchive[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class ShopCurrenciesArchiveQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Infrastructure\Models\Currency\Base\ShopCurrenciesArchiveQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\Currency\\ShopCurrenciesArchive', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildShopCurrenciesArchiveQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildShopCurrenciesArchiveQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildShopCurrenciesArchiveQuery) {
            return $criteria;
        }
        $query = new ChildShopCurrenciesArchiveQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildShopCurrenciesArchive|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(ShopCurrenciesArchiveTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = ShopCurrenciesArchiveTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildShopCurrenciesArchive A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `name`, `native`, `position`, `html_sign`, `round_price`, `displayed`, `iso`, `rbk_sync`, `round_mode`, `archived_at` FROM `shop_currencies_archive` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildShopCurrenciesArchive $obj */
            $obj = new ChildShopCurrenciesArchive();
            $obj->hydrate($row);
            ShopCurrenciesArchiveTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildShopCurrenciesArchive|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildShopCurrenciesArchiveQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ShopCurrenciesArchiveTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildShopCurrenciesArchiveQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ShopCurrenciesArchiveTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopCurrenciesArchiveQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(ShopCurrenciesArchiveTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(ShopCurrenciesArchiveTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopCurrenciesArchiveTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%', Criteria::LIKE); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopCurrenciesArchiveQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopCurrenciesArchiveTableMap::COL_NAME, $name, $comparison);
    }

    /**
     * Filter the query on the native column
     *
     * Example usage:
     * <code>
     * $query->filterByNative('fooValue');   // WHERE native = 'fooValue'
     * $query->filterByNative('%fooValue%', Criteria::LIKE); // WHERE native LIKE '%fooValue%'
     * </code>
     *
     * @param     string $native The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopCurrenciesArchiveQuery The current query, for fluid interface
     */
    public function filterByNative($native = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($native)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopCurrenciesArchiveTableMap::COL_NATIVE, $native, $comparison);
    }

    /**
     * Filter the query on the position column
     *
     * Example usage:
     * <code>
     * $query->filterByPosition(1234); // WHERE position = 1234
     * $query->filterByPosition(array(12, 34)); // WHERE position IN (12, 34)
     * $query->filterByPosition(array('min' => 12)); // WHERE position > 12
     * </code>
     *
     * @param     mixed $position The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopCurrenciesArchiveQuery The current query, for fluid interface
     */
    public function filterByPosition($position = null, $comparison = null)
    {
        if (is_array($position)) {
            $useMinMax = false;
            if (isset($position['min'])) {
                $this->addUsingAlias(ShopCurrenciesArchiveTableMap::COL_POSITION, $position['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($position['max'])) {
                $this->addUsingAlias(ShopCurrenciesArchiveTableMap::COL_POSITION, $position['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopCurrenciesArchiveTableMap::COL_POSITION, $position, $comparison);
    }

    /**
     * Filter the query on the html_sign column
     *
     * Example usage:
     * <code>
     * $query->filterByHtmlSign('fooValue');   // WHERE html_sign = 'fooValue'
     * $query->filterByHtmlSign('%fooValue%', Criteria::LIKE); // WHERE html_sign LIKE '%fooValue%'
     * </code>
     *
     * @param     string $htmlSign The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopCurrenciesArchiveQuery The current query, for fluid interface
     */
    public function filterByHtmlSign($htmlSign = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($htmlSign)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopCurrenciesArchiveTableMap::COL_HTML_SIGN, $htmlSign, $comparison);
    }

    /**
     * Filter the query on the round_price column
     *
     * Example usage:
     * <code>
     * $query->filterByRoundPrice(1234); // WHERE round_price = 1234
     * $query->filterByRoundPrice(array(12, 34)); // WHERE round_price IN (12, 34)
     * $query->filterByRoundPrice(array('min' => 12)); // WHERE round_price > 12
     * </code>
     *
     * @param     mixed $roundPrice The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopCurrenciesArchiveQuery The current query, for fluid interface
     */
    public function filterByRoundPrice($roundPrice = null, $comparison = null)
    {
        if (is_array($roundPrice)) {
            $useMinMax = false;
            if (isset($roundPrice['min'])) {
                $this->addUsingAlias(ShopCurrenciesArchiveTableMap::COL_ROUND_PRICE, $roundPrice['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($roundPrice['max'])) {
                $this->addUsingAlias(ShopCurrenciesArchiveTableMap::COL_ROUND_PRICE, $roundPrice['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopCurrenciesArchiveTableMap::COL_ROUND_PRICE, $roundPrice, $comparison);
    }

    /**
     * Filter the query on the displayed column
     *
     * Example usage:
     * <code>
     * $query->filterByDisplayed('fooValue');   // WHERE displayed = 'fooValue'
     * $query->filterByDisplayed('%fooValue%', Criteria::LIKE); // WHERE displayed LIKE '%fooValue%'
     * </code>
     *
     * @param     string $displayed The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopCurrenciesArchiveQuery The current query, for fluid interface
     */
    public function filterByDisplayed($displayed = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($displayed)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopCurrenciesArchiveTableMap::COL_DISPLAYED, $displayed, $comparison);
    }

    /**
     * Filter the query on the iso column
     *
     * Example usage:
     * <code>
     * $query->filterByIso('fooValue');   // WHERE iso = 'fooValue'
     * $query->filterByIso('%fooValue%', Criteria::LIKE); // WHERE iso LIKE '%fooValue%'
     * </code>
     *
     * @param     string $iso The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopCurrenciesArchiveQuery The current query, for fluid interface
     */
    public function filterByIso($iso = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($iso)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopCurrenciesArchiveTableMap::COL_ISO, $iso, $comparison);
    }

    /**
     * Filter the query on the rbk_sync column
     *
     * Example usage:
     * <code>
     * $query->filterByRbkSync('fooValue');   // WHERE rbk_sync = 'fooValue'
     * $query->filterByRbkSync('%fooValue%', Criteria::LIKE); // WHERE rbk_sync LIKE '%fooValue%'
     * </code>
     *
     * @param     string $rbkSync The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopCurrenciesArchiveQuery The current query, for fluid interface
     */
    public function filterByRbkSync($rbkSync = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($rbkSync)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopCurrenciesArchiveTableMap::COL_RBK_SYNC, $rbkSync, $comparison);
    }

    /**
     * Filter the query on the round_mode column
     *
     * Example usage:
     * <code>
     * $query->filterByRoundMode('fooValue');   // WHERE round_mode = 'fooValue'
     * $query->filterByRoundMode('%fooValue%', Criteria::LIKE); // WHERE round_mode LIKE '%fooValue%'
     * </code>
     *
     * @param     string $roundMode The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopCurrenciesArchiveQuery The current query, for fluid interface
     */
    public function filterByRoundMode($roundMode = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($roundMode)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopCurrenciesArchiveTableMap::COL_ROUND_MODE, $roundMode, $comparison);
    }

    /**
     * Filter the query on the archived_at column
     *
     * Example usage:
     * <code>
     * $query->filterByArchivedAt('2011-03-14'); // WHERE archived_at = '2011-03-14'
     * $query->filterByArchivedAt('now'); // WHERE archived_at = '2011-03-14'
     * $query->filterByArchivedAt(array('max' => 'yesterday')); // WHERE archived_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $archivedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopCurrenciesArchiveQuery The current query, for fluid interface
     */
    public function filterByArchivedAt($archivedAt = null, $comparison = null)
    {
        if (is_array($archivedAt)) {
            $useMinMax = false;
            if (isset($archivedAt['min'])) {
                $this->addUsingAlias(ShopCurrenciesArchiveTableMap::COL_ARCHIVED_AT, $archivedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($archivedAt['max'])) {
                $this->addUsingAlias(ShopCurrenciesArchiveTableMap::COL_ARCHIVED_AT, $archivedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopCurrenciesArchiveTableMap::COL_ARCHIVED_AT, $archivedAt, $comparison);
    }

    /**
     * Exclude object from result
     *
     * @param   ChildShopCurrenciesArchive $shopCurrenciesArchive Object to remove from the list of results
     *
     * @return $this|ChildShopCurrenciesArchiveQuery The current query, for fluid interface
     */
    public function prune($shopCurrenciesArchive = null)
    {
        if ($shopCurrenciesArchive) {
            $this->addUsingAlias(ShopCurrenciesArchiveTableMap::COL_ID, $shopCurrenciesArchive->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_currencies_archive table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopCurrenciesArchiveTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ShopCurrenciesArchiveTableMap::clearInstancePool();
            ShopCurrenciesArchiveTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopCurrenciesArchiveTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(ShopCurrenciesArchiveTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            ShopCurrenciesArchiveTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            ShopCurrenciesArchiveTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // ShopCurrenciesArchiveQuery
