<?php


namespace Shop\Presentation\Modules\AdminProviders;


use ActiveTable\DataTableEngine;
use Core\Form\ControlBuilder;
use Core\Form\NiftyControlBuilder;
use Diamond\Helpers\Form;
use Repo\CrudRepositoryBuilderInterface;
use Shop\Infrastructure\Models\Customer\Customer;
use Shop\Presentation\Config\Main;
use Shop\Domain\City\CityCollection;
use Shop\Domain\Region\RegionCollection;
use Shop\Domain\Stock\Contracts\StockEntityInterface;
use Shop\Infrastructure\Repositories\City\CityCriteria;
use Shop\Infrastructure\Repositories\Country\CountryCriteria;
use Shop\Infrastructure\Repositories\Provider\ProviderRepository;
use Shop\Infrastructure\Repositories\Region\RegionCriteria;

trait ContractorFormTrait
{
    


    /**
     * @param DataTableEngine $table
     * @param CrudRepositoryBuilderInterface $repo
     */
    public function makeContractorForm(DataTableEngine $table, CrudRepositoryBuilderInterface $repo): void
    {
        $contractorName = '- укажите контрагента -';
        $contractor =null;

        $entity = $table->loadFormEntity();

        if($entity !== null && $entity->getContractor() !== null){
            $contractor = $entity->getContractor();
            $contractorName = $contractor->getName();
        }

        $table
            ->addField(
                $this->controlBuilder
                    ->buildWindowSelect('contractorId', '/admin/shop/stocks/contractors-lite?filter=1', $contractorName)
                ->setValue('NULL'),true
            );

return;

        $cities = new CityCollection();
        $regions = new RegionCollection();
        $regionId = $cityId = $countryId = null;

        $countries = $this->countryRepository->findByCriteria(
            CountryCriteria::create()
        );

        /** @var  Customer $contractor */
        if ($contractor !== null && $contractor->getCityId()) {
            $cityId = $contractor->getCityId();

            $city = $contractor->getCustomerCity();
            $regionId = $city->getRegionId();

            $countryId = $city->getCityRegion()->getCountryId();

            $cities = $this->cityRepository->findByCriteria(
                CityCriteria::create()->setFilterByRegionId($regionId)
            );
            $regions = $this->regionRepository->findByCriteria(
                RegionCriteria::create()
                    ->setFilterByCountryId($countryId)
                    ->setSortByName('ASC')
            );
        }


        if (input_post('countryId') > 0) {
            $cityId = input_post('countryId');
            $regions = $this->regionRepository->findByCriteria(
                RegionCriteria::create()->setFilterByCountryId($cityId)
            );
        }

        if (input_post('regionId') > 0) {
            $regionId = input_post('regionId');
            $cities = $this->cityRepository->findByCriteria(
                CityCriteria::create()->setFilterByRegionId($regionId)->setSortByName('ASC')
            );
        }
//dump($cityId);
        //PHONE MASK
        $masks = [];
        foreach ($countries as $country) {
            if (empty($country->getPhoneMask())) {
                continue;
            }
            $masks[$country->getId()] = $country->getPhoneMask();
        }

        $table
            ->addField(
                $this->controlBuilder->buildFormHeader('Адрес', 'address')
            )
            ->addField(
                $this
                    ->controlBuilder
                    ->buildNiftyDropdownChosen('countryId', Form::prepareDropdown($countries, 'страну'))
                    ->setValue($countryId)
                    ->onChange("select_region(this,'regionId',0,'#phoneMask')")
                    ->setId('countryId'),
                false,
                'Страна'
            )
            ->addField(
                $this
                    ->controlBuilder
                    ->buildNiftyDropdownChosen('regionId', Form::prepareDropdown($regions, 'регион'))
                    ->setValue($regionId)
                    ->onChange("select_city(this,'cityId')"),
                false,
                'Область'
            )
            ->addField(
                $this
                    ->controlBuilder
                    ->buildNiftyDropdownChosen('cityId', Form::prepareDropdown($cities, 'город'))
                    ->setValue($cityId),
                true,
                'Город'
            );


    }

}