<?php

namespace Shop\Presentation\Modules\AdminProductGroups;

use ActiveTable\ColumnTable;
use Core\Form\ControlBuilder;
use DiamondTable\TableFactory;
use Shop\Infrastructure\Repositories\ProductGroup\ProductGroupCriteria;
use Shop\Infrastructure\Repositories\ProductGroup\ProductGroupRepository;

/**
 * Description of AdminProductGroups
 *
 * @author Diamond Code Generator
 */
class AdminProductGroups extends \Core\ModuleController
{

    protected $productGroupRepository;
    protected $tableFactory;
    protected $controlBuilder;

    public function __construct(ProductGroupRepository $productGroupRepository, TableFactory $tableFactory,
                                ControlBuilder $controlBuilder)
    {

        $this->productGroupRepository = $productGroupRepository;
        $this->tableFactory = $tableFactory;
        $this->controlBuilder = $controlBuilder;
    }

    /**
     * @return string
     * @throws \ReflectionException
     */
    public function process(): string
    {
        $table = $this->tableFactory->buildAdminTable($this->productGroupRepository, ProductGroupCriteria::create());

        $table
            ->setDefaultSortColumn('id', 'desc')
            ->addColumn(
                (new ColumnTable('id', '№'))->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('name', 'Название'))
            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setFormat($this->tableFactory, 'formatActions')
                    ->setWidth(120)
            );

        $table
            ->addField(
                $this->controlBuilder->buildInput('name'), true
            );
        return $table->render();
    }

}